/*
 * Decompiled with CFR 0.152.
 */
package jnasmartcardio;

import com.sun.jna.FunctionMapper;
import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class Winscard {
    public static final String WINDOWS_PATH = "WinSCard.dll";
    public static final String MAC_PATH = "/System/Library/Frameworks/PCSC.framework/PCSC";
    public static final String PCSC_PATH = "libpcsclite.so.1";

    Winscard() {
    }

    public static WinscardLibInfo openLib() {
        String libraryName = Platform.isWindows() ? WINDOWS_PATH : (Platform.isMac() ? MAC_PATH : PCSC_PATH);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (Platform.isWindows()) {
            options.put("function-mapper", new WindowsFunctionMapper());
        } else if (Platform.isMac()) {
            options.put("function-mapper", new MacFunctionMapper());
        }
        WinscardLibrary lib = (WinscardLibrary)Native.load((String)libraryName, WinscardLibrary.class, options);
        NativeLibrary nativeLibrary = NativeLibrary.getInstance((String)libraryName);
        ScardIoRequest SCARD_PCI_T0 = new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardT0Pci"));
        ScardIoRequest SCARD_PCI_T1 = new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardT1Pci"));
        ScardIoRequest SCARD_PCI_RAW = new ScardIoRequest(nativeLibrary.getGlobalVariableAddress("g_rgSCardRawPci"));
        SCARD_PCI_T0.read();
        SCARD_PCI_T1.read();
        SCARD_PCI_RAW.read();
        SCARD_PCI_T0.setAutoSynch(false);
        SCARD_PCI_T1.setAutoSynch(false);
        SCARD_PCI_RAW.setAutoSynch(false);
        return new WinscardLibInfo(lib, SCARD_PCI_T0, SCARD_PCI_T1, SCARD_PCI_RAW);
    }

    private static class WindowsFunctionMapper
    implements FunctionMapper {
        static final Set<String> asciiSuffixNames = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SCardListReaderGroups", "SCardListReaders", "SCardGetStatusChange", "SCardConnect", "SCardStatus")));

        private WindowsFunctionMapper() {
        }

        public String getFunctionName(NativeLibrary library, Method method) {
            Object name = method.getName();
            if (asciiSuffixNames.contains(name)) {
                name = (String)name + "A";
            }
            return name;
        }
    }

    private static class MacFunctionMapper
    implements FunctionMapper {
        private MacFunctionMapper() {
        }

        public String getFunctionName(NativeLibrary library, Method method) {
            String name = method.getName();
            if ("SCardControl".equals(name)) {
                name = "SCardControl132";
            }
            return name;
        }
    }

    public static interface WinscardLibrary
    extends Library {
        public Dword SCardEstablishContext(Dword var1, Pointer var2, Pointer var3, SCardContextByReference var4);

        public Dword SCardReleaseContext(SCardContext var1);

        public Dword SCardConnect(SCardContext var1, String var2, Dword var3, Dword var4, SCardHandleByReference var5, DwordByReference var6);

        public Dword SCardReconnect(SCardHandle var1, Dword var2, Dword var3, Dword var4, DwordByReference var5);

        public Dword SCardDisconnect(SCardHandle var1, Dword var2);

        public Dword SCardBeginTransaction(SCardHandle var1);

        public Dword SCardEndTransaction(SCardHandle var1, Dword var2);

        public Dword SCardStatus(SCardHandle var1, ByteBuffer var2, DwordByReference var3, DwordByReference var4, DwordByReference var5, ByteBuffer var6, DwordByReference var7);

        public Dword SCardGetStatusChange(SCardContext var1, Dword var2, SCardReaderState[] var3, Dword var4);

        public Dword SCardControl(SCardHandle var1, Dword var2, ByteBuffer var3, Dword var4, ByteBuffer var5, Dword var6, DwordByReference var7);

        public Dword SCardGetAttrib(SCardHandle var1, Dword var2, ByteBuffer var3, DwordByReference var4);

        public Dword SCardSetAttrib(SCardHandle var1, Dword var2, ByteBuffer var3, Dword var4);

        public Dword SCardTransmit(SCardHandle var1, ScardIoRequest var2, ByteBuffer var3, Dword var4, ScardIoRequest var5, ByteBuffer var6, DwordByReference var7);

        public Dword SCardListReaders(SCardContext var1, ByteBuffer var2, ByteBuffer var3, DwordByReference var4);

        public Dword SCardFreeMemory(SCardContext var1, Pointer var2);

        public Dword SCardListReaderGroups(SCardContext var1, ByteBuffer var2, DwordByReference var3);

        public Dword SCardCancel(SCardContext var1);

        public Dword SCardIsValidContext(SCardContext var1);
    }

    public static class ScardIoRequest
    extends Structure {
        public Dword dwProtocol;
        public Dword cbPciLength;

        public ScardIoRequest() {
        }

        public ScardIoRequest(Pointer p) {
            super(p);
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("dwProtocol", "cbPciLength");
        }

        public String toString() {
            return String.format("%s{dwProtocol: %s, cbPciLength: %s}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.dwProtocol, this.cbPciLength});
        }
    }

    public static class WinscardLibInfo {
        public final WinscardLibrary lib;
        public final ScardIoRequest SCARD_PCI_T0;
        public final ScardIoRequest SCARD_PCI_T1;
        public final ScardIoRequest SCARD_PCI_RAW;

        public WinscardLibInfo(WinscardLibrary lib, ScardIoRequest SCARD_PCI_T0, ScardIoRequest SCARD_PCI_T1, ScardIoRequest SCARD_PCI_RAW) {
            this.lib = lib;
            this.SCARD_PCI_T0 = SCARD_PCI_T0;
            this.SCARD_PCI_T1 = SCARD_PCI_T1;
            this.SCARD_PCI_RAW = SCARD_PCI_RAW;
        }
    }

    public static class SCardReaderState
    extends Structure {
        private static final int ALIGN = Platform.isMac() ? 1 : 0;
        public String szReader;
        public Pointer pvUserData;
        public Dword dwCurrentState;
        public Dword dwEventState;
        public Dword cbAtr;
        public byte[] rgbAtr = new byte[33];

        public SCardReaderState() {
            super(null, ALIGN);
            this.dwEventState = this.cbAtr = new Dword(0L);
            this.dwCurrentState = this.cbAtr;
        }

        public SCardReaderState(String szReader) {
            this();
            this.szReader = szReader;
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("szReader", "pvUserData", "dwCurrentState", "dwEventState", "cbAtr", "rgbAtr");
        }
    }

    public static class SCardHandleByReference
    extends HandleByReference {
        public SCardHandle getValue() {
            return new SCardHandle(this.getLong());
        }

        public void setValue(SCardHandle context) {
            this.setLong(context.longValue());
        }
    }

    public static class SCardHandle
    extends Handle {
        private static final long serialVersionUID = 1L;

        public SCardHandle() {
            this(0L);
        }

        public SCardHandle(long value) {
            super(value);
        }
    }

    public static class SCardContextByReference
    extends HandleByReference {
        public SCardContext getValue() {
            return new SCardContext(this.getLong());
        }

        public void setValue(SCardContext context) {
            this.setLong(context.longValue());
        }
    }

    public static class SCardContext
    extends Handle {
        private static final long serialVersionUID = 1L;

        public SCardContext() {
            this(0L);
        }

        public SCardContext(long value) {
            super(value);
        }
    }

    public static class HandleByReference
    extends ByReference {
        public HandleByReference() {
            super(Handle.SIZE);
        }

        protected long getLong() {
            long v = Handle.SIZE == 4 ? (long)this.getPointer().getInt(0L) : this.getPointer().getLong(0L);
            return v;
        }

        protected void setLong(long value) {
            if (Handle.SIZE == 4) {
                this.getPointer().setInt(0L, (int)value);
            } else {
                this.getPointer().setLong(0L, value);
            }
        }
    }

    public static class Handle
    extends IntegerType {
        private static final long serialVersionUID = 1L;
        public static final int SIZE = Platform.isWindows() ? Native.POINTER_SIZE : Dword.SIZE;

        public Handle(long value) {
            super(SIZE, value);
        }

        public String toString() {
            return String.format("%s{%x}", ((Object)((Object)this)).getClass().getSimpleName(), this.longValue());
        }
    }

    public static class DwordByReference
    extends ByReference {
        public static final int SIZE = Platform.isWindows() || Platform.isMac() ? 4 : NativeLong.SIZE;

        public DwordByReference() {
            this(new Dword());
        }

        public DwordByReference(Dword value) {
            super(Dword.SIZE);
            this.setValue(value);
        }

        public void setValue(Dword value) {
            if (Dword.SIZE == 4) {
                this.getPointer().setInt(0L, value.intValue());
            } else {
                this.getPointer().setLong(0L, value.longValue());
            }
        }

        public Dword getValue() {
            long v = Dword.SIZE == 4 ? 0xFFFFFFFFL & (long)this.getPointer().getInt(0L) : this.getPointer().getLong(0L);
            return new Dword(v);
        }
    }

    public static class Dword
    extends IntegerType {
        public static final int SIZE = Platform.isWindows() || Platform.isMac() ? 4 : NativeLong.SIZE;
        private static final long serialVersionUID = 1L;

        public Dword() {
            this(0L);
        }

        public Dword(long value) {
            super(SIZE, value);
        }

        public String toString() {
            return String.format("%d", this.longValue());
        }
    }
}

