/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc;

import apdu4j.core.AsynchronousBIBO;
import apdu4j.core.BIBO;
import apdu4j.core.BIBOException;
import apdu4j.core.HexUtils;
import apdu4j.core.TagRemovedException;
import apdu4j.pcsc.SCard;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardBIBO
implements BIBO,
AsynchronousBIBO {
    private static final Logger logger = LoggerFactory.getLogger(CardBIBO.class);
    public static final String PROP_APDU4J_PSEUDOAPDU = "apdu4j.pseudoapdu";
    public static final String PROP_APDU4J_PCSC_RESET = "apdu4j.pcsc.reset";
    protected final Card card;
    private volatile boolean closed = false;
    public boolean pseudo = Boolean.getBoolean(System.getProperty("apdu4j.pseudoapdu", System.getenv().getOrDefault(CardBIBO.prop2env("apdu4j.pseudoapdu"), Boolean.TRUE.toString())));
    public boolean reset = Boolean.getBoolean(System.getProperty("apdu4j.pcsc.reset", System.getenv().getOrDefault(CardBIBO.prop2env("apdu4j.pcsc.reset"), Boolean.TRUE.toString())));
    protected HashMap<Integer, CardChannel> channels = new HashMap();

    static String prop2env(String prop) {
        return prop.toUpperCase().replace('.', '_');
    }

    protected CardBIBO(Card card) {
        this.card = card;
        this.channels.put(0, card.getBasicChannel());
    }

    protected int getChannel(int cla) {
        if ((cla & 0x80) == 128) {
            return 0;
        }
        if ((cla & 0xE0) == 0) {
            return cla & 3;
        }
        if ((cla & 0x40) == 64) {
            return (cla & 0xF) + 4;
        }
        return 0;
    }

    public static CardBIBO wrap(Card card) {
        return new CardBIBO(card);
    }

    public byte[] transceive(byte[] bytes) throws BIBOException {
        if (this.closed) {
            throw new BIBOException("has been closed!");
        }
        try {
            int channel = this.getChannel(bytes[0] & 0xFF);
            if (bytes.length <= 5 && (bytes[0] & 0x80) == 0 && bytes[1] == 112 && bytes[2] == 0 && bytes[3] == 0) {
                CardChannel l = this.card.openLogicalChannel();
                this.channels.put(l.getChannelNumber(), l);
                return new byte[]{(byte)l.getChannelNumber(), -112, 0};
            }
            if (bytes.length == 4 && bytes[1] == 112 && bytes[2] == -128 && bytes[3] == 0) {
                CardChannel toClose = this.channels.remove(channel);
                if (toClose == null) {
                    throw new BIBOException("channel " + channel + " not open");
                }
                toClose.close();
                return new byte[]{-112, 0};
            }
            if (this.pseudo) {
                if (Arrays.equals(bytes, HexUtils.hex2bin((String)"FFCA100000"))) {
                    byte[] atr = this.card.getATR().getBytes();
                    atr = Arrays.copyOf(atr, atr.length + 2);
                    atr[atr.length - 2] = -112;
                    return atr;
                }
                if (Arrays.equals(bytes, HexUtils.hex2bin((String)"FFCA110000"))) {
                    switch (this.card.getProtocol().toUpperCase()) {
                        case "T=0": {
                            return HexUtils.hex2bin((String)"009000");
                        }
                        case "T=1": {
                            return HexUtils.hex2bin((String)"019000");
                        }
                        case "DIRECT": {
                            return HexUtils.hex2bin((String)"109000");
                        }
                    }
                    return HexUtils.hex2bin((String)"FF9000");
                }
                if (Arrays.equals(Arrays.copyOf(bytes, 5), HexUtils.hex2bin((String)"FFCA000000")) && this.card.getProtocol().equals("T=0")) {
                    return new byte[]{106, -127};
                }
            }
            if (!this.channels.containsKey(channel)) {
                throw new BIBOException("Channel not open: " + channel);
            }
            byte[] resp = this.channels.get(channel).transmit(new CommandAPDU(bytes)).getBytes();
            if (resp.length < 2) {
                throw new BIBOException("Broken incoming data: " + HexUtils.bin2hex((byte[])resp));
            }
            return resp;
        }
        catch (CardException e) {
            String r = SCard.getExceptionMessage(e);
            if (r.equals("SCARD_E_NOT_TRANSACTED") || r.equals("SCARD_E_NO_SMARTCARD")) {
                logger.debug("Assuming tag removed, because {}", (Object)r);
                throw new TagRemovedException(r, (Throwable)e);
            }
            throw new BIBOException(e.getMessage(), (Throwable)e);
        }
    }

    public void close() {
        this.closed = true;
        try {
            this.card.disconnect(this.reset);
        }
        catch (CardException e) {
            String err = SCard.getExceptionMessage(e);
            if (err.equals("SCARD_E_INVALID_HANDLE")) {
                logger.debug("Ignoring {} during disconnect, already closed before", (Object)err);
            }
            logger.warn("disconnect() failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public CompletableFuture<byte[]> transmit(byte[] command) {
        if (this.closed) {
            return CompletableFuture.failedFuture((Throwable)new BIBOException("closed"));
        }
        return CompletableFuture.supplyAsync(() -> this.transceive(command));
    }
}

