/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc;

import apdu4j.core.AsynchronousBIBO;
import apdu4j.core.SmartCardAppListener;
import apdu4j.pcsc.SCard;
import java.io.EOFException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardTerminalAppRunner
implements Runnable,
AsynchronousBIBO {
    private static final Logger logger = LoggerFactory.getLogger(CardTerminalAppRunner.class);
    private static final long IDLE_TIMEOUT_SECONDS = Long.parseLong(System.getenv().getOrDefault("APDU4J_IDLE_TIMEOUT", "60"));
    private final Executor executor;
    private final String[] argv;
    private final Supplier<CardTerminal> terminalProvider;
    private final SmartCardAppListener app;
    private AtomicReference<CompletableFuture<byte[]>> incoming = new AtomicReference();
    private AtomicReference<CompletableFuture<byte[]>> outgoing = new AtomicReference();
    String protocol = "*";
    volatile boolean multisession = false;
    volatile boolean needsTouch = false;
    volatile boolean spawnMonitor = true;
    Thread monitor;

    public CardTerminalAppRunner(Supplier<CardTerminal> terminalProvider, SmartCardAppListener app, Executor callbackExecutor, String[] argv) {
        this.terminalProvider = terminalProvider;
        this.app = app;
        this.argv = (String[])argv.clone();
        this.executor = callbackExecutor;
    }

    public static CardTerminalAppRunner once(Supplier<CardTerminal> terminalProvider, SmartCardAppListener app) {
        CardTerminalAppRunner r = new CardTerminalAppRunner(terminalProvider, app, ForkJoinPool.commonPool(), new String[0]);
        r.multisession = false;
        r.needsTouch = false;
        return r;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 31[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void waitForCard(CardTerminal t) throws CardException, InterruptedException {
        boolean result;
        logger.debug("Waiting for card...");
        do {
            result = t.waitForCardPresent(1000L);
            logger.debug("result: {}", (Object)result);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException("interrupted");
        } while (!result);
    }

    public static void waitForCardAbsent(CardTerminal t) throws CardException, InterruptedException {
        boolean result;
        logger.debug("Waiting for card absent...");
        do {
            result = t.waitForCardAbsent(1000L);
            logger.debug("result: {}", (Object)result);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException("interrupted");
        } while (!result);
    }

    public CompletableFuture<byte[]> transmit(byte[] command) {
        CompletableFuture<byte[]> og = this.outgoing.get();
        CompletableFuture<byte[]> ic = this.incoming.get();
        if (ic == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("We are not waiting for commands!"));
        }
        if (og != null && !og.isDone()) {
            return CompletableFuture.failedFuture(new IllegalStateException("Last command not yet completed!"));
        }
        CompletableFuture<byte[]> response = new CompletableFuture<byte[]>();
        CompletableFuture newIncoming = new CompletableFuture();
        if (this.outgoing.compareAndSet(og, response) && this.incoming.compareAndSet(ic, newIncoming)) {
            ic.complete(command);
            return response;
        }
        IllegalStateException ex = new IllegalStateException("incoming and outgoing mismatch!");
        og.completeExceptionally(ex);
        ic.completeExceptionally(ex);
        return CompletableFuture.failedFuture(ex);
    }

    public void close() {
        logger.debug("close()");
        CompletableFuture<byte[]> ic = this.incoming.get();
        if (ic != null) {
            ic.completeExceptionally(new EOFException("close"));
        }
    }

    private /* synthetic */ void lambda$run$0(SmartCardAppListener.CardData props) {
        this.app.onCardPresent((AsynchronousBIBO)this, props);
    }

    static class CardTerminalMonitorThread
    extends Thread {
        final CardTerminalAppRunner runner;
        final SmartCardAppListener app;

        CardTerminalMonitorThread(CardTerminalAppRunner t, SmartCardAppListener app) {
            this.runner = t;
            this.app = app;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            logger.info("Monitor thread starting");
            CardTerminal terminal = this.runner.terminalProvider.get();
            this.setName("monitor: " + terminal.getName());
            if (terminal == null) {
                logger.error("Did not get terminal!");
                return;
            }
            this.setName("monitor: " + terminal.getName());
            while (!this.isInterrupted()) {
                try {
                    CardTerminalAppRunner.waitForCardAbsent(terminal);
                    logger.info("Card removed!");
                    this.runner.close();
                    try {
                        this.app.onCardRemoved();
                    }
                    catch (Throwable e) {
                        logger.error("onCardRemoved() callback failed: " + e.getMessage(), e);
                    }
                    if (!this.runner.multisession) break;
                    CardTerminalAppRunner.waitForCard(terminal);
                }
                catch (CardException e) {
                    logger.warn("Failed to wait: {}", (Object)SCard.getExceptionMessage(e));
                    if (e.getCause() == null || !(e.getCause() instanceof InterruptedException)) continue;
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            logger.info("Monitor thread done");
        }
    }
}

