/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc;

import apdu4j.core.HexBytes;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public final class PCSCReader {
    String name;
    String aliasedName;
    byte[] atr;
    boolean present;
    boolean exclusive;
    boolean ignore;
    boolean preferred;
    String vmd;

    PCSCReader(String name, byte[] atr, boolean present, boolean exclusive, String vmd) {
        this.name = name;
        this.atr = atr;
        this.present = present;
        this.exclusive = exclusive;
        this.vmd = vmd;
    }

    public String getName() {
        return this.name;
    }

    public Optional<byte[]> getATR() {
        return Optional.ofNullable(this.atr);
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isPresent() {
        return this.present;
    }

    public Optional<String> getVMD() {
        return Optional.ofNullable(this.vmd);
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean v) {
        this.ignore = v;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean v) {
        this.preferred = v;
    }

    public String getAliasedName() {
        return this.aliasedName == null ? this.name : this.aliasedName;
    }

    public void setAliasedName(String v) {
        this.aliasedName = v;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PCSCReader that = (PCSCReader)o;
        return this.name.equals(that.name) && this.present == that.present && Arrays.equals(this.atr, that.atr);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.present, Arrays.hashCode(this.atr));
    }

    public String toString() {
        return "PCSCReader{" + this.name + "," + this.present + this.getATR().map(a -> "," + HexBytes.b((byte[])a).s()).orElse("") + "}";
    }

    public static char presenceMarker(PCSCReader r) {
        int presentMarker = r.present && r.ignore ? 73 : (r.present && r.preferred ? 80 : (r.present && r.exclusive ? 88 : (r.present ? 42 : (r.ignore ? 105 : (r.preferred ? 112 : 32)))));
        return (char)presentMarker;
    }
}

