/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc;

import apdu4j.core.HexUtils;
import apdu4j.pcsc.SCard;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PinPadTerminal {
    private static final Logger logger = LoggerFactory.getLogger(PinPadTerminal.class);
    private final Map<FEATURE, Integer> features;
    private boolean display = false;

    private static Map<FEATURE, Integer> tokenize(byte[] tlv) {
        HashMap<FEATURE, Integer> m = new HashMap<FEATURE, Integer>();
        if (tlv.length % 6 != 0) {
            throw new IllegalArgumentException("Bad response length: " + tlv.length);
        }
        for (int i = 0; i < tlv.length; i += 6) {
            int ft = tlv[i + 0] & 0xFF;
            FEATURE f = FEATURE.fromValue(ft);
            byte[] c = Arrays.copyOfRange(tlv, i + 2, i + 6);
            ByteBuffer buffer = ByteBuffer.wrap(c);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int ci = buffer.getInt();
            m.put(f, ci);
        }
        return m;
    }

    private static void parse_tlv_properties(byte[] tlv) {
        int i = 0;
        while (i + 2 < tlv.length) {
            int t = tlv[i + 0] & 0xFF;
            int l = tlv[i + 1] & 0xFF;
            byte[] v = Arrays.copyOfRange(tlv, i + 2, i + 2 + l);
            i += v.length + 2;
            logger.trace("{}={}", (Object)Integer.toHexString(t), (Object)HexUtils.bin2hex((byte[])v));
        }
    }

    private void parse_pin_properties(byte[] prop) {
        int timeout;
        int pin;
        int rows;
        int cols;
        if (prop.length == 4) {
            cols = prop[0] & 0xFF;
            rows = prop[1] & 0xFF;
            pin = prop[2] & 0xFF;
            timeout = prop[3] & 0xFF;
            if (rows > 0 && cols > 0) {
                this.display = true;
            }
        } else {
            throw new IllegalArgumentException("Bad PIN properties length: " + prop.length);
        }
        logger.debug("cols={} rows={} pin={} timeout={}", new Object[]{cols, rows, pin, timeout});
    }

    private PinPadTerminal(CardTerminal t, Card c, Map<FEATURE, Integer> features) throws CardException {
        byte[] resp;
        logger.debug("{} has: {}", (Object)t.getName(), (Object)features.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        this.features = new HashMap<FEATURE, Integer>(features);
        if (features.containsKey((Object)FEATURE.IFD_PIN_PROPERTIES)) {
            resp = c.transmitControlCommand(features.get((Object)FEATURE.IFD_PIN_PROPERTIES), new byte[0]);
            if (resp != null && resp.length > 0) {
                this.parse_pin_properties(resp);
            } else {
                logger.debug("No reply to IOCTL {}", (Object)FEATURE.IFD_PIN_PROPERTIES);
            }
        }
        if (features.containsKey((Object)FEATURE.GET_TLV_PROPERTIES)) {
            resp = c.transmitControlCommand(features.get((Object)FEATURE.GET_TLV_PROPERTIES), new byte[0]);
            if (resp != null && resp.length > 0) {
                PinPadTerminal.parse_tlv_properties(resp);
            } else {
                logger.debug("No reply to IOCTL {}", (Object)FEATURE.GET_TLV_PROPERTIES);
            }
        }
    }

    public static PinPadTerminal probe(CardTerminal t, Card c) throws CardException {
        Map<FEATURE, Integer> f;
        int CM_IOCTL_GET_FEATURE_REQUEST = SCard.CARD_CTL_CODE(3400);
        try {
            byte[] resp = c.transmitControlCommand(CM_IOCTL_GET_FEATURE_REQUEST, new byte[0]);
            f = PinPadTerminal.tokenize(resp);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Failed to parse features: {}", (Object)e.getMessage());
            throw new CardException("Failed to parse features", e);
        }
        return new PinPadTerminal(t, c, f);
    }

    public static String getVMD(CardTerminal t, Card c) {
        try {
            PinPadTerminal ppt = PinPadTerminal.probe(t, c);
            return (ppt.canVerify() ? "V" : " ") + (ppt.canModify() ? "M" : " ") + (ppt.hasDisplay() ? "D" : " ");
        }
        catch (CardException e) {
            String err = SCard.getExceptionMessage(e);
            if (err.equals("SCARD_E_SHARING_VIOLATION")) {
                return "???";
            }
            return "EEE";
        }
    }

    public boolean canVerify() {
        return this.features.containsKey((Object)FEATURE.VERIFY_PIN_DIRECT) || this.features.containsKey((Object)FEATURE.VERIFY_PIN_START) && this.features.containsKey((Object)FEATURE.VERIFY_PIN_FINISH);
    }

    public boolean canModify() {
        return this.features.containsKey((Object)FEATURE.MODIFY_PIN_DIRECT) || this.features.containsKey((Object)FEATURE.MODIFY_PIN_START) && this.features.containsKey((Object)FEATURE.MODIFY_PIN_FINISH);
    }

    public boolean hasDisplay() {
        return this.display;
    }

    public static enum FEATURE {
        VERIFY_PIN_START(1),
        VERIFY_PIN_FINISH(2),
        MODIFY_PIN_START(3),
        MODIFY_PIN_FINISH(4),
        GET_KEY_PRESSED(5),
        VERIFY_PIN_DIRECT(6),
        MODIFY_PIN_DIRECT(7),
        MCT_READERDIRECT(8),
        MCT_UNIVERSAL(9),
        IFD_PIN_PROPERTIES(10),
        ABORT(11),
        SET_SPE_MESSAGE(12),
        VERIFY_PIN_DIRECT_APP_ID(13),
        MODIFY_PIN_DIRECT_APP_ID(14),
        WRITE_DISPLAY(15),
        GET_KEY(16),
        IFD_DISPLAY_PROPERTIES(17),
        GET_TLV_PROPERTIES(18),
        CCID_ESC_COMMAND(19),
        EXECUTE_PACE(32);

        private final int value;

        private FEATURE(int value) {
            this.value = value;
        }

        public static FEATURE fromValue(int v) {
            for (FEATURE f : FEATURE.values()) {
                if (f.value != v) continue;
                return f;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }
}

