/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.pcsc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public final class ReaderAliases {
    private static final Logger logger = LoggerFactory.getLogger(ReaderAliases.class);
    public static final String ENV_APDU4J_ALIASES = "APDU4J_ALIASES";
    private static volatile ReaderAliases INSTANCE;
    private final transient HashMap<String, String> aliases;

    public String translate(String name) {
        return this.aliases.entrySet().stream().filter(e -> this.matches(name, (String)e.getKey())).findFirst().map(Map.Entry::getValue).orElse(name);
    }

    public Optional<String> alias(String name) {
        return this.aliases.entrySet().stream().filter(e -> this.matches(name, (String)e.getKey())).findFirst().map(Map.Entry::getValue);
    }

    public String extended(String name) {
        return this.alias(name).map(a -> String.format("%s (%s)", a, name)).orElse(name);
    }

    public String extended2(String name) {
        return this.alias(name).map(a -> String.format("%s (%s)", name, a)).orElse(name);
    }

    private boolean matches(String name, String match) {
        return name.toLowerCase().contains(match.toLowerCase());
    }

    static boolean verify(HashMap<String, String> aliases) {
        Set matches = aliases.keySet().stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (matches.size() != aliases.keySet().size()) {
            logger.error("Matches are not unique");
            return false;
        }
        Set all = aliases.values().stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (aliases.values().size() != all.size()) {
            logger.error("Aliases are not unique");
            return false;
        }
        return true;
    }

    private ReaderAliases(HashMap<String, String> aliases) {
        this.aliases = aliases;
    }

    public ReaderAliases apply(Collection<String> names) {
        HashMap<String, String> uniq = new HashMap<String, String>();
        for (Map.Entry<String, String> alias : this.aliases.entrySet()) {
            if (names.stream().filter(e -> this.matches((String)e, (String)alias.getKey())).count() > 1L) {
                logger.trace("{} matches more than one, disabling", (Object)alias.getKey());
                continue;
            }
            uniq.put(alias.getKey(), alias.getValue());
        }
        return new ReaderAliases(uniq);
    }

    public static ReaderAliases load(Path p) throws IOException {
        HashMap<String, String> loaded = new HashMap<String, String>();
        if (!Files.exists(p, new LinkOption[0])) {
            return new ReaderAliases(loaded);
        }
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            ArrayList content = (ArrayList)new Yaml().load(in);
            for (Map e : content) {
                loaded.put((String)e.get("match"), (String)e.get("alias"));
            }
        }
        catch (IOException e) {
            logger.error("Could not parse reader name aliases: " + e.getMessage(), (Throwable)e);
        }
        if (!ReaderAliases.verify(loaded)) {
            throw new IOException("Matches or aliases are not uniq!");
        }
        logger.info("Loaded aliases: {}", loaded);
        return new ReaderAliases(loaded);
    }

    public static ReaderAliases getDefault() {
        if (INSTANCE == null) {
            try {
                INSTANCE = System.getenv().containsKey(ENV_APDU4J_ALIASES) ? ReaderAliases.load(Paths.get(System.getenv(ENV_APDU4J_ALIASES), new String[0])) : ReaderAliases.load(Paths.get(System.getProperty("user.home"), ".apdu4j", "aliases.yaml"));
            }
            catch (IOException e) {
                logger.error("Could not load reader aliases: " + e.getMessage(), (Throwable)e);
                INSTANCE = new ReaderAliases(new HashMap<String, String>());
            }
        }
        return INSTANCE;
    }
}

