/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.tool;

import apdu4j.core.HexUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ATRList {
    private final Map<String, List<String>> map;
    private final String source;

    public static ATRList from(InputStream in, String path) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            HashMap<String, List<String>> entries = new HashMap<String, List<String>>();
            List allLines = reader.lines().collect(Collectors.toList());
            String atrmask = null;
            ArrayList<String> desc = new ArrayList<String>();
            for (String line : allLines) {
                if (line.length() == 0) {
                    if (atrmask != null && desc != null) {
                        entries.put(atrmask.replace(" ", ""), desc);
                    }
                    desc = new ArrayList();
                    continue;
                }
                if (line.charAt(0) == '\t') {
                    desc.add(line.trim());
                    continue;
                }
                if (line.charAt(0) == '#') continue;
                atrmask = line;
            }
            ATRList aTRList = new ATRList(entries, path);
            return aTRList;
        }
    }

    public static ATRList from(String path) throws IOException {
        InputStream in;
        if (path.startsWith("http")) {
            in = new URL(path).openStream();
        } else if (Files.isRegularFile(Paths.get(path, new String[0]), new LinkOption[0])) {
            in = new FileInputStream(path);
        } else {
            throw new IOException("Not a URL nor regular file: " + path);
        }
        return ATRList.from(in, path);
    }

    private ATRList(Map<String, List<String>> map, String source) {
        this.map = map;
        this.source = source;
    }

    public Optional<Map.Entry<String, List<String>>> match(byte[] atr) {
        String q = HexUtils.bin2hex((byte[])atr).toUpperCase();
        return this.map.entrySet().stream().filter(e -> q.matches((String)e.getKey())).findFirst();
    }

    public Optional<String> getSource() {
        return Optional.ofNullable(this.source);
    }

    public static Optional<String> locate() {
        String home = System.getProperty("user.home", "");
        Path[] paths = new Path[]{Paths.get(home, ".cache", ".smartcard_list.txt"), Paths.get(home, ".smartcard_list.txt"), Paths.get("/usr/local/pcsc/smartcard_list.txt", new String[0]), Paths.get("/usr/share/pcsc/smartcard_list.txt", new String[0]), Paths.get("/usr/local/share/pcsc/smartcard_list.txt", new String[0])};
        return Arrays.stream(paths).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(Path::toString);
    }
}

