/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.tool;

import apdu4j.pcsc.HandyTerminalsMonitor;
import apdu4j.pcsc.PCSCMonitor;
import apdu4j.pcsc.PCSCReader;
import apdu4j.pcsc.ReaderAliases;
import apdu4j.pcsc.TerminalManager;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowManager;
import com.googlecode.lanterna.gui2.dialogs.MessageDialog;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogBuilder;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.terminal.DefaultTerminalFactory;
import com.googlecode.lanterna.terminal.Terminal;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.smartcardio.CardTerminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FancyChooser
implements Callable<Optional<CardTerminal>>,
PCSCMonitor {
    private static final Logger logger = LoggerFactory.getLogger(FancyChooser.class);
    final Terminal terminal;
    final Screen screen;
    final MultiWindowTextGUI gui;
    final BasicWindow mainWindow;
    final Panel mainPanel;
    final ActionListBox mainActions;
    final Button quitButton;
    final TerminalManager manager;
    final Thread monitor;
    Map<String, PCSCReader> previousStates = new HashMap<String, PCSCReader>();
    volatile String nameOfChosenOne;
    final String preferred;
    final String ignored;
    final ReaderAliases aliases = ReaderAliases.getDefault();

    public synchronized void readerListChanged(List<PCSCReader> readers) {
        try {
            int selectedIndex = this.quitButton.isFocused() ? -2 : this.mainActions.getSelectedIndex();
            logger.info("CHANGE with selectedIndex={} and {} readers", (Object)selectedIndex, (Object)readers.size());
            this.mainActions.clearItems();
            Map<String, PCSCReader> statuses = readers.stream().collect(Collectors.toMap(PCSCReader::getName, e -> e));
            TerminalManager.dwimify(readers, (String)this.preferred, (String)this.ignored);
            List names = readers.stream().map(PCSCReader::getName).collect(Collectors.toList());
            ReaderAliases alias = this.aliases.apply(names);
            Optional pref = TerminalManager.hintMatchesExactlyOne((String)this.preferred, names.stream().map(arg_0 -> ((ReaderAliases)alias).extended(arg_0)).collect(Collectors.toList()));
            logger.info("Preferred reader by {} is {}: ", (Object)this.preferred, (Object)pref);
            int current = 0;
            for (PCSCReader r : readers) {
                Optional<String> thisOptional;
                int i = current++;
                String name = r.getName();
                r.setIgnore(r.isPresent() && r.isIgnore());
                this.mainActions.addItem(String.format("[%s] %s", Character.valueOf(PCSCReader.presenceMarker((PCSCReader)r)), alias.extended(name)), () -> {
                    if (r.isExclusive()) {
                        MessageDialog warn = new MessageDialogBuilder().setTitle(" Warning! ").setText("Reader is in exclusive use by some other application").addButton(MessageDialogButton.Cancel).addButton(MessageDialogButton.Continue).build();
                        warn.setCloseWindowWithEscape(true);
                        MessageDialogButton d = warn.showDialog((WindowBasedTextGUI)this.gui);
                        if (d == null || d == MessageDialogButton.Cancel) {
                            return;
                        }
                    }
                    this.nameOfChosenOne = r.getName();
                    this.mainWindow.close();
                });
                Optional<PCSCReader> prev = Optional.ofNullable(this.previousStates.get(name));
                if (i == selectedIndex && readers.size() > 1 && r.isExclusive() && !prev.map(PCSCReader::isExclusive).orElse(true).booleanValue()) {
                    logger.debug("rule 1");
                    selectedIndex = -1;
                }
                if (!r.isExclusive() && prev.map(PCSCReader::isExclusive).orElse(true).booleanValue() && readers.size() == 1) {
                    logger.debug("rule 2");
                    selectedIndex = i;
                }
                if (r.isPreferred() && selectedIndex < 0) {
                    logger.debug("rule pref");
                    selectedIndex = i;
                }
                if (prev.isEmpty() && this.previousStates.size() > 0) {
                    logger.debug("rule 3");
                    selectedIndex = i;
                }
                if (selectedIndex == -1 && !r.isExclusive() && pref.isEmpty() && !r.isIgnore()) {
                    logger.debug("rule 4");
                    selectedIndex = i;
                }
                if (pref.equals(thisOptional = Optional.of(alias.extended(name))) && selectedIndex < 0) {
                    logger.debug("rule 4.5");
                    selectedIndex = i;
                }
                if (!prev.map(PCSCReader::isPresent).orElse(false).booleanValue() && r.isPresent() && !r.isExclusive() && !r.isIgnore()) {
                    logger.debug("rule 5");
                    selectedIndex = i;
                }
                logger.info("{} Reader: {}, selectedIndex {}", new Object[]{i, r.getName(), selectedIndex});
                ++i;
            }
            if (readers.size() == 0) {
                this.mainWindow.setTitle(" Connect a reader ");
            } else {
                this.mainWindow.setTitle(" Choose a reader ");
            }
            if (selectedIndex >= 0) {
                this.mainActions.setSelectedIndex(selectedIndex);
                this.mainActions.takeFocus();
            } else if (selectedIndex == -2) {
                this.quitButton.takeFocus();
            }
            this.previousStates = statuses;
            this.mainActions.invalidate();
            this.mainPanel.invalidate();
            this.gui.updateScreen();
        }
        catch (Exception e2) {
            logger.error("Exception in readerListChanged: " + e2.getMessage(), (Throwable)e2);
            System.err.println(e2.getMessage());
            throw new RuntimeException(e2);
        }
    }

    public void readerListErrored(Throwable t) {
        System.err.println(t.getMessage());
    }

    private FancyChooser(Terminal terminal, Screen screen, TerminalManager manager, String preferred, String ignored) {
        this.preferred = preferred;
        this.ignored = ignored;
        this.manager = manager;
        this.monitor = new Thread((Runnable)new HandyTerminalsMonitor(manager, (PCSCMonitor)this));
        this.monitor.setName("FancyChooser monitor");
        this.monitor.setDaemon(true);
        this.terminal = terminal;
        this.screen = screen;
        this.gui = new MultiWindowTextGUI(screen, (WindowManager)new DefaultWindowManager(), (Component)new EmptySpace((TextColor)TextColor.ANSI.BLUE));
        this.mainWindow = new BasicWindow(" apdu4j ");
        this.mainWindow.setCloseWindowWithEscape(true);
        this.mainWindow.setHints(Arrays.asList(Window.Hint.FIT_TERMINAL_WINDOW, Window.Hint.CENTERED));
        this.mainPanel = new Panel();
        this.mainPanel.setLayoutManager((LayoutManager)new BorderLayout());
        this.mainPanel.setLayoutManager((LayoutManager)new LinearLayout(Direction.VERTICAL));
        this.mainActions = new ActionListBox();
        this.mainActions.setLayoutData((LayoutData)BorderLayout.Location.CENTER);
        this.mainActions.takeFocus();
        this.mainPanel.addComponent((Component)this.mainActions);
        this.mainPanel.addComponent((Component)new EmptySpace(new TerminalSize(0, 1)));
        this.quitButton = new Button("Cancel and quit", () -> this.mainWindow.close());
        this.quitButton.setLayoutData(LinearLayout.createLayoutData((LinearLayout.Alignment)LinearLayout.Alignment.End));
        this.mainPanel.addComponent((Component)this.quitButton);
        this.mainWindow.setComponent((Component)this.mainPanel);
    }

    public static Callable<Optional<CardTerminal>> forTerminals(TerminalManager manager, String preferred, String ignored) throws IOException {
        if (TerminalManager.isWindows()) {
            return () -> Optional.empty();
        }
        Terminal terminal = new DefaultTerminalFactory().createTerminal();
        TerminalScreen screen = new TerminalScreen(terminal);
        return new FancyChooser(terminal, (Screen)screen, manager, preferred, ignored);
    }

    @Override
    public Optional<CardTerminal> call() {
        try {
            if (this.monitor != null) {
                this.monitor.start();
            }
            this.screen.startScreen();
            this.gui.addWindow((Window)this.mainWindow);
            this.gui.waitForWindowToClose((Window)this.mainWindow);
            logger.info("waiting ended");
            this.terminal.clearScreen();
            this.screen.stopScreen();
            this.terminal.close();
            logger.info("cleared and stopped");
            System.out.println();
            logger.info("getting terminal");
            if (this.nameOfChosenOne == null) {
                Optional<CardTerminal> optional = Optional.empty();
                return optional;
            }
            CardTerminal t = this.manager.getTerminal(this.nameOfChosenOne);
            logger.info("terminal received");
            if (t == null) {
                logger.error("{} chosen but not available from CardTerminals?");
            }
            Optional<CardTerminal> optional = Optional.ofNullable(t);
            return optional;
        }
        catch (IOException e) {
            logger.error("Could not run: " + e.getMessage());
        }
        finally {
            if (this.monitor != null) {
                this.monitor.interrupt();
            }
        }
        return Optional.empty();
    }

    static {
        if (TerminalManager.isMacOS() && System.console() != null) {
            System.setProperty("java.awt.headless", "true");
        }
    }
}

