/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.tool;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Plug {
    private static final Logger logger = LoggerFactory.getLogger(Plug.class);
    static final ClassLoader pluginClassLoader;
    static final ClassLoader systemClassLoader;

    static List<Path> jars(Path folder) {
        List<Path> list;
        block9: {
            Stream<Path> entries = Files.list(folder);
            try {
                list = entries.filter(Files::isReadable).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".jar")).collect(Collectors.toList());
                if (entries == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (entries != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    logger.debug("No such directory: " + String.valueOf(folder));
                    return Collections.emptyList();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            entries.close();
        }
        return list;
    }

    static ClassLoader pluginFolderClassLoader(Path folder) {
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            logger.trace("Can't load plugins from " + String.valueOf(folder) + " defaulting to current classloader");
            return Thread.currentThread().getContextClassLoader();
        }
        List<URL> plugins = Plug.jars(folder).stream().map(p -> {
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
        logger.debug("Plugins from {}: {}", (Object)folder, plugins);
        return new URLClassLoader(plugins.toArray(new URL[plugins.size()]));
    }

    static <T> List<T> loadPlugins(Path p, Class<T> t) {
        try {
            return Plug.loadPlugins(p.toUri().toURL(), t);
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL from Path? ", (Throwable)e);
            return new ArrayList();
        }
    }

    static <T> List<T> loadPlugins(URL u, Class<T> t) {
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        URL[] plugin = new URL[]{u};
        URLClassLoader ucl = new URLClassLoader(plugin, parent);
        ServiceLoader<T> sl = ServiceLoader.load(t, ucl);
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> it = sl.iterator();
        while (it.hasNext()) {
            try {
                T i = it.next();
                if (i.getClass().getClassLoader() != ucl) {
                    logger.debug("Ignoring {} as not from classloader", (Object)i.getClass().getCanonicalName());
                    continue;
                }
                list.add(i);
            }
            catch (ServiceConfigurationError e) {
                if (e.getCause() != null) {
                    logger.warn("Plugin loading failure: " + e.getCause().getMessage());
                    continue;
                }
                logger.warn("Plugin loading failure: " + e.getMessage());
            }
        }
        return list;
    }

    static String pluginfile(Object c) {
        if (c.getClass().getClassLoader() == systemClassLoader) {
            return "builtin";
        }
        CodeSource src = c.getClass().getProtectionDomain().getCodeSource();
        if (src == null) {
            return "builtin";
        }
        URL l = src.getLocation();
        if (c.getClass().getClassLoader() == pluginClassLoader && l.getProtocol().equals("file")) {
            return "plugin " + l.getFile();
        }
        if (l.getProtocol().equals("file")) {
            return l.getFile();
        }
        return l.toExternalForm();
    }

    static ClassLoader getPluginsClassLoader(String env, Path p) throws IOException {
        if (System.getenv().containsKey(env)) {
            Path plugins = Paths.get(System.getenv(env), new String[0]);
            logger.debug("Using plugins from ${}: {}", (Object)env, (Object)plugins);
            return Plug.pluginFolderClassLoader(plugins);
        }
        logger.debug("Using plugins from {}", (Object)p);
        return Plug.pluginFolderClassLoader(p);
    }

    static <T> List<T> plugins(Class<T> t, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        ServiceLoader<T> sl = ServiceLoader.load(t, loader);
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> it = sl.iterator();
        while (it.hasNext()) {
            try {
                list.add(it.next());
            }
            catch (ServiceConfigurationError e) {
                if (e.getCause() != null) {
                    logger.warn("Plugin loading failure: " + e.getCause().getMessage());
                    continue;
                }
                logger.warn("Plugin loading failure: " + e.getMessage());
            }
        }
        return list;
    }

    static {
        try {
            pluginClassLoader = Plug.getPluginsClassLoader("APDU4J_PLUGINS", Paths.get(System.getProperty("user.home"), ".apdu4j", "plugins"));
            systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize plugins!");
        }
    }
}

