/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.tool;

import apdu4j.core.AsynchronousBIBO;
import apdu4j.core.BIBO;
import apdu4j.core.BIBOException;
import apdu4j.core.BlockingBIBO;
import apdu4j.core.GetResponseWrapper;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import apdu4j.core.SimpleSmartCardApp;
import apdu4j.core.SmartCardApp;
import apdu4j.core.SmartCardAppListener;
import apdu4j.pcsc.CardBIBO;
import apdu4j.pcsc.CardTerminalAppRunner;
import apdu4j.pcsc.PCSCReader;
import apdu4j.pcsc.ReaderAliases;
import apdu4j.pcsc.SCard;
import apdu4j.pcsc.TerminalManager;
import apdu4j.pcsc.terminals.LoggingCardTerminal;
import apdu4j.tool.ATRList;
import apdu4j.tool.FancyChooser;
import apdu4j.tool.Plug;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import jnasmartcardio.Smartcardio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="apdu4j", versionProvider=SCTool.class, mixinStandardHelpOptions=true, subcommands={CommandLine.HelpCommand.class})
public class SCTool
implements Callable<Integer>,
CommandLine.IVersionProvider {
    public static final String ENV_APDU4J_APPS = "APDU4J_APPS";
    public static final String ENV_APDU4J_READER = "APDU4J_READER";
    public static final String ENV_APDU4J_READER_IGNORE = "APDU4J_READER_IGNORE";
    public static final String ENV_APDU4J_DEBUG = "APDU4J_DEBUG";
    public static final String ENV_APDU4J_DEBUG_FILE = "APDU4J_DEBUG_FILE";
    public static final String ENV_SMARTCARD_LIST = "SMARTCARD_LIST";
    final Logger logger = LoggerFactory.getLogger(SCTool.class);
    private TerminalFactory tf = null;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Be verbose"})
    boolean verbose;
    @CommandLine.Option(names={"-d", "--debug"}, description={"Trace APDU-s"})
    boolean debug;
    @CommandLine.Option(names={"-f", "--force"}, description={"Force, don't stop on errors"})
    boolean force;
    @CommandLine.Option(names={"-l", "--list"}, description={"List readers"})
    boolean list;
    @CommandLine.Option(names={"-W", "--no-wait"}, description={"Don't wait for card before running app"})
    boolean noWait;
    @CommandLine.Option(names={"-B", "--bare-bibo"}, description={"Don't handle 61XX/6CXX"})
    boolean bareBibo;
    @CommandLine.Option(names={"-r", "--reader"}, description={"Use reader"}, paramLabel="<reader>")
    String reader;
    @CommandLine.Option(names={"-R"}, description={"Force reader selector"})
    boolean forceReaderSelection;
    @CommandLine.Option(names={"-a", "--apdu"}, description={"Send APDU-s"}, paramLabel="<HEX>")
    byte[][] apdus = new byte[0][];
    @CommandLine.Parameters
    String[] params = new String[0];
    @CommandLine.ArgGroup(heading="Protocol selection (default is T=*)%n")
    T0T1 proto = new T0T1();
    @CommandLine.ArgGroup(heading="Low level options%n", validate=false)
    LowLevel lowlevel = new LowLevel();
    private Map<String, SmartCardApp> apps;
    private TerminalManager manager;
    static Path appsFolder = Paths.get(System.getenv().getOrDefault("APDU4J_APPS", Paths.get(System.getProperty("user.home", ""), ".apdu4j", "apps").toString()), new String[0]);

    private void verbose(String s) {
        if (this.verbose) {
            System.out.println("# " + s);
        }
    }

    void printReaderList(List<PCSCReader> readers, PrintStream to, boolean verbose) {
        String filler;
        boolean hasSomeATR;
        if (readers.size() == 0) {
            to.println("No readers found");
            return;
        }
        ReaderAliases aliases = ReaderAliases.getDefault().apply((Collection)readers.stream().map(PCSCReader::getName).collect(Collectors.toList()));
        ATRList atrList = null;
        Optional<String> atrListPath = Optional.ofNullable(System.getenv(ENV_SMARTCARD_LIST)).or(ATRList::locate);
        boolean bl = hasSomeATR = readers.stream().filter(PCSCReader::isPresent).count() > 0L;
        if (atrListPath.isPresent() && hasSomeATR) {
            try {
                atrList = ATRList.from(atrListPath.get());
            }
            catch (IOException e2) {
                this.logger.warn("Could not load ATR list: {}", (Object)e2.getMessage(), (Object)e2);
            }
        }
        int i = 0;
        String string = filler = readers.size() > 10 ? "              " : "             ";
        if (atrList != null && verbose) {
            this.verbose("ATR info from " + atrList.getSource().orElse("unknown source"));
        }
        for (PCSCReader r : readers) {
            String vmdString = r.getVMD().map(e -> String.format("[%s] ", e)).orElse("");
            char c = verbose ? PCSCReader.presenceMarker((PCSCReader)r) : (r.isPresent() ? 42 : 32);
            to.println(String.format("%d: [%c] %s%s", ++i, Character.valueOf(c), vmdString, aliases.extended(r.getName())));
            if (!verbose || !r.getATR().isPresent()) continue;
            byte[] atr = (byte[])r.getATR().get();
            to.println(String.format("%s%s", filler, HexUtils.bin2hex((byte[])atr)));
            if (atrList != null) {
                Optional<Map.Entry<String, List<String>>> desc = atrList.match(atr);
                if (!desc.isPresent()) continue;
                desc.get().getValue().stream().forEachOrdered(l -> to.printf("%s- %s%n", filler, l));
                continue;
            }
            to.printf("%shttps://smartcard-atr.apdu.fr/parse?ATR=%s%n", filler, HexUtils.bin2hex((byte[])atr));
        }
    }

    @CommandLine.Command(name="list", description={"List available smart card readers."}, aliases={"ls"})
    public int listReaders(@CommandLine.Option(names={"-v", "--verbose"}) boolean verbose) {
        List env;
        boolean beVerbose;
        boolean bl = beVerbose = this.verbose || verbose;
        if (beVerbose && (env = System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("APDU4J_")).map(e -> String.format("%s=\"%s\"", e.getKey(), e.getValue())).collect(Collectors.toList())).size() > 0) {
            this.verbose(String.join((CharSequence)" ", env));
        }
        try {
            List result = TerminalManager.listPCSC(this.getTerminalManager().terminals().list(), (OutputStream)(this.debug ? System.out : null), (boolean)beVerbose);
            TerminalManager.dwimify((List)result, (String)System.getenv(ENV_APDU4J_READER), (String)System.getenv(ENV_APDU4J_READER_IGNORE));
            this.printReaderList(result, System.out, beVerbose);
        }
        catch (CardException | Smartcardio.EstablishContextException e2) {
            String em = SCard.getExceptionMessage((Throwable)e2);
            if (em.equals("SCARD_E_NO_SERVICE")) {
                return SCTool.fail("PC/SC service is not running: " + em);
            }
            if (em.equals("SCARD_E_NO_READERS_AVAILABLE")) {
                return SCTool.fail("No readers found: " + em);
            }
            return SCTool.fail("Could not list readers: " + em);
        }
        return 0;
    }

    @CommandLine.Command(name="apps", description={"List available apps."})
    public int listApps() {
        List<Path> jarApps;
        if (this.apps == null) {
            this.apps = this.resolveApps();
        }
        if (!Files.isDirectory(appsFolder, new LinkOption[0])) {
            SCTool.fail("# Tip: create " + String.valueOf(appsFolder) + " and place there all your app jar-s");
        }
        if ((jarApps = Plug.jars(appsFolder)).size() == 0) {
            SCTool.fail("Tip: put all your apdu4j JAR apps into " + String.valueOf(appsFolder));
        }
        jarApps.forEach(p -> {
            if (Plug.loadPlugins(p, SmartCardApp.class).size() == 0) {
                this.verbose(String.format("%s does not contain a SmartCardApp, %n\tplease upgrade or remove the app file.%n", p));
            }
        });
        int maxNameLen = this.apps.keySet().stream().mapToInt(String::length).max().getAsInt();
        int maxClassLen = this.apps.values().stream().mapToInt(e -> e.getClass().getCanonicalName().length()).max().getAsInt();
        String format = String.format("%%-%ds   %%-%ds   (%%s)%%n", maxNameLen, maxClassLen);
        String headerFormat = String.format("%%-%ds   %%-%ds   %%s%%n", maxNameLen, maxClassLen);
        if (this.verbose) {
            System.out.printf(headerFormat, "# Name", "Class", "From");
        }
        for (Map.Entry<String, SmartCardApp> e2 : this.apps.entrySet()) {
            System.out.printf(format, e2.getKey(), e2.getValue().getClass().getCanonicalName(), Plug.pluginfile(e2.getValue()));
        }
        return 0;
    }

    Optional<String> cmdname(Path p) {
        String extension;
        Path fileName = p.getFileName();
        if (fileName == null) {
            return Optional.empty();
        }
        String fname = fileName.toString().toLowerCase();
        if (fname.endsWith(extension = ".jar")) {
            return Optional.of(fname.substring(0, fname.length() - extension.length()));
        }
        return Optional.empty();
    }

    Map<String, SmartCardApp> resolveApps() {
        TreeMap<String, SmartCardApp> allApps = new TreeMap<String, SmartCardApp>();
        List<Path> jars = Plug.jars(appsFolder);
        for (Path p : jars) {
            Optional<String> jarcmd = this.cmdname(p);
            List<SmartCardApp> apps = Plug.loadPlugins(p, SmartCardApp.class);
            apps.forEach(a -> {
                if (allApps.containsKey(a.getName())) {
                    this.logger.info("{} already present via  {}", (Object)a.getName(), allApps.get(a.getName()));
                }
                allApps.putIfAbsent(a.getName(), (SmartCardApp)a);
            });
            if (apps.size() == 1 && jarcmd.isPresent()) {
                allApps.put(jarcmd.get(), apps.get(0));
            }
            if (apps.size() != 0) continue;
            this.logger.info("{} is not SmartCardApp", (Object)p);
        }
        ServiceLoader<SmartCardApp> sl1 = ServiceLoader.load(SmartCardApp.class);
        sl1.stream().forEach(a -> {
            if (allApps.containsKey(((SmartCardApp)a.get()).getName())) {
                this.logger.info("{} overrides builtin {}", (Object)((SmartCardApp)allApps.get(((SmartCardApp)a.get()).getName())).getClass().getCanonicalName(), (Object)((SmartCardApp)a.get()).getName());
            }
            allApps.putIfAbsent(((SmartCardApp)a.get()).getName(), (SmartCardApp)a.get());
        });
        return allApps;
    }

    @CommandLine.Command(name="run", description={"Run specified smart card application"})
    public int runApp(@CommandLine.Parameters(paramLabel="<app>", index="0") String app, @CommandLine.Parameters(index="1..*") String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        if (this.apps == null) {
            this.apps = this.resolveApps();
        }
        try {
            Optional<CardTerminal> rdr = this.getTheTerminal();
            rdr.ifPresent(t -> this.verbose("Using " + t.getName()));
            if (rdr.isEmpty()) {
                return SCTool.fail("Specify valid reader to use with -r");
            }
            List<Map.Entry> matches = this.apps.entrySet().stream().filter(e -> ((String)e.getKey()).equals(app)).collect(Collectors.toList());
            if (matches.size() == 0) {
                matches = this.apps.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(app)).collect(Collectors.toList());
            }
            if (matches.size() == 0) {
                SCTool.fail("App not found: " + app);
                return 66;
            }
            if (matches.size() > 1) {
                matches.forEach(e -> System.err.println("   - " + (String)e.getKey()));
                return SCTool.fail("Multiple choices for " + app);
            }
            SmartCardApp sca = (SmartCardApp)((Map.Entry)matches.get(0)).getValue();
            this.verbose(String.format("Running %s (%s) from %s", sca.getName(), sca.getClass().getCanonicalName(), Plug.pluginfile(sca)));
            if (sca instanceof SimpleSmartCardApp) {
                CardTerminal reader = rdr.get();
                if (!reader.isCardPresent() && !this.noWait) {
                    System.out.println("# Waiting for card in " + reader.getName());
                    CardTerminalAppRunner.waitForCard((CardTerminal)reader);
                }
                BlockingBIBO b = new BlockingBIBO((AsynchronousBIBO)CardBIBO.wrap((Card)reader.connect(this.getProtocol())));
                if (this.apdus != null) {
                    for (byte[] s : this.apdus) {
                        ResponseAPDU r = new ResponseAPDU(b.transceive(s));
                        if (r.getSW() == 36864 || this.force) continue;
                        return SCTool.fail("Card returned " + String.format("%04X", r.getSW()) + ", exiting!");
                    }
                }
                Optional<Thread> exiter = this.exiter();
                int ret = ((SimpleSmartCardApp)sca).run((BIBO)b, args);
                exiter.map(t -> Runtime.getRuntime().removeShutdownHook((Thread)t));
                b.close();
                return ret;
            }
            if (sca instanceof SmartCardAppListener) {
                Optional<Thread> exiter = this.exiter();
                ErrorReportingSmartCardAppProxy proxy = new ErrorReportingSmartCardAppProxy((SmartCardAppListener)sca);
                Thread appThread = new Thread((Runnable)new CardTerminalAppRunner(this.getTheTerminal()::get, (SmartCardAppListener)proxy, (Executor)ForkJoinPool.commonPool(), args));
                appThread.start();
                appThread.join();
                exiter.map(t -> Runtime.getRuntime().removeShutdownHook((Thread)t));
                if (proxy.didError()) {
                    this.verbose("Failed");
                    return 1;
                }
                this.verbose("Success");
                return 0;
            }
            return SCTool.fail("Don't know how to handle apps of type " + String.valueOf(Arrays.asList(sca.getClass().getInterfaces())));
        }
        catch (InterruptedException | CardException | Smartcardio.EstablishContextException e2) {
            System.err.println("Failed: " + SCard.getExceptionMessage((Throwable)e2));
        }
        catch (RuntimeException e3) {
            System.err.println("App failed: " + e3.getMessage());
        }
        return 66;
    }

    Optional<Thread> exiter() {
        if (this.verbose) {
            Thread t = new Thread(() -> System.out.printf("%n%nYou were using apdu4j. Cool!%n", new Object[0]));
            Runtime.getRuntime().addShutdownHook(t);
            return Optional.of(t);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CommandLine.Command(name="apdu", description={"Send raw APDU-s (Bytes Out)"})
    public int sendAPDU(@CommandLine.Parameters(paramLabel="<hex>", arity="1..*") List<byte[]> apdus) {
        ArrayList toCard = new ArrayList(Arrays.asList(this.apdus));
        toCard.addAll(apdus);
        try (BIBO b = this.getBIBO(this.getTheTerminal());){
            byte[] s;
            ResponseAPDU r;
            Iterator iterator = toCard.iterator();
            do {
                if (!iterator.hasNext()) return 0;
            } while ((r = new ResponseAPDU(b.transceive(s = (byte[])iterator.next()))).getSW() == 36864 || this.force);
            int n = SCTool.fail("Card returned " + String.format("%04X", r.getSW()) + ", exiting!");
            return n;
        }
        catch (CardException e) {
            return SCTool.fail("Could not connect: " + e.getMessage());
        }
        catch (BIBOException e) {
            return SCTool.fail("Failed: " + e.getMessage());
        }
    }

    @CommandLine.Command(name="plugins", description={"List available plugins."})
    public int listPlugins() {
        Provider[] providers = Security.getProviders("TerminalFactory.PC/SC");
        System.out.println("Existing TerminalFactory providers:");
        if (providers != null) {
            for (Provider p : providers) {
                System.out.printf("%s v%s (%s) from %s%n", p.getName(), p.getVersionStr(), p.getInfo(), Plug.pluginfile(p));
            }
        }
        return 0;
    }

    static void configureLogging() {
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "true");
        System.setProperty("org.slf4j.simpleLogger.showShortLogName", "true");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showDateTime", "true");
        System.setProperty("org.slf4j.simpleLogger.dateTimeFormat", "HH:mm:ss:SSS");
        if (System.getenv(ENV_APDU4J_DEBUG) != null) {
            System.setProperty("org.slf4j.simpleLogger.logFile", System.getenv().getOrDefault(ENV_APDU4J_DEBUG_FILE, "apdu4j.log"));
        }
        System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", System.getenv().getOrDefault(ENV_APDU4J_DEBUG, "warn"));
    }

    public static void main(String[] args) {
        try {
            SCTool.configureLogging();
            SCTool tool = new SCTool();
            CommandLine cli = new CommandLine((Object)tool);
            cli.setUnmatchedOptionsArePositionalParams(true);
            cli.setStopAtPositional(true);
            cli.registerConverter(byte[].class, HexUtils::stringToBin);
            try {
                cli.parseArgs(args);
            }
            catch (CommandLine.ParameterException ex) {
                System.err.println(ex.getMessage());
                ex.getCommandLine().usage(System.err);
                System.exit(1);
            }
            cli.execute(args);
        }
        catch (RuntimeException e) {
            System.exit(SCTool.fail("Error: " + e.getMessage()));
        }
    }

    @Override
    public Integer call() {
        if (this.list) {
            return this.listReaders(this.verbose);
        }
        if (this.apdus.length > 0) {
            return this.sendAPDU(Collections.emptyList());
        }
        if (this.params.length > 0) {
            if (this.params[0].startsWith("-")) {
                System.err.println("Invalid parameters: " + String.join((CharSequence)" ", this.params));
                return 1;
            }
            if (this.apps == null) {
                this.apps = this.resolveApps();
            }
            if (this.apps.containsKey(this.params[0])) {
                return this.runApp(this.params[0], Arrays.copyOfRange(this.params, 1, this.params.length));
            }
            System.err.println("Unknown app: " + this.params[0]);
            return 66;
        }
        System.out.println("Nothing to do!");
        return 0;
    }

    Optional<String> forceLibraryPath() {
        if (this.lowlevel.useSUN != null && !this.lowlevel.useSUN.isBlank()) {
            return Optional.of(this.lowlevel.useSUN.trim());
        }
        return Optional.empty();
    }

    TerminalManager getTerminalManager() {
        if (this.manager != null) {
            return this.manager;
        }
        try {
            TerminalFactory tf;
            if (this.lowlevel.useSUN != null) {
                if (TerminalManager.isEnabled((String)"apdu4j.fixpath", (boolean)true)) {
                    TerminalManager.fixPlatformPaths();
                }
                this.forceLibraryPath().ifPresent(e -> System.setProperty("sun.security.smartcardio.library", e));
                if (this.verbose && System.getProperty("sun.security.smartcardio.library") != null) {
                    System.out.println("# sun.security.smartcardio.library=" + System.getProperty("sun.security.smartcardio.library"));
                }
                tf = TerminalFactory.getDefault();
            } else {
                tf = TerminalManager.getTerminalFactory();
            }
            if (this.verbose) {
                System.out.println("# Using " + String.valueOf(tf.getProvider()));
            }
            this.manager = new TerminalManager(tf);
            return this.manager;
        }
        catch (Smartcardio.EstablishContextException e2) {
            String msg = SCard.getExceptionMessage((Throwable)e2);
            SCTool.fail("No readers: " + msg);
            return null;
        }
    }

    private String getProtocol() {
        Object protocol = this.proto.t0 ? "T=0" : (this.proto.t1 ? "T=1" : "*");
        if (this.lowlevel.useSUN == null && (System.getProperty("os.name").toLowerCase().contains("windows") || this.lowlevel.exclusive)) {
            protocol = "EXCLUSIVE;" + (String)protocol;
        }
        return protocol;
    }

    private BIBO getBIBO(Optional<CardTerminal> rdr) throws CardException {
        if (rdr.isEmpty()) {
            SCTool.exit("Specify valid reader to use with -r");
        } else {
            this.logger.info("Using " + String.valueOf(rdr.get()));
        }
        CardTerminal reader = rdr.get();
        if (!this.noWait && !reader.isCardPresent()) {
            this.verbose("Waiting for card ...");
            try {
                CardTerminalAppRunner.waitForCard((CardTerminal)reader);
            }
            catch (InterruptedException e) {
                this.verbose("Interrupted!");
            }
        }
        Card c = reader.connect(this.getProtocol());
        Object bibo = this.bareBibo ? CardBIBO.wrap((Card)c) : GetResponseWrapper.wrap((AsynchronousBIBO)CardBIBO.wrap((Card)c));
        return new BlockingBIBO((AsynchronousBIBO)bibo);
    }

    private Optional<CardTerminal> getTheTerminal() {
        String spec;
        String string = spec = this.reader == null ? System.getenv(ENV_APDU4J_READER) : this.reader;
        if (this.bareBibo) {
            System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
            System.setProperty("sun.security.smartcardio.t1GetResponse", "false");
            System.setProperty("jnasmartcardio.transparent", "true");
        }
        try {
            Optional<CardTerminal> result;
            this.getTerminalManager();
            if (this.forceReaderSelection) {
                result = FancyChooser.forTerminals(this.manager, System.getenv(ENV_APDU4J_READER), System.getenv(ENV_APDU4J_READER_IGNORE)).call();
            } else {
                CardTerminals terminals = this.manager.terminals();
                List readers = TerminalManager.listPCSC(terminals.list(), null, (boolean)false);
                TerminalManager.dwimify((List)readers, (String)spec, (String)System.getenv(ENV_APDU4J_READER_IGNORE));
                if (spec != null) {
                    Optional preferred = TerminalManager.toSingleton((Collection)readers, e -> e.isPreferred());
                    if (preferred.isPresent()) {
                        result = Optional.ofNullable(terminals.getTerminal(((PCSCReader)preferred.get()).getName()));
                    } else {
                        System.err.println("-r/$APDU4J_READER was not found: " + spec);
                        result = Optional.empty();
                    }
                } else {
                    result = TerminalManager.getLucky((List)readers, (CardTerminals)terminals);
                }
                if (result.isEmpty() && spec == null) {
                    result = FancyChooser.forTerminals(this.manager, null, System.getenv(ENV_APDU4J_READER_IGNORE)).call();
                }
            }
            return result.map(t -> this.debug ? LoggingCardTerminal.getInstance((CardTerminal)t) : t);
        }
        catch (Exception e2) {
            System.out.println("Failed : " + e2.getMessage());
            return Optional.empty();
        }
    }

    public String[] getVersion() {
        String secondLine = String.format("# Running on %s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")) + String.format(", Java %s by %s", System.getProperty("java.version"), System.getProperty("java.vendor"));
        ArrayList<Object> v = new ArrayList<Object>();
        v.add(TerminalManager.getVersion());
        v.add(secondLine);
        List env = System.getenv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("APDU4J_")).map(e -> String.format("%s=\"%s\"", e.getKey(), e.getValue())).collect(Collectors.toList());
        if (env.size() > 0) {
            v.add("# " + String.join((CharSequence)" ", env));
        }
        return v.toArray(new String[0]);
    }

    private static int fail(String message) {
        System.err.println(message);
        return 1;
    }

    private static void exit(String message) {
        System.exit(SCTool.fail(message));
    }

    static class T0T1 {
        @CommandLine.Option(names={"--t0"}, description={"Use T=0"})
        boolean t0;
        @CommandLine.Option(names={"--t1"}, description={"Use T=1"})
        boolean t1;

        T0T1() {
        }
    }

    static class LowLevel {
        @CommandLine.Option(names={"-X", "--exclusive"}, description={"Use EXCLUSIVE mode (JNA only)"})
        boolean exclusive;
        @CommandLine.Option(names={"-S", "--sun"}, description={"Use SunPCSC instead of JNA"}, arity="0..1", paramLabel="<lib>", fallbackValue="")
        String useSUN;

        LowLevel() {
        }
    }

    static class ErrorReportingSmartCardAppProxy
    implements SmartCardAppListener {
        final SmartCardAppListener proxied;
        private volatile Throwable errored;

        ErrorReportingSmartCardAppProxy(SmartCardAppListener app) {
            this.proxied = app;
        }

        public String getName() {
            return this.proxied.getName();
        }

        public Optional<String> getDescription() {
            return this.proxied.getDescription();
        }

        public CompletableFuture<SmartCardAppListener.AppParameters> onStart(String[] argv) {
            return this.proxied.onStart(argv);
        }

        public void onCardPresent(AsynchronousBIBO transport, SmartCardAppListener.CardData properties) {
            this.proxied.onCardPresent(transport, properties);
        }

        public void onCardRemoved() {
            this.proxied.onCardRemoved();
        }

        public void onError(Throwable e) {
            this.errored = e;
            this.proxied.onError(e);
        }

        public boolean didError() {
            return this.errored != null;
        }
    }
}

