/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.tool.apps;

import apdu4j.core.AsynchronousBIBO;
import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import apdu4j.core.SmartCardApp;
import apdu4j.core.SmartCardAppFutures;
import apdu4j.core.SmartCardAppListener;
import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SmartCardApp.class})
public class UIDs
extends SmartCardAppFutures {
    private static final Logger logger = LoggerFactory.getLogger(UIDs.class);

    public CompletableFuture<SmartCardAppListener.AppParameters> onStart(String[] argv) {
        System.out.println("Starting app, params: " + Arrays.toString(argv));
        SmartCardAppListener.AppParameters params = new SmartCardAppListener.AppParameters();
        params.put((Object)"touch_required", (Object)Boolean.TRUE.toString());
        params.put((Object)"multisession", (Object)Boolean.TRUE.toString());
        System.out.println("Present cards to reader to print their UID-s");
        return CompletableFuture.completedFuture(params);
    }

    public void onCardPresent(AsynchronousBIBO transport, SmartCardAppListener.CardData props) {
        System.out.println("Card presented: " + String.valueOf(props));
        CommandAPDU cmd = new CommandAPDU("FFCA000000");
        transport.transmit(cmd.getBytes()).thenAccept(response -> {
            ResponseAPDU resp = new ResponseAPDU(response);
            if (resp.getSW() == 36864) {
                System.out.printf("UID: %s%n", HexUtils.bin2hex((byte[])resp.getData()));
            } else {
                System.err.printf("UID not supported by reader? SW=%04Xd", resp.getSW());
            }
            transport.close();
        });
    }

    public void onError(Throwable e) {
        logger.error("We had error: {}", (Object)e.getMessage(), (Object)e);
        System.out.println("Error occured");
        e.printStackTrace();
    }

    public void onCardRemoved() {
        logger.info("Card was removed");
        System.out.println("Card removed");
    }
}

