/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp.emv;

import apdu4j.core.HexUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DGI {
    private final byte[] tag;
    private final byte[] value;
    private final Type type;
    private static final Pattern LINE_PATTERN = Pattern.compile("^DGI([0-9a-fA-F]{4})=([0-9a-fA-F]*)$");

    public DGI(byte[] tag, byte[] value, Type type) {
        this.tag = Arrays.copyOf(tag, tag.length);
        this.value = Arrays.copyOf(value, value.length);
        this.type = type;
    }

    public byte[] tag() {
        return Arrays.copyOf(this.tag, this.tag.length);
    }

    public byte[] value() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public Type type() {
        return this.type;
    }

    public static byte[] length(int len) {
        if (len <= 254) {
            return new byte[]{(byte)len};
        }
        return new byte[]{-1, (byte)(len >> 8), (byte)len};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DGI dgi = (DGI)o;
        return Arrays.equals(this.tag, dgi.tag) && Arrays.equals(this.value, dgi.value) && this.type == dgi.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.tag), Arrays.hashCode(this.value), this.type});
    }

    public String toString() {
        return "(" + this.type.name() + ") DGI " + HexUtils.bin2hex((byte[])this.tag) + "=" + HexUtils.bin2hex((byte[])this.value);
    }

    public static List<DGI> parse(Path filePath, Function<byte[], Type> typeOracle) throws IOException {
        ArrayList<DGI> entries = new ArrayList<DGI>();
        List<String> lines = Files.readAllLines(filePath);
        for (String line : lines) {
            String s = line.trim();
            if (s.startsWith("//") || s.startsWith("#")) continue;
            Matcher matcher = LINE_PATTERN.matcher(s);
            if (!matcher.matches()) {
                throw new IOException("Invalid DGI file line: " + line);
            }
            byte[] tag = HexUtils.hex2bin((String)matcher.group(1));
            byte[] value = HexUtils.hex2bin((String)matcher.group(2));
            Type type = typeOracle.apply(tag);
            entries.add(new DGI(tag, value, type));
        }
        return entries;
    }

    public static enum Type {
        PLAINTEXT,
        PADDING,
        NOPADDING;

    }
}

