/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.HexUtils;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPUtils;

public final class GPKeyInfo {
    private static final Logger logger = LoggerFactory.getLogger(GPKeyInfo.class);
    private GPKey type;
    private List<GPKeyInfoElement> elements;
    private int version = 0;
    private int id = -1;
    private int length = -1;
    private int access = -1;
    private int usage = -1;
    public static final Map<Integer, String> keyVersionPurposes;

    public GPKeyInfo(int version, int id, int length, GPKey type) {
        this.version = version;
        this.id = id;
        this.length = length;
        this.type = type;
    }

    public GPKeyInfo(int version, int id, List<GPKeyInfoElement> elements, int access, int usage) {
        this.version = version;
        this.id = id;
        List valid = elements.stream().filter(GPKeyInfoElement::isValid).collect(Collectors.toList());
        if (elements.size() != valid.size()) {
            HashSet<GPKeyInfoElement> unknown = new HashSet<GPKeyInfoElement>(elements);
            unknown.removeAll(valid);
            logger.warn("Unknown elements ignored: " + String.valueOf(unknown));
        }
        if (valid.size() == 0) {
            throw new IllegalArgumentException("No key elements!");
        }
        if (valid.size() == 1) {
            this.length = elements.get((int)0).keyLength;
            this.type = elements.get((int)0).key;
        } else {
            Optional<GPKeyInfoElement> rsa = valid.stream().filter(e -> e.key == GPKey.RSA_PUB_N).findFirst();
            Optional<GPKeyInfoElement> ecc = valid.stream().filter(e -> e.key == GPKey.EC_PRIV || e.key == GPKey.EC_PUB).findFirst();
            if (rsa.isPresent()) {
                this.length = rsa.get().keyLength;
                this.type = GPKey.RSA_PUB_N;
            } else if (ecc.isPresent()) {
                this.length = ecc.get().keyLength;
                GPKey.get(ecc.get().key.getType()).ifPresent(gpKey -> {
                    this.type = gpKey;
                });
            } else {
                logger.error("Multiple unsupported elements in key info:  {} ", elements);
                throw new GPDataException("Multiple unsupported elements in key info template");
            }
        }
        this.elements = new ArrayList<GPKeyInfoElement>(elements);
        this.access = access;
        this.usage = usage;
    }

    public static List<GPKeyInfo> parseTemplate(byte[] data) throws GPException {
        ArrayList<GPKeyInfo> r = new ArrayList<GPKeyInfo>();
        if (data == null || data.length == 0) {
            logger.warn("Template is null or zero length");
            return r;
        }
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(data);
        GPUtils.trace_tlv(data, logger);
        BerTlv keys = tlvs.find(new BerTag(224));
        if (keys != null && keys.isConstructed()) {
            for (BerTlv key : keys.findAll(new BerTag(192))) {
                byte[] tmpl = key.getBytesValue();
                if (tmpl.length == 0) {
                    logger.info("Key template has zero length (empty). Skipping.");
                    continue;
                }
                if (tmpl.length < 4) {
                    throw new GPDataException("Key info template shorter than 4 bytes", tmpl);
                }
                int offset = 0;
                int id = tmpl[offset++] & 0xFF;
                int version = tmpl[offset++] & 0xFF;
                boolean extended = tmpl[offset] == -1;
                ArrayList<GPKeyInfoElement> elements = new ArrayList<GPKeyInfoElement>();
                while (offset + (extended ? 4 : 0) < tmpl.length) {
                    GPKeyInfoElement element = extended ? GPKeyInfoElement.fromExtendedBytes(tmpl, offset) : new GPKeyInfoElement(tmpl, offset);
                    elements.add(element);
                    logger.trace("Parsed {}", (Object)element);
                    offset += element.templateLength;
                }
                if (extended) {
                    logger.warn("Access and Usage not parsed: " + HexUtils.bin2hex((byte[])Arrays.copyOfRange(tmpl, offset, tmpl.length)));
                    r.add(new GPKeyInfo(version, id, elements, -1, -1));
                    continue;
                }
                r.add(new GPKeyInfo(version, id, elements, -1, -1));
            }
        }
        return r;
    }

    private static Optional<String> getPurposeDescription(GPKeyInfo k) {
        return Optional.ofNullable(keyVersionPurposes.get(k.getVersion()));
    }

    private static Optional<String> getTypeDescription(GPKeyInfo k) {
        if (k.getType() == GPKey.RSA_PUB_E || k.getType() == GPKey.RSA_PUB_N && k.getLength() > 0) {
            return Optional.of("RSA-" + k.getLength() * 8 + " public");
        }
        if (k.getType() == GPKey.AES && k.getLength() > 0) {
            return Optional.of("AES-" + k.getLength() * 8);
        }
        return Optional.empty();
    }

    private static Optional<String> getKeyDescription(GPKeyInfo k) {
        Optional<String> t = GPKeyInfo.getTypeDescription(k);
        Optional<String> p = GPKeyInfo.getPurposeDescription(k);
        Optional<String> f = k.getVersion() == 0 || k.getVersion() == 255 ? Optional.of("factory key") : Optional.empty();
        return Stream.of(t, p, f).filter(Optional::isPresent).map(Optional::get).reduce((a, b) -> a + ", " + b);
    }

    public static String toString(List<GPKeyInfo> list) {
        StringBuilder sb = new StringBuilder();
        for (GPKeyInfo k : list) {
            String description = GPKeyInfo.getKeyDescription(k).map(e -> " (" + e + ")").orElse("");
            sb.append(String.format("Version: %3d (0x%02X) ID: %3d (0x%02X) type: %-12s length: %3d%s%n", new Object[]{k.getVersion(), k.getVersion(), k.getID(), k.getID(), k.getType(), k.getLength(), description}));
        }
        return sb.toString();
    }

    public int getID() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public GPKey getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("type=" + String.valueOf((Object)this.type));
        if (this.version >= 1 && this.version <= 127) {
            s.append(" version=" + GPUtils.intString(this.version));
        }
        if (this.id >= 0 && this.id <= 127) {
            s.append(" id=" + GPUtils.intString(this.id));
        }
        s.append(" len=" + this.length);
        return s.toString();
    }

    static {
        LinkedHashMap<Integer, String> tmp = new LinkedHashMap<Integer, String>();
        tmp.put(112, "Token Verification");
        tmp.put(113, "Receipt Generation");
        tmp.put(115, "DAP Verification");
        keyVersionPurposes = Collections.unmodifiableMap(tmp);
    }

    public static enum GPKey {
        PRIVATE(0, "Reserved for private use"),
        EXTENDED(255, "Extended format"),
        RFU_SYMMETRICAL(134, "RFU (symmetric algorithm)"),
        RFU_ASYMMETRICAL(169, "RFU (asymmetric algorithm)"),
        DES3(128, "DES - mode (ECB/CBC) implicitly known"),
        DES3_RESERVED(129, "Reserved (Triple DES)"),
        DES3_CBC(130, "Triple DES in CBC mode"),
        DES_ECB(131, "DES in ECB mode"),
        DES_CBC(132, "DES in CBC mode"),
        PSK_TLS(133, "Pre-Shared Key for Transport Layer Security"),
        AES(136, "AES (16, 24, or 32 long keys)"),
        HMAC_SHA1(144, "HMAC-SHA1 - length of HMAC is implicitly known"),
        HMAC_SHA1_160(145, "MAC-SHA1-160 - length of HMAC is 160 bits"),
        RSA_PUB_E(160, "RSA Public Key - public exponent e component (clear text)"),
        RSA_PUB_N(161, "RSA Public Key - modulus N component (clear text)"),
        RSA_PRIV_N(162, "RSA Private Key - modulus N component"),
        RSA_PRIV_D(163, "RSA Private Key - private exponent d component"),
        RSA_PRIV_P(164, "RSA Private Key - Chinese Remainder P component"),
        RSA_PRIV_Q(165, "RSA Private Key - Chinese Remainder Q component"),
        RSA_PRIV_PQ(166, "RSA Private Key - Chinese Remainder PQ component"),
        RSA_PRIV_DP1(167, "RSA Private Key - Chinese Remainder DP1 component"),
        RSA_PRIV_DQ1(168, "RSA Private Key - Chinese Remainder DQ1 component"),
        EC_PUB(176, "ECC public key"),
        EC_PRIV(177, "ECC private key"),
        EC_FIELD_P(178, "ECC field parameter P (field specification)"),
        EC_FIELD_A(179, "ECC field parameter A (first coefficient)"),
        EC_FIELD_B(180, "ECC field parameter B (second coefficient)"),
        EC_FIELD_G(181, "ECC field parameter G (generator)"),
        EC_FIELD_N(182, "ECC field parameter N (order of generator)"),
        EC_FIELD_K(183, "ECC field parameter k (cofactor of order of generator)"),
        EC_PARAM_REF(240, "ECC key parameters reference");

        private final int type;
        private final String description;

        private GPKey(int type, String desc) {
            this.type = type;
            this.description = desc;
        }

        public int getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public static Optional<GPKey> get(int type) {
            GPKey result;
            if (0 <= type && type <= 127) {
                result = PRIVATE;
            } else if (type == 134 || type == 135 || 137 <= type && type <= 143 || 146 <= type && type <= 159) {
                result = RFU_SYMMETRICAL;
            } else if (169 <= type && type <= 175) {
                result = RFU_ASYMMETRICAL;
            } else if (184 <= type && type <= 239) {
                result = RFU_ASYMMETRICAL;
            } else if (241 <= type && type <= 254) {
                result = RFU_ASYMMETRICAL;
            } else {
                return Arrays.stream(GPKey.values()).filter(e -> e.type == type).findFirst();
            }
            return Optional.ofNullable(result);
        }

        public String typeName() {
            if (this == DES3 || this == DES3_RESERVED) {
                return "3DES";
            }
            if (this == RSA_PUB_N || this == RSA_PUB_E) {
                return "RSA";
            }
            if (this == EC_PUB) {
                return "EC";
            }
            return this.name();
        }
    }

    public static class GPKeyInfoElement {
        final GPKey key;
        final int keyLength;
        final int templateLength;

        public static GPKeyInfoElement fromExtendedBytes(byte[] buf, int offset) {
            int templateLength;
            if (buf[offset] != -1) {
                logger.warn("Extended key element not starting with 0xFF!");
                templateLength = 3;
            } else {
                templateLength = 4;
            }
            int n = ++offset;
            int n2 = ++offset;
            int n3 = ++offset;
            ++offset;
            return new GPKeyInfoElement(GPKey.get(buf[n] & 0xFF).get(), (buf[n2] << 8) + (buf[n3] & 0xFF), templateLength);
        }

        GPKeyInfoElement(GPKey element, int elementLength, int templateLength) {
            this.key = element;
            this.templateLength = templateLength;
            this.keyLength = elementLength;
        }

        public GPKeyInfoElement(byte[] buf, int offset) {
            if (buf[offset] == -1) {
                logger.trace("Parsing E {}", (Object)HexUtils.bin2hex((byte[])Arrays.copyOfRange(buf, offset, offset + 4)));
                this.key = GPKey.get(buf[++offset] & 0xFF).get();
                this.keyLength = (buf[++offset] << 8) + (buf[++offset] & 0xFF);
                this.templateLength = 4;
            } else {
                logger.trace("Parsing B {}", (Object)HexUtils.bin2hex((byte[])Arrays.copyOfRange(buf, offset, offset + 2)));
                this.key = GPKey.get(buf[offset++] & 0xFF).get();
                int l = buf[offset++] & 0xFF;
                this.keyLength = l == 0 ? 256 : l;
                this.templateLength = 2;
            }
        }

        public static boolean isValid(GPKeyInfoElement e) {
            return e.key != GPKey.PRIVATE && e.key != GPKey.RFU_ASYMMETRICAL && e.key != GPKey.RFU_SYMMETRICAL;
        }

        public String toString() {
            return "GPKeyInfoElement{key=" + String.valueOf((Object)this.key) + ", keyLength=" + this.keyLength + ", templateLength=" + this.templateLength + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GPKeyInfoElement that = (GPKeyInfoElement)o;
            return this.keyLength == that.keyLength && this.templateLength == that.templateLength && this.key == that.key;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.key, this.keyLength, this.templateLength});
        }
    }
}

