/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.APDUBIBO;
import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvBuilder;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.capfile.AID;
import pro.javacard.capfile.CAPFile;
import pro.javacard.gp.DMTokenizer;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCardProfile;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPDataException;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSecureChannelVersion;
import pro.javacard.gp.GPUtils;
import pro.javacard.gp.ReceiptVerifier;
import pro.javacard.gp.SCP01Wrapper;
import pro.javacard.gp.SCP02Wrapper;
import pro.javacard.gp.SCP03Wrapper;
import pro.javacard.gp.SecureChannelWrapper;

public class GPSession {
    public static final int SW_NO_ERROR = 36864;
    private static final Logger logger = LoggerFactory.getLogger(GPSession.class);
    public static final EnumSet<APDUMode> defaultMode = EnumSet.of(APDUMode.MAC);
    public static final byte CLA_ISO7816 = 0;
    public static final byte CLA_GP = -128;
    public static final byte CLA_MAC = -124;
    public static final byte INS_SELECT = -92;
    public static final byte INS_INITIALIZE_UPDATE = 80;
    public static final byte INS_INSTALL = -26;
    public static final byte INS_LOAD = -24;
    public static final byte INS_DELETE = -28;
    public static final byte INS_GET_STATUS = -14;
    public static final byte INS_SET_STATUS = -16;
    public static final byte INS_PUT_KEY = -40;
    public static final byte INS_STORE_DATA = -30;
    public static final byte INS_EXTERNAL_AUTHENTICATE_82 = -126;
    public static final byte INS_GET_DATA = -54;
    public static final byte P1_INSTALL_FOR_MAKE_SELECTABLE = 8;
    public static final byte P1_INSTALL_FOR_INSTALL = 4;
    public static final byte P1_INSTALL_AND_MAKE_SELECTABLE = 12;
    public static final byte P1_INSTALL_FOR_LOAD = 2;
    public static final byte P1_MORE_BLOCKS = 0;
    public static final byte P1_LAST_BLOCK = -128;
    public static final int SW_SECURITY_STATUS_NOT_SATISFIED = 27010;
    public static final int SW_AUTHENTICATION_METHOD_BLOCKED = 27011;
    private AID sdAID;
    private GPSecureChannelVersion scpVersion;
    private int scpKeyVersion = 0;
    GPCardProfile profile;
    private int blockSize = 255;
    private GPCardKeys cardKeys = null;
    private byte[] sessionContext;
    private SecureChannelWrapper wrapper = null;
    private APDUBIBO channel;
    private GPRegistry registry = null;
    private DMTokenizer tokenizer = DMTokenizer.none();
    private ReceiptVerifier verifier = new ReceiptVerifier.NullVerifier();
    private boolean dirty = true;

    public GPSession(APDUBIBO channel, AID sdAID) {
        this(channel, sdAID, GPCardProfile.defaultProfile());
    }

    public GPSession(APDUBIBO channel, AID sdAID, GPCardProfile profile) {
        if (channel == null) {
            throw new IllegalArgumentException("A card session is required");
        }
        this.channel = channel;
        this.sdAID = sdAID;
        this.profile = profile;
    }

    public static GPSession discover(APDUBIBO channel) throws GPException, IOException {
        BerTlv isdaid;
        BerTlvs tlvs;
        byte[] identify_aid;
        CommandAPDU identify;
        ResponseAPDU identify_resp;
        byte[] identify_data;
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        CommandAPDU command = new CommandAPDU(0, -92, 4, 0, 256);
        ResponseAPDU response = channel.transmit(command);
        if (response.getSW() == 27266 && (identify_data = (identify_resp = channel.transmit(identify = new CommandAPDU(0, -92, 4, 0, identify_aid = HexUtils.hex2bin((String)"A000000167413000FF"), 256))).getData()).length > 15 && identify_data[14] == 0) {
            throw new GPException("Unfused JCOP detected");
        }
        if (response.getSW() == 27271) {
            logger.debug("Trying default ISD AID ...");
            return GPSession.connect(channel, new AID(GPData.defaultISDBytes));
        }
        GPException.check(response, "Could not SELECT default selected", 25219);
        if (response.getSW() == 25219) {
            logger.warn("Card Manager is LOCKED");
        }
        try {
            BerTlvParser parser = new BerTlvParser();
            tlvs = parser.parse(response.getData());
            GPUtils.trace_tlv(response.getData(), logger);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            logger.warn("Could not parse SELECT response: " + e.getMessage());
            throw new GPDataException("Could not auto-detect ISD AID", response.getData());
        }
        BerTlv fcitag = tlvs.find(new BerTag(111));
        if (fcitag != null && (isdaid = fcitag.find(new BerTag(132))) != null && isdaid.getBytesValue().length > 0) {
            AID detectedAID = new AID(isdaid.getBytesValue());
            logger.debug("Auto-detected ISD: " + String.valueOf(detectedAID));
            return new GPSession(channel, detectedAID);
        }
        throw new GPDataException("Could not auto-detect ISD AID", response.getData());
    }

    public static GPSession connect(APDUBIBO channel, AID sdAID) throws IOException, GPException {
        if (channel == null) {
            throw new IllegalArgumentException("A card session is required");
        }
        if (sdAID == null) {
            throw new IllegalArgumentException("Security Domain AID is required");
        }
        logger.debug("(I)SD AID: " + String.valueOf(sdAID));
        GPSession gp = new GPSession(channel, sdAID);
        gp.select(sdAID);
        return gp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        Properties prop = new Properties();
        try (InputStream versionfile = GPSession.class.getResourceAsStream("git.properties");){
            if (versionfile == null) {
                String string2 = "unsupported";
                return string2;
            }
            prop.load(versionfile);
            String string = prop.getProperty("git.commit.id.describe", "unknown-development");
            return string;
        }
        catch (IOException e) {
            return "unknown-error";
        }
    }

    public void setBlockSize(int size) {
        this.blockSize = size;
    }

    public void setTokenizer(DMTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public void setVerifier(ReceiptVerifier verifier) {
        this.verifier = verifier;
    }

    public DMTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public AID getAID() {
        return new AID(this.sdAID.getBytes());
    }

    public GPSecureChannelVersion getSecureChannel() {
        return this.scpVersion;
    }

    public APDUBIBO getCardChannel() {
        return this.channel;
    }

    public int getScpKeyVersion() {
        return this.scpKeyVersion;
    }

    void select(AID sdAID) throws GPException {
        CommandAPDU command = new CommandAPDU(0, -92, 4, 0, sdAID.getBytes(), 256);
        ResponseAPDU resp = this.channel.transmit(command);
        if (resp.getSW() == 25219) {
            logger.warn("SELECT returned 6283 - CARD_LOCKED");
        }
        GPException.check(resp, "Could not SELECT", 25219);
        this.parse_select_response(resp.getData());
    }

    private void parse_select_response(byte[] fci) throws GPException {
        BerTlvs tlvs;
        try {
            BerTlvParser parser = new BerTlvParser();
            tlvs = parser.parse(fci);
            GPUtils.trace_tlv(fci, logger);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
            logger.warn("Could not parse SELECT response: " + e.getMessage());
            return;
        }
        BerTlv fcitag = tlvs.find(new BerTag(111));
        if (fcitag != null) {
            BerTlv prop;
            AID detectedAID;
            BerTlv isdaid = fcitag.find(new BerTag(132));
            if (isdaid != null && !(detectedAID = new AID(isdaid.getBytesValue())).equals((Object)this.sdAID)) {
                logger.warn(String.format("SD AID in FCI (%s) does not match the requested AID (%s). Using reported AID!", detectedAID, this.sdAID));
                this.sdAID = detectedAID;
            }
            if ((prop = fcitag.find(new BerTag(165))) != null) {
                BerTlv maxbs;
                BerTlv lc;
                BerTlv isdd = prop.find(new BerTag(115));
                if (isdd != null) {
                    BerTlv oidtag = isdd.find(new BerTag(6));
                    if (oidtag != null) {
                        if (Arrays.equals(oidtag.getBytesValue(), HexUtils.hex2bin((String)"2A864886FC6B01"))) {
                            BerTlv veroid;
                            BerTlv vertag = isdd.find(new BerTag(96));
                            if (vertag != null && (veroid = vertag.find(new BerTag(6))) != null) {
                                logger.debug("Auto-detected GP version: " + GPData.oid2version(veroid.getBytesValue()));
                            }
                        } else if (GPData.oid2string(oidtag.getBytesValue()).startsWith("1.2.840.114283.4.") && oidtag.getBytesValue().length == 9) {
                            byte[] data = oidtag.getBytesValue();
                            logger.debug("Auto-detected SCP version: {}", (Object)GPSecureChannelVersion.valueOf(data[7] & 0xFF, data[8] & 0xFF));
                        } else {
                            logger.warn("Unrecognized card recognition data: {}", (Object)HexUtils.bin2hex((byte[])oidtag.getBytesValue()));
                        }
                    } else {
                        logger.warn("No Global Platform OID found");
                    }
                }
                if ((lc = prop.find(new BerTag(159, 110))) != null) {
                    logger.debug("Lifecycle data (ignored): " + HexUtils.bin2hex((byte[])lc.getBytesValue()));
                }
                if ((maxbs = prop.find(new BerTag(159, 101))) != null) {
                    this.setBlockSize(maxbs.getBytesValue());
                }
            } else {
                logger.warn("No mandatory proprietary info present in FCI");
            }
        } else {
            logger.warn("No FCI returned to SELECT");
        }
    }

    private void setBlockSize(byte[] blocksize) {
        int bs = new BigInteger(1, blocksize).intValue();
        if (bs > this.blockSize) {
            logger.warn("Ignoring auto-detected block size that exceeds set maximum: " + bs);
        } else {
            this.blockSize = bs;
            logger.debug("Auto-detected block size: " + this.blockSize);
        }
    }

    public List<GPKeyInfo> getKeyInfoTemplate() throws IOException, GPException {
        byte[] tmpl = this.wrapper != null ? this.transmit(new CommandAPDU(-128, -54, 0, 224, 256)).getData() : GPData.fetchKeyInfoTemplate(this.channel);
        return new ArrayList<GPKeyInfo>(GPKeyInfo.parseTemplate(tmpl));
    }

    private void normalizeSecurityLevel(EnumSet<APDUMode> securityLevel) {
        if (securityLevel.contains((Object)APDUMode.RENC)) {
            securityLevel.add(APDUMode.ENC);
            securityLevel.add(APDUMode.RMAC);
        }
        if (securityLevel.contains((Object)APDUMode.ENC) || securityLevel.contains((Object)APDUMode.RMAC)) {
            securityLevel.add(APDUMode.MAC);
        }
    }

    public void openSecureChannel(GPCardKeys keys, GPSecureChannelVersion scp, byte[] host_challenge, EnumSet<APDUMode> securityLevel) throws IOException, GPException {
        byte[] host_cryptogram;
        boolean s16;
        this.normalizeSecurityLevel(securityLevel);
        logger.info("Using card master key(s) with version {} for setting up session with {} ", (Object)keys.getKeyInfo().getVersion(), (Object)securityLevel.stream().map(Enum::name).collect(Collectors.joining(", ")));
        boolean bl = s16 = scp != null && scp.scp == GPSecureChannelVersion.SCP.SCP03 && (scp.i & 1) == 1 || host_challenge != null && host_challenge.length == 16;
        if (s16) {
            logger.debug("Using S16 mode");
        }
        if (host_challenge == null) {
            host_challenge = GPCrypto.random(s16 ? 16 : 8);
            logger.trace("Generated host challenge: " + HexUtils.bin2hex((byte[])host_challenge));
        }
        int init_p2 = scp != null && scp.scp == GPSecureChannelVersion.SCP.SCP01 ? keys.getKeyInfo().getID() : 0;
        CommandAPDU initUpdate = new CommandAPDU(-128, 80, keys.getKeyInfo().getVersion(), init_p2, host_challenge, 256);
        ResponseAPDU response = this.channel.transmit(initUpdate);
        int sw = response.getSW();
        if (sw == 26368 && !s16) {
            logger.warn("Wrong length with implicit S8 mode. Hoping for S16 mode and trying again.");
            s16 = true;
            host_challenge = GPCrypto.random(s16 ? 16 : 8);
            response = this.channel.transmit(new CommandAPDU(-128, 80, keys.getKeyInfo().getVersion(), init_p2, host_challenge, 256));
        }
        if (sw == 27010 || sw == 27011) {
            throw new GPException(sw, "INITIALIZE UPDATE failed, card LOCKED?");
        }
        GPException.check(response, "INITIALIZE UPDATE failed", new int[0]);
        byte[] update_response = response.getData();
        if (update_response.length < 28) {
            throw new GPDataException("INITIALIZE UPDATE response with too small length", update_response);
        }
        int update_len = 0;
        switch (update_response[11]) {
            case 1: 
            case 2: {
                update_len = 28;
                break;
            }
            case 3: {
                update_len = 29;
                byte i = update_response[12];
                if ((i & 0x10) == 16) {
                    update_len += 3;
                }
                if ((i & 1) != 1) break;
                if (!s16) {
                    logger.warn("S16 mode reported by card but not requested!");
                }
                update_len += 16;
                break;
            }
            default: {
                throw new GPDataException("Unsupported SCP version", update_response);
            }
        }
        if (update_len != update_response.length) {
            throw new GPException("Invalid INITIALIZE UPDATE response length: " + update_response.length);
        }
        int offset = 0;
        byte[] diversification_data = Arrays.copyOfRange(update_response, 0, 10);
        this.scpKeyVersion = update_response[offset += diversification_data.length] & 0xFF;
        int scpv = update_response[++offset] & 0xFF;
        ++offset;
        if (scpv == 3) {
            this.scpVersion = GPSecureChannelVersion.valueOf(scpv, update_response[offset]);
            ++offset;
        } else {
            this.scpVersion = GPSecureChannelVersion.valueOf(scpv);
        }
        byte[] card_challenge = Arrays.copyOfRange(update_response, offset, offset + (s16 ? 16 : 8));
        byte[] card_cryptogram = Arrays.copyOfRange(update_response, offset += card_challenge.length, offset + (s16 ? 16 : 8));
        Object seq = this.scpVersion.scp == GPSecureChannelVersion.SCP.SCP02 ? Arrays.copyOfRange(update_response, 12, 14) : (Object)(this.scpVersion.scp == GPSecureChannelVersion.SCP.SCP03 && (this.scpVersion.i & 0x10) == 16 ? Arrays.copyOfRange(update_response, offset += card_cryptogram.length, offset + 3) : null);
        logger.debug("KDD: {}", (Object)HexUtils.bin2hex((byte[])diversification_data));
        if (seq != null) {
            logger.debug("SSC: {}", (Object)HexUtils.bin2hex((byte[])seq));
        }
        logger.debug("Host challenge: " + HexUtils.bin2hex((byte[])host_challenge));
        logger.debug("Card challenge: " + HexUtils.bin2hex((byte[])card_challenge));
        logger.debug("Card reports {} with key version {}", (Object)this.scpVersion, (Object)GPUtils.intString(this.scpKeyVersion));
        GPKeyInfo keyInfo = keys.getKeyInfo();
        if (keyInfo.getVersion() > 0 && this.scpKeyVersion != keyInfo.getVersion()) {
            throw new GPException("Key version mismatch: " + keyInfo.getVersion() + " != " + this.scpKeyVersion);
        }
        if (this.scpVersion.scp == GPSecureChannelVersion.SCP.SCP01 && securityLevel.contains((Object)APDUMode.RMAC)) {
            logger.warn("SCP01 does not support RMAC, removing.");
        }
        this.cardKeys = keys.diversify(this.scpVersion.scp, diversification_data);
        logger.info("Diversified card keys: {}", (Object)this.cardKeys);
        if (this.scpVersion.scp == GPSecureChannelVersion.SCP.SCP03 && (this.scpVersion.i & 0x10) == 16) {
            byte[] ctx = GPUtils.concatenate(new byte[][]{seq, this.sdAID.getBytes()});
            logger.trace("Challenge calculation context: {}", (Object)HexUtils.bin2hex((byte[])ctx));
            byte[] my_card_challenge = keys.scp3_kdf(GPCardKeys.KeyPurpose.ENC, GPCrypto.scp03_kdf_blocka((byte)2, s16 ? 128 : 64), ctx, s16 ? 16 : 8);
            if (!Arrays.equals(my_card_challenge, card_challenge)) {
                logger.warn("Pseudorandom card challenge does not match expected: {} vs {}", (Object)HexUtils.bin2hex((byte[])my_card_challenge), (Object)HexUtils.bin2hex((byte[])card_challenge));
            } else {
                logger.debug("Pseudorandom card challenge matches expected value: {}", (Object)HexUtils.bin2hex((byte[])my_card_challenge));
            }
        }
        this.sessionContext = this.scpVersion.scp == GPSecureChannelVersion.SCP.SCP02 ? (byte[])seq.clone() : GPUtils.concatenate(host_challenge, card_challenge);
        byte[] encKey = this.cardKeys.getSessionKey(GPCardKeys.KeyPurpose.ENC, this.sessionContext);
        byte[] macKey = this.cardKeys.getSessionKey(GPCardKeys.KeyPurpose.MAC, this.sessionContext);
        byte[] rmacKey = this.cardKeys.getSessionKey(GPCardKeys.KeyPurpose.RMAC, this.sessionContext);
        logger.info("Session keys: ENC={} MAC={} RMAC={}", new Object[]{HexUtils.bin2hex((byte[])encKey), HexUtils.bin2hex((byte[])macKey), rmacKey == null ? "N/A" : HexUtils.bin2hex((byte[])rmacKey)});
        byte[] cntx = GPUtils.concatenate(host_challenge, card_challenge);
        byte[] my_card_cryptogram = this.scpVersion.scp == GPSecureChannelVersion.SCP.SCP01 || this.scpVersion.scp == GPSecureChannelVersion.SCP.SCP02 ? GPCrypto.mac_3des(cntx, encKey, new byte[8]) : GPCrypto.scp03_kdf(macKey, (byte)0, cntx, s16 ? 128 : 64);
        if (!Arrays.equals(card_cryptogram, my_card_cryptogram)) {
            throw new GPException("Card cryptogram invalid!\nReceived: " + HexUtils.bin2hex((byte[])card_cryptogram) + "\nExpected: " + HexUtils.bin2hex((byte[])my_card_cryptogram) + "\n!!! DO NOT RE-TRY THE SAME COMMAND/KEYS OR YOU MAY BRICK YOUR CARD !!!");
        }
        logger.debug("Verified card cryptogram: " + HexUtils.bin2hex((byte[])my_card_cryptogram));
        switch (this.scpVersion.scp) {
            case SCP01: {
                host_cryptogram = GPCrypto.mac_3des(GPUtils.concatenate(card_challenge, host_challenge), encKey, new byte[8]);
                this.wrapper = new SCP01Wrapper(encKey, macKey, this.blockSize);
                break;
            }
            case SCP02: {
                host_cryptogram = GPCrypto.mac_3des(GPUtils.concatenate(card_challenge, host_challenge), encKey, new byte[8]);
                this.wrapper = new SCP02Wrapper(encKey, macKey, rmacKey, this.blockSize);
                break;
            }
            case SCP03: {
                host_cryptogram = GPCrypto.scp03_kdf(macKey, (byte)1, cntx, s16 ? 128 : 64);
                this.wrapper = new SCP03Wrapper(encKey, macKey, rmacKey, this.blockSize, s16);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown SCP");
            }
        }
        logger.debug("Calculated host cryptogram: " + HexUtils.bin2hex((byte[])host_cryptogram));
        int P1 = APDUMode.getSetValue(securityLevel);
        CommandAPDU externalAuthenticate = new CommandAPDU(-124, -126, P1, 0, host_cryptogram);
        response = this.transmit(externalAuthenticate);
        GPException.check(response, "EXTERNAL AUTHENTICATE failed", new int[0]);
        this.wrapper.setSecurityLevel(securityLevel);
    }

    public ResponseAPDU transmit(CommandAPDU command) throws IOException {
        try {
            CommandAPDU wrapped = this.wrapper.wrap(command);
            ResponseAPDU resp = null;
            List<byte[]> chunks = GPUtils.splitArray(wrapped.getData(), this.blockSize);
            if (chunks.size() > 1) {
                logger.debug("Chaining in {} chunks", (Object)chunks.size());
            }
            for (int i = 0; i < chunks.size(); ++i) {
                boolean last = i == chunks.size() - 1;
                int p1 = last ? command.getP1() : command.getP1() | 0x80;
                resp = this.channel.transmit(new CommandAPDU(wrapped.getCLA(), wrapped.getINS(), p1, wrapped.getP2(), chunks.get(i), 256));
                if (last) continue;
                GPException.check(resp);
            }
            return this.wrapper.unwrap(resp);
        }
        catch (GPException e) {
            throw new IOException("Secure channel failure: " + e.getMessage(), e);
        }
    }

    private ResponseAPDU transmitLV(CommandAPDU command) throws IOException {
        logger.trace("LV payload: ");
        try {
            GPUtils.trace_lv(command.getData(), logger);
        }
        catch (Exception e) {
            logger.error("Invalid LV: {}", (Object)HexUtils.bin2hex((byte[])command.getData()));
        }
        return this.transmit(command);
    }

    private ResponseAPDU transmitTLV(CommandAPDU command) throws IOException {
        logger.trace("TLV payload: ");
        try {
            GPUtils.trace_tlv(command.getData(), logger);
        }
        catch (Exception e) {
            logger.error("Invalid TLV: {}", (Object)HexUtils.bin2hex((byte[])command.getData()));
        }
        return this.transmit(command);
    }

    public void loadCapFile(CAPFile cap, AID targetDomain, GPData.LFDBH hashFunction) throws IOException, GPException {
        if (targetDomain == null) {
            targetDomain = this.sdAID;
        }
        this.loadCapFile(cap, targetDomain, null, null, hashFunction);
    }

    public void loadCapFile(CAPFile cap, AID targetDomain, AID dapDomain, byte[] dap, GPData.LFDBH hashFunction) throws GPException, IOException {
        byte[] hash = hashFunction == null ? new byte[]{} : cap.getLoadFileDataHash(hashFunction.algo);
        byte[] code = cap.getCode();
        byte[] loadParams = new byte[]{};
        AID pkg = cap.getPackageAID();
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(pkg.getLength());
            bo.write(pkg.getBytes());
            bo.write(targetDomain.getLength());
            bo.write(targetDomain.getBytes());
            bo.write(hash.length);
            bo.write(hash);
            bo.write(GPUtils.encodeLength(loadParams.length));
            bo.write(loadParams);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -26, 2, 0, bo.toByteArray(), 256);
        command = this.tokenizer.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for load] failed", new int[0]);
        this.verifier.check(response, ReceiptVerifier.load(pkg, targetDomain));
        ByteArrayOutputStream loadBlock = new ByteArrayOutputStream();
        try {
            if (dap != null && dapDomain != null) {
                loadBlock.write(226);
                loadBlock.write(GPUtils.encodeLength(dapDomain.getLength() + dap.length + GPUtils.encodeLength(dap.length).length + 3));
                loadBlock.write(79);
                loadBlock.write(dapDomain.getLength());
                loadBlock.write(dapDomain.getBytes());
                loadBlock.write(195);
                loadBlock.write(GPUtils.encodeLength(dap.length));
                loadBlock.write(dap);
            }
            loadBlock.write(196);
            loadBlock.write(GPUtils.encodeLength(code.length));
            loadBlock.write(code);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<byte[]> blocks = GPUtils.splitArray(loadBlock.toByteArray(), this.wrapper.getBlockSize());
        for (int i = 0; i < blocks.size(); ++i) {
            int p1 = i == blocks.size() - 1 ? -128 : 0;
            CommandAPDU load = new CommandAPDU(-128, -24, p1, (int)((byte)i), blocks.get(i), 256);
            response = this.transmit(load);
            GPException.check(response, "LOAD failed", new int[0]);
        }
        this.dirty = true;
    }

    public void installAndMakeSelectable(AID packageAID, AID appletAID, AID instanceAID, Set<GPRegistryEntry.Privilege> privileges, byte[] installParams) throws GPException, IOException {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        byte[] data = this.buildInstallData(packageAID, appletAID, instanceAID, privileges, installParams);
        CommandAPDU command = new CommandAPDU(-128, -26, 12, 0, data);
        command = this.tokenizer.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for install and make selectable] failed", new int[0]);
        this.verifier.check(response, ReceiptVerifier.install_make_selectable(packageAID, instanceAID));
        this.dirty = true;
    }

    private byte[] buildInstallData(AID packageAID, AID appletAID, AID instanceAID, Set<GPRegistryEntry.Privilege> privileges, byte[] installParams) {
        if (instanceAID == null) {
            instanceAID = appletAID;
        }
        if (installParams == null || installParams.length == 0) {
            installParams = new byte[]{-55, 0};
        } else {
            boolean valid = false;
            try {
                BerTlvParser parser = new BerTlvParser();
                BerTlvs tlvs = parser.parse(installParams);
                GPUtils.trace_tlv(installParams, logger);
                if (tlvs.find(new BerTag(201)) != null) {
                    valid = true;
                }
            }
            catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
                logger.warn("Installation parameters did not parse as valid TLV, assuming simple app parameters!");
            }
            if (!valid) {
                installParams = new BerTlvBuilder().addBytes(new BerTag(201), installParams).buildArray();
            }
        }
        logger.trace("Installation parameters: {}", (Object)HexUtils.bin2hex((byte[])installParams));
        byte[] privs = GPRegistryEntry.Privilege.toBytes(privileges);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(packageAID.getLength());
            bo.write(packageAID.getBytes());
            bo.write(appletAID.getLength());
            bo.write(appletAID.getBytes());
            bo.write(instanceAID.getLength());
            bo.write(instanceAID.getBytes());
            bo.write(privs.length);
            bo.write(privs);
            bo.write(GPUtils.encodeLength(installParams.length));
            bo.write(installParams);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return bo.toByteArray();
    }

    public void extradite(AID what, AID to) throws GPException, IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(to.getLength());
            bo.write(to.getBytes());
            bo.write(0);
            bo.write(what.getLength());
            bo.write(what.getBytes());
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -26, 16, 0, bo.toByteArray());
        command = this.tokenizer.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for extradition] failed", new int[0]);
        this.verifier.check(response, ReceiptVerifier.extradite(this.sdAID, what, to));
        this.dirty = true;
    }

    public void installForPersonalization(AID aid) throws IOException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(0);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU install = new CommandAPDU(-128, -26, 32, 0, bo.toByteArray(), 256);
        GPException.check(this.transmitLV(install), "INSTALL [for personalization] failed", new int[0]);
    }

    public byte[] personalizeSingle(AID aid, byte[] data, int P1) throws IOException, GPException {
        return this.personalize(aid, Collections.singletonList(data), P1).get(0);
    }

    public void personalize(AID aid, byte[] data, int P1) throws IOException, GPException {
        this.installForPersonalization(aid);
        this.storeData(data, P1);
    }

    public List<byte[]> personalize(AID aid, List<byte[]> data, int P1) throws IOException, GPException {
        this.installForPersonalization(aid);
        return this.storeData(data, P1);
    }

    public byte[] storeDataSingle(byte[] data, int P1) throws IOException, GPException {
        if (data.length > this.wrapper.getBlockSize()) {
            throw new IllegalArgumentException("block size is bigger than possibility to send: " + data.length + ">" + this.wrapper.getBlockSize());
        }
        return this.storeData(Collections.singletonList(data), P1).get(0);
    }

    public void storeData(byte[] data, int P1) throws IOException, GPException {
        List<byte[]> blocks = GPUtils.splitArray(data, this.wrapper.getBlockSize());
        this.storeData(blocks, P1);
    }

    public List<byte[]> storeData(List<byte[]> blocks, int P1) throws IOException, GPException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < blocks.size(); ++i) {
            int p1 = i == blocks.size() - 1 ? P1 | 0x80 : P1 & 0x7F;
            CommandAPDU store = new CommandAPDU(-128, -30, p1, i, blocks.get(i), 256);
            result.add(GPException.check(this.transmit(store), "STORE DATA failed", new int[0]).getData());
        }
        return result;
    }

    public byte[] storeDataSingle(byte[] data, int P1, int P2) throws IOException, GPException {
        CommandAPDU store = new CommandAPDU(-128, -30, P1, P2, data, 256);
        return GPException.check(this.transmit(store), "STORE DATA failed", new int[0]).getData();
    }

    public void makeDefaultSelected(AID aid) throws IOException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        byte[] privileges = GPRegistryEntry.Privilege.toBytes(EnumSet.of(GPRegistryEntry.Privilege.CardReset));
        try {
            bo.write(0);
            bo.write(0);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
            bo.write(privileges.length);
            bo.write(privileges);
            bo.write(0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -26, 8, 0, bo.toByteArray());
        command = this.tokenizer.tokenize(command);
        ResponseAPDU response = this.transmitLV(command);
        GPException.check(response, "INSTALL [for make selectable] failed", new int[0]);
        this.dirty = true;
    }

    public void lockUnlockApplet(AID app, boolean lock) throws IOException, GPException {
        CommandAPDU cmd = new CommandAPDU(-128, -16, 64, lock ? 128 : 0, app.getBytes());
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed", new int[0]);
        this.dirty = true;
    }

    public void setCardStatus(GPRegistryEntry.ISDLifeCycle status) throws IOException, GPException {
        logger.debug("Setting status to {}", (Object)status);
        CommandAPDU cmd = new CommandAPDU(-128, -16, 128, (int)status.getValue());
        ResponseAPDU response = this.transmit(cmd);
        GPException.check(response, "SET STATUS failed", new int[0]);
        this.dirty = true;
    }

    public void deleteAID(AID aid, boolean deleteDeps) throws GPException, IOException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(79);
            bo.write(aid.getLength());
            bo.write(aid.getBytes());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CommandAPDU command = new CommandAPDU(-128, -28, 0, deleteDeps ? 128 : 0, bo.toByteArray());
        command = this.tokenizer.tokenize(command);
        ResponseAPDU response = this.transmitTLV(command);
        GPException.check(response, "DELETE failed", new int[0]);
        this.verifier.check(response, ReceiptVerifier.delete(aid));
        this.dirty = true;
    }

    public void deleteKey(Integer keyver, Integer keyid) throws GPException, IOException {
        if (keyid == null && keyver == null) {
            throw new IllegalArgumentException("Must specify either key version or key ID");
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        if (keyid != null) {
            bo.write(208);
            bo.write(1);
            bo.write(1);
        }
        if (keyver != null) {
            bo.write(210);
            bo.write(1);
            bo.write(keyver);
        }
        CommandAPDU delete = new CommandAPDU(-128, -28, 0, 0, bo.toByteArray());
        ResponseAPDU response = this.transmit(delete);
        String msg = String.format("DELETE failed for key %s", keyver != null ? GPUtils.intString(keyver) : GPUtils.intString(keyid));
        GPException.check(response, msg, new int[0]);
    }

    public void renameISD(AID newaid) throws GPException, IOException {
        CommandAPDU rename = new CommandAPDU(-128, -30, 144, 0, GPUtils.concatenate({79, (byte)newaid.getLength()}, newaid.getBytes()));
        ResponseAPDU response = this.transmit(rename);
        GPException.check(response, "Rename failed", new int[0]);
    }

    public byte[] encryptDEK(byte[] plaintext) throws GeneralSecurityException {
        return this.cardKeys.encrypt(plaintext, this.sessionContext);
    }

    private byte[] encodeKey(GPCardKeys dek, byte[] other, GPKeyInfo.GPKey type) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (type == GPKeyInfo.GPKey.AES) {
                int n = other.length % 16 + 1;
                byte[] plaintext = GPCrypto.random(n * other.length);
                System.arraycopy(other, 0, plaintext, 0, other.length);
                byte[] cgram = dek.encrypt(plaintext, this.sessionContext);
                byte[] kcv = GPCrypto.kcv_aes(other);
                baos.write(GPKeyInfo.GPKey.AES.getType());
                baos.write(cgram.length + 1);
                baos.write(other.length);
                baos.write(cgram);
                baos.write(kcv.length);
                baos.write(kcv);
            } else if (type == GPKeyInfo.GPKey.DES3) {
                byte[] cgram = dek.encrypt(other, this.sessionContext);
                byte[] kcv = GPCrypto.kcv_3des(other);
                baos.write(GPKeyInfo.GPKey.DES3.getType());
                baos.write(cgram.length);
                baos.write(cgram);
                baos.write(kcv.length);
                baos.write(kcv);
            }
            return baos.toByteArray();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GPException("Could not wrap key", e);
        }
    }

    private byte[] encodeKey(GPCardKeys dek, GPCardKeys other, GPCardKeys.KeyPurpose p) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (other.getKeyInfo().getType() == GPKeyInfo.GPKey.AES) {
                byte[] cgram = dek.encryptKey(other, p, this.sessionContext);
                byte[] kcv = other.kcv(p);
                baos.write(GPKeyInfo.GPKey.AES.getType());
                baos.write(cgram.length + 1);
                baos.write(other.getKeyInfo().getLength());
                baos.write(cgram);
                baos.write(kcv.length);
                baos.write(kcv);
            } else if (other.getKeyInfo().getType() == GPKeyInfo.GPKey.DES3) {
                byte[] cgram = dek.encryptKey(other, p, this.sessionContext);
                byte[] kcv = other.kcv(p);
                baos.write(GPKeyInfo.GPKey.DES3.getType());
                baos.write(cgram.length);
                baos.write(cgram);
                baos.write(kcv.length);
                baos.write(kcv);
            }
            return baos.toByteArray();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new GPException("Could not wrap key", e);
        }
    }

    public void putKeys(GPCardKeys keys, boolean replace) throws GPException, IOException {
        logger.debug("PUT KEY version {} replace={} {}", new Object[]{keys.getKeyInfo().getVersion(), replace, keys});
        int P1 = 0;
        if (replace) {
            P1 = keys.getKeyInfo().getVersion();
        }
        int P2 = 1;
        P2 |= 0x80;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(keys.getKeyInfo().getVersion());
        for (GPCardKeys.KeyPurpose p : GPCardKeys.KeyPurpose.cardKeys()) {
            bo.write(this.encodeKey(this.cardKeys, keys, p));
        }
        CommandAPDU command = new CommandAPDU(-128, -40, P1, P2, bo.toByteArray());
        ResponseAPDU response = this.transmit(command);
        GPException.check(response, "PUT KEY failed", new int[0]);
        if (response.getData().length > 1) {
            byte[] resp = response.getData();
            int kv = resp[0] & 0xFF;
            byte[] kcvs = Arrays.copyOfRange(resp, 1, resp.length);
            List kcvstrings = GPUtils.splitArray(kcvs, 3).stream().map(HexUtils::bin2hex).collect(Collectors.toList());
            logger.info("Card stored keys with KVN {} and with KCV-s: {}", (Object)GPUtils.intString(kv), (Object)String.join((CharSequence)", ", kcvstrings));
        }
    }

    byte[] encodeRSAKey(RSAPublicKey key) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            byte[] modulus = GPUtils.positive(key.getModulus());
            byte[] exponent = GPUtils.positive(key.getPublicExponent());
            bo.write(161);
            bo.write(GPUtils.encodeLength(modulus.length));
            bo.write(modulus);
            bo.write(160);
            bo.write(GPUtils.encodeLength(exponent.length));
            bo.write(exponent);
            bo.write(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bo.toByteArray();
    }

    byte[] encodeECKey(ECPublicKey pubkey) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            byte[] key = ECNamedCurveTable.getByName((String)"secp256r1").getCurve().createPoint(pubkey.getW().getAffineX(), pubkey.getW().getAffineY()).getEncoded(false);
            bo.write(176);
            bo.write(key.length);
            bo.write(key);
            bo.write(240);
            bo.write(1);
            bo.write(0);
            bo.write(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bo.toByteArray();
    }

    public void putKey(Key key, int version, boolean replace) throws IOException, GPException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        bo.write(version);
        if (key instanceof RSAPublicKey) {
            bo.write(this.encodeRSAKey((RSAPublicKey)key));
        } else if (key instanceof ECPublicKey) {
            bo.write(this.encodeECKey((ECPublicKey)key));
        } else if (key instanceof SecretKey) {
            SecretKey sk = (SecretKey)key;
            if (sk.getAlgorithm().equals("DESede")) {
                logger.info("PUT KEY KCV: {}", (Object)HexUtils.bin2hex((byte[])GPCrypto.kcv_3des(sk.getEncoded())));
                bo.write(this.encodeKey(this.cardKeys, Arrays.copyOf(sk.getEncoded(), 16), GPKeyInfo.GPKey.DES3));
            }
            if (sk.getAlgorithm().equals("AES")) {
                logger.info("PUT KEY KCV: {}", (Object)HexUtils.bin2hex((byte[])GPCrypto.kcv_aes(sk.getEncoded())));
                bo.write(this.encodeKey(this.cardKeys, sk.getEncoded(), GPKeyInfo.GPKey.AES));
            } else {
                throw new IllegalArgumentException("Only 3DES and AES symmetric keys are supported: " + sk.getAlgorithm());
            }
        }
        CommandAPDU command = new CommandAPDU(-128, -40, replace ? version : 0, 1, bo.toByteArray(), 256);
        ResponseAPDU response = this.transmit(command);
        GPException.check(response, "PUT KEY failed", new int[0]);
        if (response.getData().length > 1) {
            byte[] resp = response.getData();
            int kv = resp[0] & 0xFF;
            byte[] kcvs = Arrays.copyOfRange(resp, 1, resp.length);
            List kcvstrings = GPUtils.splitArray(kcvs, 3).stream().map(HexUtils::bin2hex).collect(Collectors.toList());
            logger.info("Card stored key(s) {} with KCV(s) {}", (Object)GPUtils.intString(kv), (Object)String.join((CharSequence)", ", kcvstrings));
        }
    }

    public void setProfile(GPCardProfile profile) {
        this.profile = profile;
    }

    public GPCardProfile getProfile() {
        return this.profile;
    }

    public GPRegistry getRegistry() throws GPException, IOException {
        if (this.dirty) {
            this.registry = this.getStatus();
            this.dirty = false;
        }
        return this.registry;
    }

    public GPRegistryEntry getCurrentDomain() throws IOException {
        return this.getRegistry().getDomain(this.getAID()).orElseThrow(() -> new IllegalStateException("Current domain not in registry?"));
    }

    public boolean delegatedManagementEnabled() {
        return !(this.tokenizer instanceof DMTokenizer.NULLTokenizer);
    }

    private byte[] getConcatenatedStatus(int p1, byte[] data, boolean useTags) throws IOException, GPException {
        int p2 = useTags ? 2 : 0;
        CommandAPDU cmd = new CommandAPDU(-128, -14, p1, p2, data, 256);
        ResponseAPDU response = this.transmit(cmd);
        if (p1 == 128 && response.getSW() == 27270 && p2 == 2) {
            return this.getConcatenatedStatus(p1, data, false);
        }
        int sw = response.getSW();
        if (sw != 36864 && sw != 25360) {
            if (sw == 27272) {
                return response.getData();
            }
            if (sw == 27270 && p1 == 16) {
                logger.debug("GET STATUS failed for " + HexUtils.bin2hex((byte[])cmd.getBytes()) + " with " + GPData.sw2str(response.getSW()));
            } else {
                logger.warn("GET STATUS failed for " + HexUtils.bin2hex((byte[])cmd.getBytes()) + " with " + GPData.sw2str(response.getSW()));
            }
            return response.getData();
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            bo.write(response.getData());
            while (response.getSW() == 25360 && response.getData().length > 0) {
                cmd = new CommandAPDU(-128, -14, p1, p2 | 1, data, 256);
                response = this.transmit(cmd);
                GPException.check(response, "GET STATUS failed for " + HexUtils.bin2hex((byte[])cmd.getBytes()), 25360);
                bo.write(response.getData());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bo.toByteArray();
    }

    private GPRegistry getStatus() throws IOException, GPException {
        GPRegistry registry = new GPRegistry();
        byte[] data = this.getConcatenatedStatus(128, new byte[]{79, 0}, this.profile.getStatusUsesTags());
        registry.parse_and_populate(128, data, GPRegistryEntry.Kind.ISD, this.profile);
        data = this.getConcatenatedStatus(64, new byte[]{79, 0}, this.profile.getStatusUsesTags());
        registry.parse_and_populate(64, data, GPRegistryEntry.Kind.APP, this.profile);
        if (this.profile.doesReportModules()) {
            data = this.getConcatenatedStatus(16, new byte[]{79, 0}, this.profile.getStatusUsesTags());
            registry.parse_and_populate(16, data, GPRegistryEntry.Kind.PKG, this.profile);
        }
        data = this.getConcatenatedStatus(32, new byte[]{79, 0}, this.profile.getStatusUsesTags());
        registry.parse_and_populate(32, data, GPRegistryEntry.Kind.PKG, this.profile);
        return registry;
    }

    public static enum APDUMode {
        CLR(0),
        MAC(1),
        ENC(2),
        RMAC(16),
        RENC(32);

        private final int value;

        private APDUMode(int value) {
            this.value = value;
        }

        public static int getSetValue(EnumSet<APDUMode> s) {
            int v = 0;
            for (APDUMode m : s) {
                v |= m.value;
            }
            return v;
        }

        public static APDUMode fromString(String s) {
            return APDUMode.valueOf(s.trim().toUpperCase());
        }
    }
}

