/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.capfile.AID;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPUtils;

public abstract class ReceiptVerifier {
    private static final Logger log = LoggerFactory.getLogger(ReceiptVerifier.class);
    boolean log_only = false;

    protected ReceiptVerifier() {
    }

    static byte[] get_receipt(byte[] response) {
        return Arrays.copyOfRange(response, 2, 2 + response[1]);
    }

    static byte[] get_confirmation_data(byte[] response) {
        return Arrays.copyOfRange(response, 2 + response[1], response[0] + 1);
    }

    abstract boolean check(ResponseAPDU var1, byte[] var2);

    public static byte[] load(AID pkg, AID sd) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(pkg.getLength());
            baos.write(pkg.getBytes());
            baos.write(sd.getLength());
            baos.write(sd.getBytes());
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] install_make_selectable(AID pkg, AID instance) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(pkg.getLength());
            baos.write(pkg.getBytes());
            baos.write(instance.getLength());
            baos.write(instance.getBytes());
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] extradite(AID from, AID what, AID to) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(from.getLength());
            baos.write(from.getBytes());
            baos.write(what.getLength());
            baos.write(what.getBytes());
            baos.write(to.getLength());
            baos.write(to.getBytes());
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] delete(AID what) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(what.getLength());
            baos.write(what.getBytes());
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class ReceiptVerificationException
    extends RuntimeException {
        private static final long serialVersionUID = -453299698747234135L;

        public ReceiptVerificationException(String message) {
            super(message);
        }
    }

    public static class NullVerifier
    extends ReceiptVerifier {
        @Override
        boolean check(ResponseAPDU response, byte[] context) {
            return true;
        }
    }

    public static class AESReceiptVerifier
    extends ReceiptVerifier {
        private final byte[] aes_key;

        public AESReceiptVerifier(byte[] aesKey) {
            this.aes_key = (byte[])aesKey.clone();
        }

        public AESReceiptVerifier(byte[] aesKey, boolean log_only) {
            this.aes_key = (byte[])aesKey.clone();
            this.log_only = log_only;
        }

        @Override
        boolean check(ResponseAPDU response, byte[] context) throws ReceiptVerificationException {
            byte[] data = response.getData();
            if (data[0] == 0) {
                log.debug("No receipt");
                return true;
            }
            try {
                GPUtils.trace_lv(Arrays.copyOfRange(data, 1, (int)data[0]), log);
            }
            catch (Exception e) {
                log.error("Invalid LV in response: {}", (Object)HexUtils.bin2hex((byte[])data));
            }
            byte[] card = AESReceiptVerifier.get_receipt(data);
            byte[] confdata = AESReceiptVerifier.get_confirmation_data(data);
            byte[] my = GPCrypto.aes_cmac(this.aes_key, GPUtils.concatenate(confdata, context), 128);
            boolean verified = Arrays.equals(my, card);
            if (!verified) {
                log.error("Receipt verification failed");
                if (!this.log_only) {
                    throw new ReceiptVerificationException("Receipt verification failed");
                }
            } else {
                log.info("Receipt verified successfully");
            }
            return verified;
        }
    }
}

