/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp.keys;

import apdu4j.core.HexUtils;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPKeyInfo;
import pro.javacard.gp.GPSecureChannelVersion;
import pro.javacard.gp.GPUtils;

public class PlaintextKeys
extends GPCardKeys {
    private static final Logger logger = LoggerFactory.getLogger(PlaintextKeys.class);
    private static final byte[] defaultKeyBytes = HexUtils.hex2bin((String)"404142434445464748494A4B4C4D4E4F");
    public static final Map<GPCardKeys.KeyPurpose, byte[]> SCP02_CONSTANTS;
    public static final Map<GPCardKeys.KeyPurpose, Byte> SCP03_CONSTANTS;
    public static final Map<String, String> kdf_templates;
    private String kdf_template;
    private int version = 0;
    private byte[] masterKey;
    private HashMap<GPCardKeys.KeyPurpose, byte[]> cardKeys = new HashMap();

    public static byte[] DEFAULT_KEY() {
        return (byte[])defaultKeyBytes.clone();
    }

    public String getTemplate() {
        return this.kdf_template;
    }

    private PlaintextKeys(byte[] master, String d) {
        this(master, master, master, d);
        this.masterKey = (byte[])master.clone();
    }

    private PlaintextKeys(byte[] enc, byte[] mac, byte[] dek, String d) {
        this.cardKeys.put(GPCardKeys.KeyPurpose.ENC, (byte[])enc.clone());
        this.cardKeys.put(GPCardKeys.KeyPurpose.MAC, (byte[])mac.clone());
        this.cardKeys.put(GPCardKeys.KeyPurpose.DEK, (byte[])dek.clone());
        this.kdf_template = d;
    }

    public static Optional<PlaintextKeys> fromEnvironment() {
        return PlaintextKeys.fromEnvironment(System.getenv(), "GP_KEY");
    }

    static byte[] validateKey(byte[] k) {
        if (k.length != 16 && k.length != 24 && k.length != 32) {
            throw new IllegalArgumentException(String.format("Invalid key length %d: %s", k.length, HexUtils.bin2hex((byte[])k)));
        }
        return k;
    }

    public static Optional<PlaintextKeys> fromBytes(byte[] enc, byte[] mac, byte[] dek, byte[] mk, String kdf, byte[] kdd, int ver) {
        if (!(enc == null && mac == null && dek == null || enc != null && mac != null && dek != null && mk == null)) {
            throw new IllegalArgumentException("Either all or nothing of enc/mac/dek keys must be set, and no mk at the same time!");
        }
        if (enc != null && mac != null && dek != null) {
            logger.trace("Using three individual keys");
            byte[] encbytes = PlaintextKeys.validateKey(enc);
            byte[] macbytes = PlaintextKeys.validateKey(mac);
            byte[] dekbytes = PlaintextKeys.validateKey(dek);
            PlaintextKeys keys = PlaintextKeys.fromKeys(encbytes, macbytes, dekbytes);
            if (ver != 0) {
                keys.setVersion(ver);
            }
            if (kdf != null) {
                logger.warn("Different keys and using derivation, is this right?");
                keys.setDiversifier(kdf);
            }
            return Optional.of(keys);
        }
        if (mk != null) {
            logger.trace("Using a master key");
            byte[] master = PlaintextKeys.validateKey(mk);
            PlaintextKeys keys = PlaintextKeys.fromMasterKey(master);
            if (kdf != null) {
                keys.setDiversifier(kdf);
            } else {
                logger.warn("Using master key without derivation, is this right?");
            }
            if (kdd != null) {
                keys.kdd = (byte[])kdd.clone();
            }
            if (ver != 0) {
                keys.setVersion(ver);
            }
            return Optional.of(keys);
        }
        return Optional.empty();
    }

    public static Optional<PlaintextKeys> fromStrings(String enc, String mac, String dek, String mk, String div, String kdd, String ver) {
        if (!(enc == null && mac == null && dek == null || enc != null && mac != null && dek != null && mk == null)) {
            throw new IllegalArgumentException("Either all or nothing of enc/mac/dek keys must be set, and no mk at the same time!");
        }
        if (enc != null && mac != null && dek != null) {
            logger.trace("Using three individual keys");
            byte[] encbytes = PlaintextKeys.validateKey(HexUtils.stringToBin((String)enc));
            byte[] macbytes = PlaintextKeys.validateKey(HexUtils.stringToBin((String)mac));
            byte[] dekbytes = PlaintextKeys.validateKey(HexUtils.stringToBin((String)dek));
            PlaintextKeys keys = PlaintextKeys.fromKeys(encbytes, macbytes, dekbytes);
            if (ver != null) {
                keys.setVersion(GPUtils.intValue(ver));
            }
            if (div != null) {
                String kdf = kdf_templates.getOrDefault(div, div);
                logger.warn("Different keys and using derivation, is this right?");
                keys.setDiversifier(kdf);
            }
            return Optional.of(keys);
        }
        if (mk != null) {
            logger.trace("Using a master key");
            byte[] master = PlaintextKeys.validateKey(HexUtils.stringToBin((String)mk));
            PlaintextKeys keys = PlaintextKeys.fromMasterKey(master);
            if (div != null) {
                keys.setDiversifier(div);
            } else {
                logger.warn("Using master key without derivation, is this right?");
            }
            if (kdd != null) {
                keys.kdd = HexUtils.stringToBin((String)kdd);
            }
            if (ver != null) {
                keys.setVersion(GPUtils.intValue(ver));
            }
            return Optional.of(keys);
        }
        return Optional.empty();
    }

    public static Optional<PlaintextKeys> fromEnvironment(Map<String, String> env, String prefix) {
        String ver;
        String kdd;
        Optional<PlaintextKeys> r;
        String enc = env.get(prefix + "_ENC");
        String mac = env.get(prefix + "_MAC");
        String dek = env.get(prefix + "_DEK");
        String mk = env.get(prefix);
        String div = env.get(prefix + "_KDF");
        if (div != null) {
            div = kdf_templates.getOrDefault(div, div);
        }
        if ((r = PlaintextKeys.fromStrings(enc, mac, dek, mk, div, kdd = env.get(prefix + "_KDD"), ver = env.get(prefix + "_VER"))).isPresent()) {
            logger.debug("Got keys from environment, prefix=" + prefix);
        }
        return r;
    }

    public static PlaintextKeys fromMasterKey(byte[] master) {
        return new PlaintextKeys(master, null);
    }

    public static PlaintextKeys fromMasterKey(byte[] master, String kdf) {
        return new PlaintextKeys(master, kdf);
    }

    public static PlaintextKeys defaultKey() {
        return new PlaintextKeys(defaultKeyBytes, null);
    }

    public static PlaintextKeys fromKeys(byte[] enc, byte[] mac, byte[] dek) {
        return new PlaintextKeys(enc, mac, dek, null);
    }

    byte[] diversify(byte[] k, GPCardKeys.KeyPurpose usage, byte[] kdd, String kdf) throws GPException {
        String template = PlaintextKeys.kdf_template_expand(kdf, kdd, usage.getValue());
        try {
            if (this.scp == GPSecureChannelVersion.SCP.SCP03) {
                template = PlaintextKeys.kdf_template_bitlength(template, k.length * 8);
                byte[] a = PlaintextKeys.kdf_template_finalize(PlaintextKeys.kdf_template_blocka(template));
                byte[] b = PlaintextKeys.kdf_template_finalize(PlaintextKeys.kdf_template_blockb(template));
                return GPCrypto.scp03_kdf(k, a, b, k.length);
            }
            byte[] kv = PlaintextKeys.kdf_template_finalize(template);
            return GPCrypto.des3_ecb(kv, k);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("KDF failed", e);
        }
    }

    public Optional<byte[]> getMasterKey() {
        return Optional.ofNullable(this.masterKey);
    }

    @Override
    public GPKeyInfo getKeyInfo() {
        byte[] aKey = this.cardKeys.get((Object)GPCardKeys.KeyPurpose.ENC);
        GPKeyInfo.GPKey type = aKey.length > 16 || this.scp == GPSecureChannelVersion.SCP.SCP03 ? GPKeyInfo.GPKey.AES : GPKeyInfo.GPKey.DES3;
        return new GPKeyInfo(this.version, 1, aKey.length, type);
    }

    @Override
    public byte[] encrypt(byte[] data, byte[] sessionContext) throws GeneralSecurityException {
        if (this.scp == GPSecureChannelVersion.SCP.SCP02) {
            byte[] sdek = this.deriveSessionKeySCP02(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), GPCardKeys.KeyPurpose.DEK, sessionContext);
            return GPCrypto.des3_ecb(data, sdek);
        }
        if (this.scp == GPSecureChannelVersion.SCP.SCP01) {
            return GPCrypto.des3_ecb(data, this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK));
        }
        if (this.scp == GPSecureChannelVersion.SCP.SCP03) {
            return GPCrypto.aes_cbc(data, this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), new byte[16]);
        }
        throw new IllegalStateException("Unknown SCP version");
    }

    @Override
    public byte[] encryptKey(GPCardKeys key, GPCardKeys.KeyPurpose p, byte[] sessionContext) throws GeneralSecurityException {
        if (!(key instanceof PlaintextKeys)) {
            throw new IllegalArgumentException(this.getClass().getName() + " can only handle " + this.getClass().getName());
        }
        PlaintextKeys other = (PlaintextKeys)key;
        switch (this.scp) {
            case SCP01: {
                logger.debug("Encrypting {} value (KCV={}) with DEK (KCV={})", new Object[]{p, HexUtils.bin2hex((byte[])other.kcv(p)), HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.DEK))});
                return GPCrypto.des3_ecb(other.cardKeys.get((Object)p), this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK));
            }
            case SCP02: {
                byte[] sdek = this.deriveSessionKeySCP02(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), GPCardKeys.KeyPurpose.DEK, sessionContext);
                logger.debug("Encrypting {} value (KCV={}) with S-DEK (KCV={})", new Object[]{p, HexUtils.bin2hex((byte[])other.kcv(p)), HexUtils.bin2hex((byte[])GPCrypto.kcv_3des(sdek))});
                return GPCrypto.des3_ecb(other.cardKeys.get((Object)p), sdek);
            }
            case SCP03: {
                logger.debug("Encrypting {} value (KCV={}) with DEK (KCV={})", new Object[]{p, HexUtils.bin2hex((byte[])other.kcv(p)), HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.DEK))});
                byte[] otherkey = other.cardKeys.get((Object)p);
                int n = otherkey.length % 16 + 1;
                byte[] plaintext = GPCrypto.random(n * otherkey.length);
                System.arraycopy(otherkey, 0, plaintext, 0, otherkey.length);
                return GPCrypto.aes_cbc(plaintext, this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK), new byte[16]);
            }
        }
        throw new GPException("Illegal SCP");
    }

    @Override
    public byte[] getSessionKey(GPCardKeys.KeyPurpose p, byte[] session_kdd) {
        switch (this.scp) {
            case SCP01: {
                return this.deriveSessionKeySCP01(this.cardKeys.get((Object)p), p, session_kdd);
            }
            case SCP02: {
                if (p == GPCardKeys.KeyPurpose.RMAC) {
                    return this.deriveSessionKeySCP02(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.MAC), GPCardKeys.KeyPurpose.RMAC, session_kdd);
                }
                return this.deriveSessionKeySCP02(this.cardKeys.get((Object)p), p, session_kdd);
            }
            case SCP03: {
                if (p == GPCardKeys.KeyPurpose.RMAC) {
                    return this.deriveSessionKeySCP03(this.cardKeys.get((Object)GPCardKeys.KeyPurpose.MAC), GPCardKeys.KeyPurpose.RMAC, session_kdd);
                }
                return this.deriveSessionKeySCP03(this.cardKeys.get((Object)p), p, session_kdd);
            }
        }
        throw new IllegalStateException("Unknown SCP");
    }

    @Override
    public byte[] kcv(GPCardKeys.KeyPurpose p) {
        byte[] k = this.cardKeys.get((Object)p);
        if (this.scp == GPSecureChannelVersion.SCP.SCP03) {
            return GPCrypto.kcv_aes(k);
        }
        if (this.scp == GPSecureChannelVersion.SCP.SCP01 || this.scp == GPSecureChannelVersion.SCP.SCP02) {
            return GPCrypto.kcv_3des(k);
        }
        if (k.length == 16) {
            logger.warn("Don't know how to calculate KCV, defaulting to SCP02");
            return GPCrypto.kcv_3des(k);
        }
        logger.warn("Don't know how to calculate KCV, defaulting to SCP03");
        return GPCrypto.kcv_aes(k);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    private byte[] deriveSessionKeySCP01(byte[] cardKey, GPCardKeys.KeyPurpose p, byte[] kdd) {
        if (p == GPCardKeys.KeyPurpose.DEK) {
            return cardKey;
        }
        if (p == GPCardKeys.KeyPurpose.RMAC) {
            return null;
        }
        byte[] derivationData = new byte[16];
        System.arraycopy(kdd, 12, derivationData, 0, 4);
        System.arraycopy(kdd, 0, derivationData, 4, 4);
        System.arraycopy(kdd, 8, derivationData, 8, 4);
        System.arraycopy(kdd, 4, derivationData, 12, 4);
        try {
            return GPCrypto.des3_ecb(derivationData, cardKey);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("Can not calculate session keys", e);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Session key calculation failed", e);
        }
    }

    private byte[] deriveSessionKeySCP02(byte[] cardKey, GPCardKeys.KeyPurpose p, byte[] sequence) {
        try {
            byte[] derivationData = new byte[16];
            System.arraycopy(SCP02_CONSTANTS.get((Object)p), 0, derivationData, 0, 2);
            System.arraycopy(sequence, 0, derivationData, 2, 2);
            return GPCrypto.des3_cbc(derivationData, cardKey, new byte[8]);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Session keys calculation failed.", e);
        }
    }

    private byte[] deriveSessionKeySCP03(byte[] cardKey, GPCardKeys.KeyPurpose p, byte[] kdd) {
        if (p == GPCardKeys.KeyPurpose.DEK) {
            return cardKey;
        }
        return GPCrypto.scp03_kdf(cardKey, SCP03_CONSTANTS.get((Object)p), kdd, cardKey.length * 8);
    }

    @Override
    public PlaintextKeys diversify(GPSecureChannelVersion.SCP scp, byte[] kdd) {
        super.diversify(scp, kdd);
        if (this.kdf_template == null) {
            return this;
        }
        logger.debug("KDF: applying '{}' to {} KDD {}", new Object[]{this.kdf_template, scp, HexUtils.bin2hex((byte[])kdd)});
        for (Map.Entry<GPCardKeys.KeyPurpose, byte[]> e : this.cardKeys.entrySet()) {
            this.cardKeys.put(e.getKey(), this.diversify(e.getValue(), e.getKey(), kdd, this.kdf_template));
        }
        return this;
    }

    @Override
    public String toString() {
        String enc = HexUtils.bin2hex((byte[])this.cardKeys.get((Object)GPCardKeys.KeyPurpose.ENC));
        String enc_kcv = HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.ENC));
        String mac = HexUtils.bin2hex((byte[])this.cardKeys.get((Object)GPCardKeys.KeyPurpose.MAC));
        String mac_kcv = HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.MAC));
        String dek = HexUtils.bin2hex((byte[])this.cardKeys.get((Object)GPCardKeys.KeyPurpose.DEK));
        String dek_kcv = HexUtils.bin2hex((byte[])this.kcv(GPCardKeys.KeyPurpose.DEK));
        return String.format("ENC=%s (KCV: %s) MAC=%s (KCV: %s) DEK=%s (KCV: %s) for %s", new Object[]{enc, enc_kcv, mac, mac_kcv, dek, dek_kcv, this.scp});
    }

    public void setDiversifier(String template) {
        if (this.kdf_template != null) {
            throw new IllegalStateException("KDF already set");
        }
        this.kdf_template = template;
    }

    @Override
    public byte[] scp3_kdf(GPCardKeys.KeyPurpose purpose, byte[] a, byte[] b, int bytes) {
        return GPCrypto.scp03_kdf(this.cardKeys.get((Object)purpose), a, b, bytes);
    }

    static String kdf_template_expand(String template, byte[] kdd, byte keytype) {
        template = template.toLowerCase(Locale.ENGLISH);
        template = template.replace(" ", "");
        template = template.replace("0x", "");
        for (int i = 0; i < kdd.length; ++i) {
            template = template.replace(String.format("$%x", i), String.format("%02x", kdd[i]));
        }
        template = template.replace("$k", String.format("%02x", keytype));
        return template;
    }

    static String kdf_template_bitlength(String template, int bits) {
        return template.replace("$l$l", String.format("%04x", bits));
    }

    static String kdf_template_blocka(String template) {
        int pos = template.indexOf("$_");
        if (pos == -1) {
            throw new IllegalArgumentException("Invalid template (missing '$_'): " + template);
        }
        return template.substring(0, pos);
    }

    static String kdf_template_blockb(String template) {
        int pos = template.indexOf("$_");
        if (pos == -1) {
            throw new IllegalArgumentException("Invalid template (missing '$_'): " + template);
        }
        return template.substring(pos + 2);
    }

    static byte[] kdf_template_finalize(String template) throws IllegalArgumentException {
        if (template.contains("$")) {
            throw new IllegalArgumentException("Invalid template (still includes '$'): " + template);
        }
        return HexUtils.hex2bin((String)template);
    }

    static {
        HashMap<GPCardKeys.KeyPurpose, byte[]> scp2 = new HashMap<GPCardKeys.KeyPurpose, byte[]>();
        scp2.put(GPCardKeys.KeyPurpose.MAC, new byte[]{1, 1});
        scp2.put(GPCardKeys.KeyPurpose.RMAC, new byte[]{1, 2});
        scp2.put(GPCardKeys.KeyPurpose.DEK, new byte[]{1, -127});
        scp2.put(GPCardKeys.KeyPurpose.ENC, new byte[]{1, -126});
        SCP02_CONSTANTS = Collections.unmodifiableMap(scp2);
        HashMap<GPCardKeys.KeyPurpose, Byte> scp3 = new HashMap<GPCardKeys.KeyPurpose, Byte>();
        scp3.put(GPCardKeys.KeyPurpose.ENC, (byte)4);
        scp3.put(GPCardKeys.KeyPurpose.MAC, (byte)6);
        scp3.put(GPCardKeys.KeyPurpose.RMAC, (byte)7);
        SCP03_CONSTANTS = Collections.unmodifiableMap(scp3);
        HashMap<String, String> kdfs = new HashMap<String, String>();
        kdfs.put("emv", "$4 $5 $6 $7 $8 $9 0xF0 $k $4 $5 $6 $7 $8 $9 0x0F $k");
        kdfs.put("visa2", "$0 $1 $4 $5 $6 $7 0xF0 $k $0 $1 $4 $5 $6 $7 0x0F $k");
        kdfs.put("visa", "$0 $1 $2 $3 $8 $9 0xF0 $k $0 $1 $2 $3 $8 $9 0x0F $k");
        kdfs.put("kdf3", "$_ 0x00 0x00 0x00 $k 0x00 $0 $1 $2 $3 $4 $5 $6 $7 $8 $9");
        kdf_templates = Collections.unmodifiableMap(kdfs);
    }
}

