/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp;

import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pro.javacard.capfile.AID;
import pro.javacard.capfile.CAPFile;
import pro.javacard.capfile.WellKnownAID;
import pro.javacard.gp.GPData;
import pro.javacard.gp.GPException;
import pro.javacard.gp.GPRegistry;
import pro.javacard.gp.GPRegistryEntry;
import pro.javacard.gp.GPSession;
import pro.javacard.gp.GPUtils;

public class GPCommands {
    private GPCommands() {
    }

    private static void storeDGI(GPSession gp, byte[] payload) throws GPException, IOException {
        CommandAPDU cmd = new CommandAPDU(-128, -30, 128, 0, payload);
        ResponseAPDU response = gp.transmit(cmd);
        GPException.check(response, "STORE DATA failed", new int[0]);
    }

    public static void setPrePerso(GPSession gp, byte[] data) throws GPException, IOException {
        if (data == null || data.length != 8) {
            throw new IllegalArgumentException("PrePerso data must be 8 bytes");
        }
        byte[] payload = GPUtils.concatenate({-97, 103, (byte)data.length}, data);
        GPCommands.storeDGI(gp, payload);
    }

    public static void setPerso(GPSession gp, byte[] data) throws GPException, IOException {
        if (data == null || data.length != 8) {
            throw new IllegalArgumentException("Perso data must be 8 bytes");
        }
        byte[] payload = GPUtils.concatenate({-97, 102, (byte)data.length}, data);
        GPCommands.storeDGI(gp, payload);
    }

    public static void listRegistry(GPRegistry reg, PrintStream out, boolean verbose) {
        String tab = "     ";
        for (GPRegistryEntry e : reg) {
            AID aid = e.getAID();
            out.print(String.valueOf((Object)e.getType()) + ": " + HexUtils.bin2hex((byte[])aid.getBytes()) + " (" + e.getLifeCycleString() + ")");
            if (e.getType() != GPRegistryEntry.Kind.ISD && verbose) {
                out.println(" (" + WellKnownAID.getName((AID)aid).orElse(GPUtils.bin2readable(aid.getBytes())) + ")");
            } else {
                out.println();
            }
            if (e.getDomain().isPresent()) {
                out.println(tab + "Parent:   " + String.valueOf(e.getDomain().get()));
            }
            if (e.getType() == GPRegistryEntry.Kind.PKG) {
                if (e.getVersion() != null) {
                    out.println(tab + "Version:  " + e.getVersionString());
                }
                for (AID a : e.getModules()) {
                    out.print(tab + "Applet:   " + HexUtils.bin2hex((byte[])a.getBytes()));
                    if (verbose) {
                        out.println(" (" + WellKnownAID.getName((AID)a).orElse(GPUtils.bin2readable(a.getBytes())) + ")");
                        continue;
                    }
                    out.println();
                }
            } else {
                if (e.getSource().isPresent()) {
                    out.println(tab + "From:     " + String.valueOf(e.getSource().get()));
                }
                Optional<String> implicit = GPCommands.getImplicitString(e);
                implicit.ifPresent(s -> out.println(tab + "Selected: " + s));
                if (!e.getPrivileges().isEmpty()) {
                    out.println(tab + "Privs:    " + e.getPrivileges().stream().map(Enum::toString).collect(Collectors.joining(", ")));
                }
            }
            out.println();
        }
    }

    static Optional<String> getImplicitString(GPRegistryEntry entry) {
        Optional contactless = entry.getImplicitlySelectedContactless().isEmpty() ? Optional.empty() : Optional.of(String.format("Contactless(%s)", entry.getImplicitlySelectedContactless().stream().map(Object::toString).collect(Collectors.joining(","))));
        Optional contact = entry.getImplicitlySelectedContact().isEmpty() ? Optional.empty() : Optional.of(String.format("Contact(%s)", entry.getImplicitlySelectedContact().stream().map(Object::toString).collect(Collectors.joining(","))));
        return Stream.of(contactless, contact).filter(Optional::isPresent).map(Optional::get).reduce((a, b) -> a + ", " + b);
    }

    public static void load(GPSession gp, CAPFile cap, AID to, AID dapAID, GPData.LFDBH hash) throws GPException, IOException {
        GPRegistryEntry dapTarget;
        boolean dapRequired;
        AID targetAID;
        GPRegistry reg = gp.getRegistry();
        GPRegistryEntry targetDomain = reg.getDomain(targetAID = Optional.ofNullable(to).orElse(gp.getAID())).orElseThrow(() -> new IllegalArgumentException("Target domain does not exist: " + String.valueOf(targetAID)));
        boolean bl = dapRequired = targetDomain.hasPrivilege(GPRegistryEntry.Privilege.DAPVerification) || reg.allDomains().stream().anyMatch(e -> e.hasPrivilege(GPRegistryEntry.Privilege.MandatedDAPVerification));
        if (dapAID != null && !(dapTarget = reg.getDomain(targetAID).orElseThrow(() -> new IllegalArgumentException("DAP domain does not exist: " + String.valueOf(dapAID)))).hasPrivilege(GPRegistryEntry.Privilege.DAPVerification) && !dapTarget.hasPrivilege(GPRegistryEntry.Privilege.MandatedDAPVerification)) {
            throw new IllegalArgumentException("Specified DAP domain does not have (Mandated)DAPVerification privilege: " + String.valueOf(dapAID));
        }
        GPData.LFDBH lfdbh = targetDomain.hasPrivilege(GPRegistryEntry.Privilege.DelegatedManagement) || dapRequired || hash != null ? Optional.ofNullable(hash).orElse(GPData.LFDBH.SHA1) : null;
        if (dapRequired) {
            throw new IllegalArgumentException("Broken code, see #304");
        }
        byte[] dap = null;
        gp.loadCapFile(cap, targetAID, Optional.ofNullable(dapAID).orElse(targetAID), dap, lfdbh);
    }
}

