/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gptool;

import apdu4j.core.HexUtils;
import com.google.auto.service.AutoService;
import java.util.Map;
import java.util.Optional;
import pro.javacard.gp.CardKeysProvider;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.keys.PlaintextKeys;

@AutoService(value={CardKeysProvider.class})
public class PlaintextKeysProvider
implements CardKeysProvider {
    public Optional<GPCardKeys> getCardKeys(String spec) {
        if (spec == null) {
            return Optional.empty();
        }
        spec = spec.trim();
        try {
            for (Map.Entry d : PlaintextKeys.kdf_templates.entrySet()) {
                if (!spec.toLowerCase().startsWith((String)d.getKey())) continue;
                byte[] k = PlaintextKeysProvider.hexOrDefault(spec.substring(((String)d.getKey()).length() + 1));
                return Optional.of(PlaintextKeys.fromMasterKey((byte[])k, (String)((String)d.getValue())));
            }
            byte[] k = PlaintextKeysProvider.hexOrDefault(spec);
            return Optional.of(PlaintextKeys.fromMasterKey((byte[])k));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Optional.empty();
        }
    }

    static byte[] hexOrDefault(String v) {
        if ("default".startsWith(v.toLowerCase())) {
            return PlaintextKeys.DEFAULT_KEY();
        }
        return HexUtils.stringToBin((String)v);
    }
}

