/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.tool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.tool.InstallableAppletChecker;

class AppletClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(AppletClassLoader.class);

    AppletClassLoader() {
        super(new URL[0], AppletClassLoader.class.getClassLoader());
    }

    List<String> addApplet(Path file) throws IOException {
        Path tmp;
        block8: {
            if (Files.isDirectory(file, new LinkOption[0])) {
                this.addURL(file.toUri().toURL());
                return AppletClassLoader.locateApplets(file, this);
            }
            tmp = Files.createTempDirectory("applet", new FileAttribute[0]);
            String name = file.getFileName().toString().toLowerCase();
            try (FileSystem fs = FileSystems.newFileSystem(file, (ClassLoader)null);){
                Path src;
                Path path = src = name.endsWith(".cap") ? fs.getPath("APPLET-INF", "classes") : fs.getPath("/", new String[0]);
                if (Files.exists(src, new LinkOption[0])) {
                    Files.walk(src, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".class")).forEach(p -> this.copy((Path)p, tmp.resolve(src.relativize((Path)p).toString())));
                    break block8;
                }
                throw new FileNotFoundException("APPLET-INF/classes is missing from " + String.valueOf(file.getFileName()));
            }
        }
        this.addURL(tmp.toUri().toURL());
        log.trace("adding {}", (Object)tmp);
        return AppletClassLoader.locateApplets(tmp, this);
    }

    private void copy(Path from, Path to) {
        try {
            Files.createDirectories(to.getParent(), new FileAttribute[0]);
            Files.copy(from, to, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static List<String> locateApplets(Path src, URLClassLoader cl) throws IOException {
        ArrayList<String> applets = new ArrayList<String>();
        Files.walk(src, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".class")).forEach(p -> {
            if (InstallableAppletChecker.isValidApplet(p, cl)) {
                String cls = src.relativize((Path)p).toString().replace("/", ".");
                applets.add(cls.substring(0, cls.length() - 6));
            }
        });
        return applets;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        log.trace("loadClass {}", (Object)name);
        return super.loadClass(name);
    }
}

