/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.tool;

import com.licel.jcardsim.base.InstallSpec;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javacard.framework.Applet;
import javacard.framework.SystemException;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bouncycastle.util.encoders.Hex;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.NonBlockingReader;
import pro.javacard.capfile.AID;
import pro.javacard.capfile.CAPFile;
import pro.javacard.engine.JavaCardEngine;
import pro.javacard.engine.adapters.AbstractTCPAdapter;
import pro.javacard.engine.adapters.JCSDKClient;
import pro.javacard.engine.adapters.JCSDKServer;
import pro.javacard.engine.adapters.VSmartCardClient;
import pro.javacard.engine.tool.AppletClassLoader;

public class JCardTool {
    static OptionParser parser = new OptionParser();
    static OptionSpec<Void> OPT_HELP = parser.acceptsAll(Arrays.asList("h", "help"), "Show this help").forHelp();
    static OptionSpec<Void> OPT_VERSION = parser.acceptsAll(Arrays.asList("V", "version"), "Show version");
    static OptionSpec<Void> OPT_CONTROL = parser.acceptsAll(Arrays.asList("c", "control"), "Start control interface");
    static OptionSpec<Void> OPT_VSMARTCARD = parser.accepts("vsmartcard", "Run a VSmartCard client");
    static OptionSpec<Integer> OPT_VSMARTCARD_PORT = parser.accepts("vsmartcard-port", "VSmartCard port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)35963, (Object[])new Integer[0]);
    static OptionSpec<String> OPT_VSMARTCARD_HOST = parser.accepts("vsmartcard-host", "VSmartCard host").withRequiredArg().ofType(String.class).defaultsTo((Object)"127.0.0.1", (Object[])new String[0]);
    static OptionSpec<String> OPT_VSMARTCARD_ATR = parser.accepts("vsmartcard-atr", "VSmartCard ATR").withRequiredArg().ofType(String.class).defaultsTo((Object)"3B80800101", (Object[])new String[0]);
    static OptionSpec<String> OPT_VSMARTCARD_PROTOCOL = parser.accepts("vsmartcard-protocol", "VSmartCard protocol").withRequiredArg().ofType(String.class).defaultsTo((Object)"*", (Object[])new String[0]);
    static OptionSpec<Void> OPT_JCSDK = parser.accepts("jcsdk", "Run a JCSDK server");
    static OptionSpec<Integer> OPT_JCSDK_PORT = parser.accepts("jcsdk-port", "JCSDK port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)9025, (Object[])new Integer[0]);
    static OptionSpec<String> OPT_JCSDK_HOST = parser.accepts("jcsdk-host", "JCSDK host").withRequiredArg().ofType(String.class).defaultsTo((Object)"0.0.0.0", (Object[])new String[0]);
    static OptionSpec<String> OPT_JCSDK_ATR = parser.accepts("jcsdk-atr", "JCSDK ATR").withRequiredArg().ofType(String.class).defaultsTo((Object)"3B80800101", (Object[])new String[0]);
    static OptionSpec<String> OPT_JCSDK_PROTOCOL = parser.accepts("jcsdk-protocol", "JCSDK protocol").withRequiredArg().ofType(String.class).defaultsTo((Object)"*", (Object[])new String[0]);
    static OptionSpec<String> OPT_PASSTHROUGH_HOST = parser.accepts("passthrough-host", "JCSDK simulator host").withRequiredArg().ofType(String.class);
    static OptionSpec<String> OPT_ATR = parser.accepts("atr", "ATR to use (hex)").withRequiredArg().ofType(String.class).defaultsTo((Object)"3B80800101", (Object[])new String[0]);
    static OptionSpec<String> OPT_PROTOCOL = parser.accepts("protocol", "Protocol to use").withRequiredArg().ofType(String.class).defaultsTo((Object)"T=1", (Object[])new String[0]);
    static OptionSpec<File> toLoad = parser.nonOptions("path to .cap or .jar or classes directory").ofType(File.class);
    static OptionSpec<String> OPT_APPLET = parser.accepts("applet", "Applet class to install").withRequiredArg().ofType(String.class);
    static OptionSpec<String> OPT_PARAMS = parser.accepts("params", "Installation parameters").withRequiredArg().ofType(String.class);
    static OptionSpec<String> OPT_AID = parser.accepts("aid", "Applet AID").withRequiredArg().ofType(String.class);
    static final AppletClassLoader loader = new AppletClassLoader();

    static AbstractTCPAdapter configureVSmartCard(AbstractTCPAdapter adapter, OptionSet options) {
        adapter = adapter.withHost((String)options.valueOf(OPT_VSMARTCARD_HOST));
        adapter = adapter.withPort(((Integer)options.valueOf(OPT_VSMARTCARD_PORT)).intValue());
        if (options.has(OPT_ATR)) {
            adapter = adapter.withATR(Hex.decode((String)((String)options.valueOf(OPT_ATR))));
        }
        if (options.has(OPT_VSMARTCARD_ATR)) {
            adapter = adapter.withATR(Hex.decode((String)((String)options.valueOf(OPT_VSMARTCARD_ATR))));
        }
        return adapter;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        String version = JCardTool.class.getPackage().getImplementationVersion();
        try {
            OptionSet options = parser.parse(args);
            if (options.has(OPT_VERSION)) {
                System.out.println("JCardEngine v" + version);
                return;
            }
            if (options.has(OPT_HELP) || args.length == 0) {
                parser.printHelpOn((OutputStream)System.out);
                return;
            }
            if (options.nonOptionArguments().isEmpty() && !options.has(OPT_PASSTHROUGH_HOST)) {
                System.err.println("Missing applets. Check --help");
                System.exit(2);
            }
            ExecutorService exec = Executors.newFixedThreadPool(3);
            ArrayList<Object> adapters = new ArrayList<Object>();
            if (options.has(OPT_PASSTHROUGH_HOST)) {
                JCSDKClient upstream = new JCSDKClient((String)options.valueOf(OPT_PASSTHROUGH_HOST), ((Integer)options.valueOf(OPT_JCSDK_PORT)).intValue());
                VSmartCardClient adapter = new VSmartCardClient((Supplier)upstream);
                adapter = JCardTool.configureVSmartCard((AbstractTCPAdapter)adapter, options);
                adapters.add(adapter);
            } else {
                String protocol;
                TreeSet<String> availableApplets = new TreeSet<String>();
                HashMap<String, byte[]> defaultAID = new HashMap<String, byte[]>();
                JavaCardEngine sim = JavaCardEngine.create().withClassLoader((ClassLoader)loader);
                for (File f : options.valuesOf(toLoad)) {
                    Path path = f.toPath();
                    if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".cap")) {
                        CAPFile cap = CAPFile.fromFile((Path)path);
                        for (Map.Entry app : cap.getApplets().entrySet()) {
                            defaultAID.put((String)app.getValue(), ((AID)app.getKey()).getBytes());
                        }
                    }
                    availableApplets.addAll(loader.addApplet(path));
                }
                ArrayList<InstallSpec> spec = new ArrayList<InstallSpec>();
                if (availableApplets.isEmpty()) {
                    System.err.println("No applets found");
                    System.exit(1);
                } else if (options.has(OPT_APPLET)) {
                    void var10_18;
                    Class<? extends Applet> applet = JCardTool.requireExtendsApplet(loader.loadClass((String)options.valueOf(OPT_APPLET)));
                    if (!options.has(OPT_AID) && defaultAID.containsKey(options.valueOf(OPT_APPLET))) {
                        byte[] byArray = (byte[])defaultAID.get(options.valueOf(OPT_APPLET));
                    } else {
                        byte[] byArray = Hex.decode((String)((String)options.valueOf(OPT_AID)));
                    }
                    byte[] params = options.has(OPT_PARAMS) ? Hex.decode((String)((String)options.valueOf(OPT_PARAMS))) : null;
                    spec.add(InstallSpec.of((byte[])var10_18, applet, (byte[])params));
                } else if (availableApplets.size() == 1) {
                    Iterator klass = (String)availableApplets.iterator().next();
                    Class<? extends Applet> clazz = JCardTool.requireExtendsApplet(loader.loadClass((String)((Object)klass)));
                    byte[] aid = !options.has(OPT_AID) && defaultAID.containsKey(klass) ? (byte[])defaultAID.get(klass) : Hex.decode((String)((String)options.valueOf(OPT_AID)));
                    byte[] params = options.has(OPT_PARAMS) ? Hex.decode((String)((String)options.valueOf(OPT_PARAMS))) : null;
                    spec.add(InstallSpec.of((byte[])aid, clazz, (byte[])params));
                } else {
                    System.err.println("Multiple applets found, use --applet");
                    for (String string : availableApplets) {
                        System.err.println("- " + string);
                    }
                    System.exit(1);
                }
                for (InstallSpec installSpec : spec) {
                    sim.installApplet(installSpec.getAID(), installSpec.getAppletClass(), installSpec.getParamters());
                }
                if (options.has(OPT_VSMARTCARD) || options.has(OPT_VSMARTCARD_PORT) || options.has(OPT_VSMARTCARD_HOST) || options.has(OPT_VSMARTCARD_PROTOCOL) || options.has(OPT_VSMARTCARD_ATR)) {
                    protocol = options.has(OPT_VSMARTCARD_PROTOCOL) ? (String)options.valueOf(OPT_VSMARTCARD_PROTOCOL) : (String)options.valueOf(OPT_PROTOCOL);
                    VSmartCardClient vSmartCardClient = new VSmartCardClient(() -> sim.connectFor(Duration.ofSeconds(1L), protocol));
                    AbstractTCPAdapter abstractTCPAdapter = JCardTool.configureVSmartCard((AbstractTCPAdapter)vSmartCardClient, options);
                    adapters.add(abstractTCPAdapter);
                }
                if (options.has(OPT_JCSDK) || options.has(OPT_JCSDK_PORT) || options.has(OPT_JCSDK_HOST) || options.has(OPT_JCSDK_PROTOCOL) || options.has(OPT_JCSDK_ATR)) {
                    void var10_34;
                    protocol = options.has(OPT_JCSDK_PROTOCOL) ? (String)options.valueOf(OPT_JCSDK_PROTOCOL) : (String)options.valueOf(OPT_PROTOCOL);
                    JCSDKServer jCSDKServer = new JCSDKServer(() -> sim.connect(protocol));
                    AbstractTCPAdapter abstractTCPAdapter2 = jCSDKServer.withHost((String)options.valueOf(OPT_JCSDK_HOST));
                    abstractTCPAdapter2 = abstractTCPAdapter2.withPort(((Integer)options.valueOf(OPT_JCSDK_PORT)).intValue());
                    if (options.has(OPT_ATR)) {
                        AbstractTCPAdapter abstractTCPAdapter3 = abstractTCPAdapter2.withATR(Hex.decode((String)((String)options.valueOf(OPT_ATR))));
                    }
                    if (options.has(OPT_JCSDK_ATR)) {
                        void var10_32;
                        AbstractTCPAdapter abstractTCPAdapter4 = var10_32.withATR(Hex.decode((String)((String)options.valueOf(OPT_JCSDK_ATR))));
                    }
                    adapters.add(var10_34);
                }
            }
            Thread shutdownThread = new Thread(() -> {
                System.err.println("Ctrl-C, quitting JCardEngine");
                exec.shutdownNow();
            });
            if (adapters.isEmpty()) {
                System.err.println("Use one of --vsmartcard or --jcsdk or --passthrough-host");
                System.exit(2);
            }
            Runtime.getRuntime().addShutdownHook(shutdownThread);
            if (options.has(OPT_CONTROL)) {
                adapters.forEach(exec::submit);
                boolean connected = true;
                TerminalBuilder tb = TerminalBuilder.builder().nativeSignals(false);
                try (Terminal terminal = tb.build();){
                    terminal.enterRawMode();
                    NonBlockingReader reader = terminal.reader();
                    while (!Thread.currentThread().isInterrupted()) {
                        int n = reader.read();
                        if (n == 27 || n == 113) {
                            System.err.println("Quit.");
                        }
                        if (n == 116) {
                            System.err.println("Triggering a fresh tap: boop!");
                            adapters.forEach(AbstractTCPAdapter::tap);
                            continue;
                        }
                        if (n == 99) {
                            boolean finalConnected = connected = !connected;
                            System.err.println(String.format("%s the card", connected ? "Connecting" : "Disconnecting"));
                            adapters.forEach(a -> a.connected(finalConnected));
                            continue;
                        }
                        System.err.println("Press 't' to trigger tap, 'c' to toggle connection, 'q' or Esc to quit.");
                    }
                }
            } else {
                exec.invokeAll(adapters);
            }
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
            exec.shutdownNow();
            while (!exec.isTerminated() && !exec.awaitTermination(1L, TimeUnit.MINUTES)) {
            }
            System.err.println("Thank you for using JCardEngine v" + version + "!");
        }
        catch (OptionException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getClass().getSimpleName() + ": " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(e.getClass().getSimpleName() + ": " + e.getMessage());
            System.exit(2);
        }
    }

    private static Class<? extends Applet> requireExtendsApplet(Class<?> cls) {
        System.out.println("Validating " + cls.getName());
        if (!Applet.class.isAssignableFrom(cls)) {
            throw new SystemException(1);
        }
        return cls;
    }
}

