/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.tool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class InstallableAppletChecker {
    public static boolean isValidApplet(Path classFilePath, ClassLoader cl) {
        try {
            ClassReader reader = new ClassReader(Files.readAllBytes(classFilePath));
            AppletVisitor visitor = new AppletVisitor(cl);
            reader.accept((ClassVisitor)visitor, 6);
            return visitor.isValid();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading class file", e);
        }
    }

    private static class AppletVisitor
    extends ClassVisitor {
        private final ClassLoader cl;
        private String superName;
        private boolean hasInstall;

        AppletVisitor(ClassLoader cl) {
            super(589824);
            this.cl = cl;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superName = superName;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if ((access & 8) != 0 && "install".equals(name) && "([BSB)V".equals(descriptor)) {
                this.hasInstall = true;
            }
            return null;
        }

        boolean isValid() {
            return this.hasInstall && this.extendsApplet();
        }

        private static byte[] readAllBytes(InputStream inputStream) throws IOException {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean extendsApplet() {
            String current = this.superName;
            while (current != null) {
                if ("java/lang/Object".equals(current)) return false;
                if ("javacard/framework/Applet".equals(current)) {
                    return true;
                }
                try {
                    InputStream is = this.cl.getResourceAsStream(current + ".class");
                    try {
                        if (is == null) {
                            boolean bl = false;
                            return bl;
                        }
                        current = new ClassReader(AppletVisitor.readAllBytes(is)).getSuperName();
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
    }
}

