/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveClassProxy {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveClassProxy.class);

    /*
     * WARNING - void declaration
     */
    public static <T> T proxy(Object targetInstance, Class<T> abstractClass) throws Exception {
        void var8_11;
        if (!abstractClass.isAssignableFrom(targetInstance.getClass())) {
            String msg = String.format("Target instance of type %s does not extend/implement %s", targetInstance.getClass().getName(), abstractClass.getName());
            throw new IllegalArgumentException(msg);
        }
        Class targetClass = targetInstance.getClass();
        Class<?>[] targetInterfaces = targetClass.getInterfaces();
        ArrayList visibleInterfaces = new ArrayList();
        ClassLoader proxyClassLoader = abstractClass.getClassLoader();
        Class<?>[] classArray = targetInterfaces;
        int n = classArray.length;
        boolean bl = false;
        while (var8_11 < n) {
            Class<?> iface = classArray[var8_11];
            try {
                Class<?> visibleInterface = proxyClassLoader.loadClass(iface.getName());
                visibleInterfaces.add(visibleInterface);
            }
            catch (ClassNotFoundException e) {
                log.warn("Ignoring implementation interface {}", (Object)iface.getSimpleName());
            }
            ++var8_11;
        }
        ElementMatcher.Junction methodMatcher = ElementMatchers.isDeclaredBy(abstractClass);
        for (Class clazz : visibleInterfaces) {
            methodMatcher = methodMatcher.or((ElementMatcher)ElementMatchers.isDeclaredBy((Class)clazz));
        }
        DynamicType.Builder builder = new ByteBuddy().subclass(abstractClass);
        if (!visibleInterfaces.isEmpty()) {
            builder = builder.implement((Type[])visibleInterfaces.toArray(new Class[0]));
        }
        Class clazz = builder.method((ElementMatcher)methodMatcher).intercept((Implementation)InvocationHandlerAdapter.of((proxy, method, args) -> {
            try {
                Method targetMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
                return targetMethod.invoke(targetInstance, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    throw e;
                }
                throw cause;
            }
        })).make().load(abstractClass.getClassLoader()).getLoaded();
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

