/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.APDUHelper;
import com.licel.jcardsim.base.Simulator;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.EngineSession;

public class SimulatorSession
implements EngineSession {
    private static final Logger log = LoggerFactory.getLogger(SimulatorSession.class);
    static ThreadFactory namedThreadFactory = r -> {
        Thread t = new Thread(r, "IdleWatchdog");
        t.setDaemon(true);
        return t;
    };
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
    private final Duration idleTimeout;
    private volatile boolean closed = false;
    private volatile ScheduledFuture<Void> timeoutTask;
    private final Simulator simulator;
    private final String protocol;
    private final byte protocol_byte;
    final Thread owner;

    SimulatorSession(Simulator simulator, String protocol, Duration timeout) {
        log.trace("Acquiring lock ...");
        this.simulator = simulator;
        simulator.lock.acquireUninterruptibly();
        this.idleTimeout = timeout;
        if (!this.idleTimeout.isZero()) {
            this.scheduleTimeout();
        }
        this.protocol = protocol;
        this.owner = Thread.currentThread();
        this.protocol_byte = APDUHelper.getProtocolByte(protocol);
        log.trace("Locked");
    }

    private void scheduleTimeout() {
        this.timeoutTask = scheduler.schedule(this::timeoutExpired, this.idleTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void refreshTimeout() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel(false);
            this.scheduleTimeout();
        }
    }

    private Void timeoutExpired() {
        log.info("Idle timeout, closing session for " + this.owner.getName());
        this.close(false);
        return null;
    }

    @Override
    public void close(boolean reset) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (reset) {
            this.simulator.reset();
        }
        this.simulator.lock.release();
        log.trace("Unlocked");
    }

    @Override
    public byte[] transmitCommand(byte[] commandAPDU) {
        if (this.closed) {
            throw new IllegalStateException("Session already closed");
        }
        this.refreshTimeout();
        return this.simulator._transmitCommand(this.protocol_byte, commandAPDU);
    }

    @Override
    public String getProtocol() {
        if (this.closed) {
            throw new IllegalStateException("Session already closed");
        }
        return this.protocol;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

