/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import java.lang.reflect.Field;
import javacard.security.CryptoException;
import javacard.security.InitializedMessageDigest;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.KeccakDigest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.util.Pack;

public class MessageDigestImpl
extends InitializedMessageDigest {
    private Digest engine;
    private byte algorithm;
    private short blockSize;
    private Class digestClass;
    private byte componentSize;
    private byte componentCount;
    private byte componentStartIdx;

    public MessageDigestImpl(byte algorithm) {
        this.algorithm = algorithm;
        this.componentStartIdx = 1;
        switch (algorithm) {
            case 1: {
                this.engine = new SHA1Digest();
                this.digestClass = this.engine.getClass();
                this.blockSize = (short)((SHA1Digest)this.engine).getByteLength();
                break;
            }
            case 2: {
                this.engine = new MD5Digest();
                this.digestClass = this.engine.getClass();
                this.blockSize = (short)((MD5Digest)this.engine).getByteLength();
                break;
            }
            case 3: {
                this.engine = new RIPEMD160Digest();
                this.digestClass = this.engine.getClass();
                this.blockSize = (short)((RIPEMD160Digest)this.engine).getByteLength();
                this.componentStartIdx = 0;
                break;
            }
            case 7: {
                this.engine = new SHA224Digest();
                this.digestClass = this.engine.getClass();
                this.blockSize = (short)((SHA224Digest)this.engine).getByteLength();
                break;
            }
            case 4: {
                this.engine = new SHA256Digest();
                this.digestClass = this.engine.getClass();
                this.blockSize = (short)((SHA256Digest)this.engine).getByteLength();
                break;
            }
            case 5: {
                this.engine = new SHA384Digest();
                this.digestClass = this.engine.getClass().getSuperclass();
                this.blockSize = (short)((SHA384Digest)this.engine).getByteLength();
                break;
            }
            case 6: {
                this.engine = new SHA512Digest();
                this.digestClass = this.engine.getClass().getSuperclass();
                this.blockSize = (short)((SHA512Digest)this.engine).getByteLength();
                break;
            }
            case 8: {
                this.engine = new SHA3Digest(224);
                this.digestClass = this.engine.getClass().getSuperclass();
                this.blockSize = (short)((SHA3Digest)this.engine).getByteLength();
                break;
            }
            case 9: {
                this.engine = new SHA3Digest(256);
                this.digestClass = this.engine.getClass().getSuperclass();
                this.blockSize = (short)((SHA3Digest)this.engine).getByteLength();
                break;
            }
            case 10: {
                this.engine = new SHA3Digest(384);
                this.digestClass = this.engine.getClass().getSuperclass();
                this.blockSize = (short)((SHA3Digest)this.engine).getByteLength();
                break;
            }
            case 11: {
                this.engine = new SHA3Digest(512);
                this.digestClass = this.engine.getClass().getSuperclass();
                this.blockSize = (short)((SHA3Digest)this.engine).getByteLength();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        this.componentSize = (byte)(this.blockSize == 64 ? 4 : 8);
        this.componentCount = this.getComponentCount(algorithm);
    }

    private byte getComponentCount(byte algorithm) {
        switch (algorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                return (byte)(this.engine.getDigestSize() / this.componentSize);
            }
            case 5: 
            case 7: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte getLength() {
        return (byte)this.engine.getDigestSize();
    }

    @Override
    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) {
        this.engine.update(inBuff, (int)inOffset, (int)inLength);
        return (short)this.engine.doFinal(outBuff, (int)outOffset);
    }

    @Override
    public void update(byte[] inBuff, short inOffset, short inLength) {
        this.engine.update(inBuff, (int)inOffset, (int)inLength);
    }

    @Override
    public void reset() {
        this.engine.reset();
    }

    @Override
    public void setInitialDigest(byte[] initialDigestBuf, short initialDigestOffset, short initialDigestLength, byte[] digestedMsgLenBuf, short digestedMsgLenOffset, short digestedMsgLenLength) throws CryptoException {
        short i;
        if (initialDigestLength != this.getIntermediateStateSize()) {
            CryptoException.throwIt((short)1);
        }
        if (!this.checkSupportDigestedMsgLenLength(digestedMsgLenLength)) {
            CryptoException.throwIt((short)1);
        }
        long byteCountLo = 0L;
        long byteCountHi = 0L;
        for (i = 0; i < digestedMsgLenLength; i = (short)(i + 1)) {
            if (i < 8) {
                byteCountLo = (byteCountLo << 8) + (long)(digestedMsgLenBuf[digestedMsgLenOffset + i] & 0xFF);
                continue;
            }
            byteCountHi = (byteCountHi << 8) + (long)(digestedMsgLenBuf[digestedMsgLenOffset + i] & 0xFF);
        }
        if (byteCountLo % (long)this.blockSize != 0L) {
            CryptoException.throwIt((short)1);
        }
        if (this.algorithm == 8 || this.algorithm == 9 || this.algorithm == 10 || this.algorithm == 11) {
            try {
                Field statesField = KeccakDigest.class.getDeclaredField("state");
                statesField.setAccessible(true);
                long[] states = (long[])long[].class.cast(statesField.get(this.engine));
                for (int i2 = 0; i2 < states.length; i2 = (int)((byte)(i2 + 1))) {
                    states[i2] = Pack.bigEndianToLong((byte[])initialDigestBuf, (int)(i2 * 8));
                }
            }
            catch (Exception e) {
                CryptoException.throwIt((short)5);
            }
        } else {
            try {
                for (i = 0; i < this.componentCount; i = (short)((byte)(i + 1))) {
                    Field h = this.digestClass.getDeclaredField("H" + (i + this.componentStartIdx));
                    h.setAccessible(true);
                    if (this.componentSize == 4) {
                        h.setInt(this.engine, Pack.bigEndianToInt((byte[])initialDigestBuf, (int)(initialDigestOffset + i * this.componentSize)));
                        continue;
                    }
                    h.setLong(this.engine, Pack.bigEndianToLong((byte[])initialDigestBuf, (int)(initialDigestOffset + i * this.componentSize)));
                }
                if (this.algorithm == 5 || this.algorithm == 6) {
                    Field byteCount1Field = this.digestClass.getDeclaredField("byteCount1");
                    byteCount1Field.setAccessible(true);
                    byteCount1Field.setLong(this.engine, byteCountLo);
                    Field byteCount2Field = this.digestClass.getDeclaredField("byteCount2");
                    byteCount2Field.setAccessible(true);
                    byteCount2Field.setLong(this.engine, byteCountHi);
                } else {
                    Field byteCountField = this.digestClass.getSuperclass().getDeclaredField("byteCount");
                    byteCountField.setAccessible(true);
                    byteCountField.setLong(this.engine, byteCountLo);
                }
            }
            catch (Exception e) {
                CryptoException.throwIt((short)5);
            }
        }
    }

    private boolean checkSupportDigestedMsgLenLength(short digestedMsgLenLength) {
        if (digestedMsgLenLength == 0) {
            return false;
        }
        switch (this.algorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                if (digestedMsgLenLength <= 8) break;
                return false;
            }
            case 5: 
            case 6: {
                if (digestedMsgLenLength <= 16) break;
                return false;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return true;
    }

    void getIntermediateDigest(byte[] intermediateDigest, int off) {
        if (this.algorithm == 8 || this.algorithm == 9 || this.algorithm == 10 || this.algorithm == 11) {
            try {
                Field statesField = KeccakDigest.class.getDeclaredField("state");
                statesField.setAccessible(true);
                long[] states = (long[])long[].class.cast(statesField.get(this.engine));
                for (int i = 0; i < states.length; i = (int)((byte)(i + 1))) {
                    Pack.longToBigEndian((long)states[i], (byte[])intermediateDigest, (int)(i * 8));
                }
            }
            catch (Exception e) {
                CryptoException.throwIt((short)5);
            }
        } else {
            try {
                for (byte i = 0; i < this.componentCount; i = (byte)(i + 1)) {
                    Field h = this.digestClass.getDeclaredField("H" + (i + this.componentStartIdx));
                    h.setAccessible(true);
                    if (this.componentSize == 4) {
                        Pack.intToBigEndian((int)h.getInt(this.engine), (byte[])intermediateDigest, (int)(off + i * this.componentSize));
                        continue;
                    }
                    Pack.longToBigEndian((long)h.getLong(this.engine), (byte[])intermediateDigest, (int)(off + i * this.componentSize));
                }
            }
            catch (Exception e) {
                CryptoException.throwIt((short)5);
            }
        }
    }

    short getBlockSize() {
        return this.blockSize;
    }

    short getIntermediateStateSize() {
        switch (this.algorithm) {
            case 1: {
                return 20;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 20;
            }
            case 7: {
                return 32;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
            case 6: {
                return 64;
            }
            case 8: {
                return 200;
            }
            case 9: {
                return 200;
            }
            case 10: {
                return 200;
            }
            case 11: {
                return 200;
            }
        }
        return 0;
    }
}

