/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.adapters;

import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.function.Supplier;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.EngineSession;
import pro.javacard.engine.adapters.AbstractTCPAdapter;
import pro.javacard.engine.adapters.JCSDKServer;
import pro.javacard.engine.adapters.RemoteMessage;

public class JCSDKClient
implements Supplier<EngineSession>,
EngineSession {
    private static final Logger log = LoggerFactory.getLogger(JCSDKClient.class);
    final String host;
    final int port;
    private SocketChannel channel;
    private byte[] atr;
    private boolean closed;

    public JCSDKClient(String host, int port) {
        this.port = port;
        this.host = host;
    }

    static RemoteMessage recv(SocketChannel channel) throws IOException {
        log.trace("Trying to read header ...");
        ByteBuffer hdr = ByteBuffer.allocate(4);
        int len = channel.read(hdr);
        if (len < 0) {
            log.info("Peer closed connection");
            throw new EOFException("Peer closed connection");
        }
        byte b1 = hdr.get(0);
        log.info("Received {}", (Object)Hex.toHexString((byte[])hdr.array()));
        switch (b1) {
            case -16: {
                short atrlen = hdr.getShort(2);
                ByteBuffer atr = ByteBuffer.allocate(atrlen);
                channel.read(atr);
                return new RemoteMessage(RemoteMessage.Type.ATR, atr.array());
            }
            case 0: {
                int cmdlen = hdr.getInt(0);
                ByteBuffer cmd = ByteBuffer.allocate(cmdlen);
                do {
                    channel.read(cmd);
                    log.trace("Read {} out of {}", (Object)cmd.position(), (Object)cmd.limit());
                } while (cmd.position() < cmd.limit());
                return new RemoteMessage(RemoteMessage.Type.APDU, cmd.array());
            }
        }
        throw new IOException("Unknown command header: %s" + Hex.toHexString((byte[])hdr.array()));
    }

    static RemoteMessage send(SocketChannel channel, RemoteMessage message) throws IOException {
        log.info("Sending " + String.valueOf((Object)message.getType()));
        switch (message.getType()) {
            case APDU: {
                channel.write(JCSDKServer.format((byte)0, message.getPayload()));
                break;
            }
            case ATR: {
                channel.write(JCSDKServer.format((byte)-16, new byte[0]));
                break;
            }
            case POWERDOWN: {
                channel.write(JCSDKServer.format((byte)-2, new byte[0]));
                channel.close();
                return null;
            }
            default: {
                log.warn("Unknown message for protocol: " + String.valueOf((Object)message.getType()));
            }
        }
        RemoteMessage received = JCSDKClient.recv(channel);
        log.trace("Received {}: {}", (Object)received.getType(), (Object)Hex.toHexString((byte[])received.getPayload()));
        return received;
    }

    public SocketChannel getSocket() throws IOException {
        return AbstractTCPAdapter.connect(this.host, this.port);
    }

    public void reset() {
        try {
            JCSDKClient.send(this.channel, new RemoteMessage(RemoteMessage.Type.POWERDOWN));
            this.atr = JCSDKClient.send(this.channel, new RemoteMessage(RemoteMessage.Type.ATR)).getPayload();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] getATR() {
        if (this.atr == null) {
            this.reset();
        }
        return (byte[])this.atr.clone();
    }

    @Override
    public byte[] transmitCommand(byte[] commandAPDU) {
        try {
            return JCSDKClient.send(this.channel, new RemoteMessage(RemoteMessage.Type.APDU, commandAPDU)).getPayload();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String getProtocol() {
        return "T=1";
    }

    @Override
    public EngineSession get() {
        try {
            JCSDKClient connection = new JCSDKClient(this.host, this.port);
            connection.channel = AbstractTCPAdapter.connect(this.host, this.port);
            connection.atr = JCSDKClient.send(connection.channel, new RemoteMessage(RemoteMessage.Type.ATR)).getPayload();
            return connection;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close(boolean reset) {
        log.trace("Closing connection");
        try {
            if (reset) {
                JCSDKClient.send(this.channel, new RemoteMessage(RemoteMessage.Type.POWERDOWN));
            }
            this.closed = true;
            this.channel.close();
        }
        catch (IOException e) {
            log.error("Could not send POWERDOWN", (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

