/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.globalplatform;

import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.utils.AIDUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Objects;
import javacard.framework.APDU;
import javacard.framework.ISOException;
import javacard.framework.Util;
import org.bouncycastle.util.encoders.Hex;
import org.globalplatform.SecureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.gp.GPCardKeys;
import pro.javacard.gp.GPCrypto;
import pro.javacard.gp.GPSecureChannelVersion;
import pro.javacard.gp.GPUtils;
import pro.javacard.gptool.keys.PlaintextKeys;

public class SCP03SecureChannelImpl
implements SecureChannel {
    private static final Logger log = LoggerFactory.getLogger(SCP03SecureChannelImpl.class);
    private static final boolean s16 = false;
    private final byte[] KVN = new byte[]{-1};
    private final byte[] SCP = new byte[]{3, 112};
    private static final byte[] kdd = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final byte[] ssc = new byte[3];
    private final byte[] chaining = new byte[16];
    private final byte[] enc_counter = new byte[16];
    private byte state = 0;
    private byte[] macKey;
    private byte[] encKey;
    private byte[] ctx;

    @Override
    public short processSecurity(APDU apdu) throws ISOException {
        byte[] buffer;
        if (apdu.getCurrentState() == 0) {
            apdu.setIncomingAndReceive();
        }
        if ((buffer = apdu.getBuffer())[1] == 80) {
            if (buffer[0] != -128) {
                ISOException.throwIt((short)28160);
            }
            if (buffer[2] != 0 && buffer[3] != 0) {
                ISOException.throwIt((short)27270);
            }
            if (buffer[4] != 8) {
                ISOException.throwIt((short)26368);
            }
            this.resetSecurity();
            PlaintextKeys keys = PlaintextKeys.defaultKey();
            keys.diversify(GPSecureChannelVersion.SCP.SCP03, kdd);
            byte[] kdf_ctx = GPUtils.concatenate((byte[][])new byte[][]{this.ssc, AIDUtil.bytes(Simulator.current().getAID())});
            byte[] host_challenge = Arrays.copyOfRange(apdu.getBuffer(), 5, 13);
            byte[] card_challenge = keys.scp3_kdf(GPCardKeys.KeyPurpose.ENC, GPCrypto.scp03_kdf_blocka((byte)2, (int)64), kdf_ctx, 8);
            this.ctx = GPUtils.concatenate((byte[][])new byte[][]{host_challenge, card_challenge});
            this.macKey = keys.getSessionKey(GPCardKeys.KeyPurpose.MAC, this.ctx);
            this.encKey = keys.getSessionKey(GPCardKeys.KeyPurpose.ENC, this.ctx);
            byte[] cryptogram = GPCrypto.scp03_kdf((byte[])this.macKey, (byte)0, (byte[])this.ctx, (int)64);
            byte[] resp = GPUtils.concatenate((byte[][])new byte[][]{kdd, this.KVN, this.SCP, card_challenge, cryptogram, this.ssc});
            System.arraycopy(resp, 0, buffer, 5, resp.length);
            return (short)resp.length;
        }
        if (buffer[1] == -126) {
            if (buffer[0] != -124) {
                ISOException.throwIt((short)28160);
            }
            if ((buffer[2] & 0xFFFFFFC0) != 0) {
                ISOException.throwIt((short)27270);
            }
            if ((buffer[2] & 0xFFFFFFCC) != 0) {
                ISOException.throwIt((short)27270);
            }
            if (buffer[3] != 0) {
                ISOException.throwIt((short)27270);
            }
            if (buffer[4] != 16) {
                ISOException.throwIt((short)26368);
            }
            this.process_mac(buffer, 0, apdu.getIncomingLength() + 5);
            byte[] host_cryptogram = GPCrypto.scp03_kdf((byte[])this.macKey, (byte)1, (byte[])this.ctx, (int)64);
            if (!Arrays.equals(host_cryptogram, Arrays.copyOfRange(apdu.getBuffer(), 5, 5 + host_cryptogram.length))) {
                log.error("Host cryptogram check failed");
                ISOException.throwIt((short)25344);
            }
            this.state = (byte)(0xFFFFFF80 | buffer[2]);
            GPCrypto.buffer_increment((byte[])this.ssc);
            log.debug("Secure channel #{} state is now {}", (Object)Hex.toHexString((byte[])this.ssc), (Object)String.format("%02x", this.state));
            return 0;
        }
        ISOException.throwIt((short)27904);
        return 0;
    }

    void process_mac(byte[] buffer, int offset, int length) {
        try {
            int maclen = 8;
            byte[] mac = Arrays.copyOfRange(buffer, offset + length - 8, offset + length);
            log.trace("mac: {}", (Object)Hex.toHexString((byte[])mac));
            byte[] payload = Arrays.copyOfRange(buffer, offset + 5, offset + length - 8);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            bo.write(this.chaining);
            bo.write(buffer[offset + 0]);
            bo.write(buffer[offset + 1]);
            bo.write(buffer[offset + 2]);
            bo.write(buffer[offset + 3]);
            bo.write(buffer[offset + 4]);
            bo.write(payload);
            byte[] cmac_input = bo.toByteArray();
            log.trace("mac input: {}", (Object)Hex.toHexString((byte[])cmac_input));
            byte[] cmac = GPCrypto.aes_cmac((byte[])this.macKey, (byte[])cmac_input, (int)128);
            System.arraycopy(cmac, 0, this.chaining, 0, this.chaining.length);
            byte[] check = Arrays.copyOf(cmac, 8);
            if (!Arrays.equals(check, mac)) {
                log.error("MAC mismatch: calculated {}, presented {}", (Object)Hex.toHexString((byte[])check), (Object)Hex.toHexString((byte[])mac));
                this.resetSecurity();
                ISOException.throwIt((short)27013);
            }
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)e);
        }
    }

    @Override
    public short wrap(byte[] bytes, short i, short i1) throws ISOException {
        throw new UnsupportedOperationException("SecureChannel.wrap()");
    }

    @Override
    public short unwrap(byte[] bytes, short offset, short length) throws ISOException {
        log.trace("Unwrapping ...");
        int maclen = 8;
        byte[] cryptogram = Arrays.copyOfRange(bytes, offset + 5, offset + length - 8);
        try {
            if ((this.state & 1) == 1) {
                this.process_mac(bytes, offset, length);
            }
            log.trace("Cryptogram len={} {}", (Object)cryptogram.length, (Object)Hex.toHexString((byte[])cryptogram));
            if ((bytes[0] & 4) == 4 && (this.state & 2) == 2) {
                GPCrypto.buffer_increment((byte[])this.enc_counter);
                byte[] iv = GPCrypto.aes_cbc((byte[])this.enc_counter, (byte[])this.encKey, (byte[])new byte[16]);
                byte[] payload = GPCrypto.aes_cbc_decrypt((byte[])cryptogram, (byte[])this.encKey, (byte[])iv);
                payload = GPCrypto.unpad80((byte[])payload);
                log.trace("Unwrapped: {}", (Object)Hex.toHexString((byte[])payload));
                Util.arrayCopyNonAtomic(payload, (short)0, bytes, (short)(offset + 5), (short)payload.length);
                bytes[offset + 4] = (byte)payload.length;
                return (short)(5 + payload.length);
            }
            log.warn("Don't know how to process state {} with {}", (Object)String.format("%02x", this.state), (Object)Hex.toHexString((byte[])Arrays.copyOfRange(bytes, (int)offset, offset + 4)));
            log.warn("No unwrap implemented for SCP03SecureChannelImpl");
            ISOException.throwIt((short)27264);
            return 0;
        }
        catch (GeneralSecurityException e) {
            log.error("Decryption failed", (Throwable)e);
            this.resetSecurity();
            ISOException.throwIt((short)27013);
            return 0;
        }
    }

    @Override
    public short decryptData(byte[] buffer, short offset, short length) throws ISOException {
        Objects.requireNonNull(buffer);
        if (length % 16 != 0) {
            ISOException.throwIt((short)26368);
        }
        if ((this.state & 0xFFFFFF80) == 0) {
            ISOException.throwIt((short)27013);
        }
        try {
            byte[] result = GPCrypto.aes_cbc_decrypt((byte[])Arrays.copyOfRange(buffer, (int)offset, offset + length), (byte[])PlaintextKeys.DEFAULT_KEY(), (byte[])new byte[16]);
            Util.arrayCopyNonAtomic(result, (short)0, buffer, offset, (short)result.length);
            return (short)result.length;
        }
        catch (GeneralSecurityException e) {
            log.error("Could not decrypt data: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException((Throwable)e);
        }
    }

    @Override
    public short encryptData(byte[] bytes, short i, short i1) throws ISOException {
        throw new UnsupportedOperationException("SecureChannel.encryptData()");
    }

    @Override
    public void resetSecurity() {
        this.state = 0;
        Arrays.fill(this.chaining, (byte)0);
        Arrays.fill(this.enc_counter, (byte)0);
    }

    @Override
    public byte getSecurityLevel() {
        return this.state;
    }
}

