/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import java.util.Locale;
import java.util.Objects;
import javacard.framework.Util;

public final class APDUHelper {
    public static final int CASE1 = 1;
    public static final int CASE2 = 2;
    public static final int CASE2_EXTENDED = 3;
    public static final int CASE3 = 4;
    public static final int CASE3_EXTENDED = 5;
    public static final int CASE4 = 6;
    public static final int CASE4_EXTENDED = 7;

    public static boolean isExtendedAPDU(int apducase) {
        switch (apducase) {
            case 3: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static int getAPDUCase(byte[] command) {
        Objects.requireNonNull(command);
        if (command.length < 4) {
            throw new IllegalArgumentException("command: malformed APDU, length < 4");
        }
        if (command.length == 4) {
            return 1;
        }
        if (command.length == 5) {
            return 2;
        }
        if (command.length == 7 && command[4] == 0) {
            return 3;
        }
        if (command[4] == 0) {
            int offset;
            short lc = Util.getShort(command, (short)5);
            if (lc + (offset = 7) == command.length) {
                return 5;
            }
            if (lc + offset + 2 == command.length) {
                return 7;
            }
            throw new IllegalArgumentException("Invalid extended C-APDU: Lc or Le is invalid");
        }
        int lc = command[4] & 0xFF;
        int offset = 5;
        if (lc + offset == command.length) {
            return 4;
        }
        if (lc + offset + 1 == command.length) {
            return 6;
        }
        throw new IllegalArgumentException("Invalid C-APDU: Lc or Le is invalid");
    }

    public static byte getProtocolByte(String protocol) {
        int protocolByte;
        Objects.requireNonNull(protocol, "protocol");
        String p = protocol.toUpperCase(Locale.ENGLISH).replace(" ", "");
        if (p.equals("T=0") || p.equals("*")) {
            protocolByte = 0;
        } else if (p.equals("T=1")) {
            protocolByte = 1;
        } else if (p.equals("T=CL,TYPE_A,T1") || p.equals("T=CL")) {
            protocolByte = -128;
            protocolByte = (byte)(protocolByte | 1);
        } else if (p.equals("T=CL,TYPE_B,T1")) {
            protocolByte = -112;
            protocolByte = (byte)(protocolByte | 1);
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + protocol);
        }
        return (byte)protocolByte;
    }
}

