/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.Simulator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewByteArrayInterceptor
extends ClassVisitor {
    private static final Logger log = LoggerFactory.getLogger(NewByteArrayInterceptor.class);

    public NewByteArrayInterceptor(ClassVisitor classVisitor) {
        super(589824, classVisitor);
    }

    public static byte[] transform(byte[] classBytes, ClassLoader classLoader) {
        ClassReader classReader = new ClassReader(classBytes);
        CustomClassWriter classWriter = new CustomClassWriter(classReader, 1, classLoader);
        NewByteArrayInterceptor interceptor = new NewByteArrayInterceptor((ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)interceptor, 0);
        return classWriter.toByteArray();
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (name.equals("jcardengine") && descriptor.equals("Z") && (access & 1) != 0 && (access & 8) != 0) {
            log.info("Setting magic jcardengine field to true");
            return super.visitField(access, name, descriptor, signature, (Object)1);
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new ByteArrayMethodVisitor(mv);
    }

    private static class ByteArrayMethodVisitor
    extends MethodVisitor {
        public ByteArrayMethodVisitor(MethodVisitor methodVisitor) {
            super(589824, methodVisitor);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (opcode == 188 && operand == 8) {
                log.trace("Intercepting \"new byte[]\"");
                super.visitMethodInsn(184, Simulator.class.getCanonicalName().replace(".", "/"), "allocate", "(I)[B", false);
            } else {
                super.visitIntInsn(opcode, operand);
            }
        }
    }

    private static class CustomClassWriter
    extends ClassWriter {
        private final ClassLoader classLoader;

        public CustomClassWriter(ClassReader classReader, int flags, ClassLoader classLoader) {
            super(classReader, flags);
            this.classLoader = classLoader;
        }

        protected ClassLoader getClassLoader() {
            return this.classLoader != null ? this.classLoader : super.getClassLoader();
        }
    }
}

