/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.BouncyCastlePrecomputedOrDigestProxy;
import com.licel.jcardsim.crypto.KeyWithParameters;
import com.licel.jcardsim.crypto.SecureRandomNullProvider;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.Signature;
import javacard.security.SignatureMessageRecovery;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.SignerWithRecovery;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricSignatureImpl
extends Signature
implements SignatureMessageRecovery {
    private static final Logger log = LoggerFactory.getLogger(AsymmetricSignatureImpl.class);
    Signer engine;
    Key key;
    byte algorithm;
    byte cipherAlgorithm;
    byte paddingAlgorithm;
    boolean isInitialized;
    boolean isRecovery;
    byte[] preSig;
    Digest digest;
    boolean isImplicitTrailer;

    public AsymmetricSignatureImpl(byte algorithm) {
        this(algorithm, 0, 0);
    }

    public AsymmetricSignatureImpl(byte algorithm, byte cipherAlgorithm, byte paddingAlgorithm) {
        this.algorithm = algorithm;
        this.isImplicitTrailer = false;
        this.cipherAlgorithm = cipherAlgorithm;
        this.paddingAlgorithm = paddingAlgorithm;
        this.isRecovery = false;
        if (this.isRawECDSAWithoutHash()) {
            this.engine = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new BouncyCastlePrecomputedOrDigestProxy((Digest)new NullDigest()));
            return;
        }
        switch (algorithm) {
            case 9: {
                this.digest = new SHA1Digest();
                this.engine = new ISO9796d2Signer((AsymmetricBlockCipher)new RSAEngine(), this.digest);
                break;
            }
            case 30: {
                this.digest = new SHA1Digest();
                this.engine = new ISO9796d2Signer((AsymmetricBlockCipher)new RSAEngine(), this.digest, true);
                this.isImplicitTrailer = true;
                this.isRecovery = true;
                break;
            }
            case 10: {
                this.digest = new SHA1Digest();
                this.engine = new RSADigestSigner((Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 39: {
                this.digest = new SHA224Digest();
                this.engine = new RSADigestSigner((Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 40: {
                this.digest = new SHA256Digest();
                this.engine = new RSADigestSigner((Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 41: {
                this.digest = new SHA384Digest();
                this.engine = new RSADigestSigner((Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 42: {
                this.digest = new SHA512Digest();
                this.engine = new RSADigestSigner((Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 21: {
                this.digest = new SHA1Digest();
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest), 16);
                break;
            }
            case 43: {
                this.digest = new SHA224Digest();
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest), 28);
                break;
            }
            case 44: {
                this.digest = new SHA256Digest();
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest), 32);
                break;
            }
            case 45: {
                this.digest = new SHA384Digest();
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest), 48);
                break;
            }
            case 46: {
                this.digest = new SHA512Digest();
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest), 64);
                break;
            }
            case 11: {
                this.digest = new MD5Digest();
                this.engine = new RSADigestSigner((Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 12: {
                this.digest = new RIPEMD160Digest();
                this.engine = new ISO9796d2Signer((AsymmetricBlockCipher)new RSAEngine(), this.digest);
                break;
            }
            case 13: {
                this.digest = new RIPEMD160Digest();
                this.engine = new RSADigestSigner((Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 17: {
                this.digest = new SHA1Digest();
                this.engine = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 37: {
                this.digest = new SHA224Digest();
                this.engine = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 33: {
                this.digest = new SHA256Digest();
                this.engine = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 34: {
                this.digest = new SHA384Digest();
                this.engine = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 38: {
                this.digest = new SHA512Digest();
                this.engine = new DSADigestSigner((DSA)new ECDSASigner(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 14: {
                this.digest = new SHA1Digest();
                this.engine = new DSADigestSigner((DSA)new DSASigner(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest));
                break;
            }
            case 22: {
                this.digest = new MD5Digest();
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest), 16);
                break;
            }
            case 23: {
                this.digest = new RIPEMD160Digest();
                this.engine = new PSSSigner((AsymmetricBlockCipher)new RSAEngine(), (Digest)new BouncyCastlePrecomputedOrDigestProxy(this.digest), 20);
                break;
            }
            case 15: 
            case 16: 
            case 31: {
                CryptoException.throwIt((short)3);
                break;
            }
            default: {
                log.warn("Algorithm {} not available", (Object)algorithm);
                CryptoException.throwIt((short)3);
            }
        }
    }

    private boolean isRawECDSAWithoutHash() {
        return this.algorithm == 0 && this.cipherAlgorithm == 5 && this.paddingAlgorithm == 0;
    }

    @Override
    public void init(Key theKey, byte theMode) throws CryptoException {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        if (this.engine instanceof ISO9796d2Signer || theMode != 1) {
            KeyWithParameters key = (KeyWithParameters)((Object)theKey);
            this.engine.init(theMode == 1, key.getParameters());
        } else {
            ParametersWithRandom params = new ParametersWithRandom(((KeyWithParameters)((Object)theKey)).getParameters(), (SecureRandom)new SecureRandomNullProvider());
            this.engine.init(theMode == 1, (CipherParameters)params);
        }
        this.key = theKey;
        this.isInitialized = true;
    }

    @Override
    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        CryptoException.throwIt((short)1);
    }

    @Override
    public short getLength() throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if (!this.key.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (this.isRawECDSAWithoutHash()) {
            return this.getECDSASignatureLength();
        }
        switch (this.algorithm) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return (short)(this.key.getSize() >> 3);
            }
            case 14: 
            case 17: 
            case 33: 
            case 34: 
            case 37: 
            case 38: {
                return this.getECDSASignatureLength();
            }
        }
        return 0;
    }

    private short getECDSASignatureLength() {
        int keySizeInByte = this.key.getSize() / 8;
        int signatureSize = keySizeInByte * 2;
        return (short)(signatureSize + 8);
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void update(byte[] inBuff, short inOffset, short inLength) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, (int)inOffset, (int)inLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset) throws CryptoException {
        if (this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, (int)inOffset, (int)inLength);
        try {
            byte[] sig = this.engine.generateSignature();
            Util.arrayCopyNonAtomic(sig, (short)0, sigBuff, sigOffset, (short)sig.length);
            short s = (short)sig.length;
            return s;
        }
        catch (org.bouncycastle.crypto.CryptoException ex) {
            CryptoException.throwIt((short)5);
        }
        catch (DataLengthException ex) {
            CryptoException.throwIt((short)1);
        }
        finally {
            this.engine.reset();
        }
        return -1;
    }

    @Override
    public boolean verify(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short sigLength) throws CryptoException {
        if (this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, (int)inOffset, (int)inLength);
        byte[] sig = new byte[sigLength];
        Util.arrayCopyNonAtomic(sigBuff, sigOffset, sig, (short)0, sigLength);
        boolean b = this.engine.verifySignature(sig);
        this.engine.reset();
        return b;
    }

    @Override
    public short beginVerify(byte[] sigAndRecDataBuff, short buffOffset, short sigLength) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.preSig = JCSystem.makeTransientByteArray(sigLength, (byte)1);
        Util.arrayCopyNonAtomic(sigAndRecDataBuff, buffOffset, this.preSig, (short)0, sigLength);
        try {
            ((SignerWithRecovery)this.engine).updateWithRecoveredMessage(this.preSig);
            return (short)((SignerWithRecovery)this.engine).getRecoveredMessage().length;
        }
        catch (Exception ex) {
            CryptoException.throwIt((short)1);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short[] recMsgLen, short recMsgLenOffset) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, (int)inOffset, (int)inLength);
        try {
            Field messageLengthField = this.engine.getClass().getDeclaredField("messageLength");
            messageLengthField.setAccessible(true);
            int messageLength = messageLengthField.getInt(this.engine);
            byte[] sig = this.engine.generateSignature();
            Util.arrayCopyNonAtomic(sig, (short)0, sigBuff, sigOffset, (short)sig.length);
            short keyBits = this.key.getSize();
            int digSize = this.digest.getDigestSize();
            int t = 0;
            t = this.isImplicitTrailer ? 8 : 16;
            int x = (digSize + messageLength) * 8 + t + 4 - keyBits;
            int mR = messageLength;
            if (x > 0) {
                mR = messageLength - (x + 7) / 8;
            }
            recMsgLen[recMsgLenOffset] = (short)mR;
            short s = (short)sig.length;
            return s;
        }
        catch (org.bouncycastle.crypto.CryptoException ex) {
            CryptoException.throwIt((short)5);
        }
        catch (DataLengthException ex) {
            CryptoException.throwIt((short)1);
        }
        catch (Exception ex) {
            log.error("Unexpected exception", (Throwable)ex);
            CryptoException.throwIt((short)5);
        }
        finally {
            this.engine.reset();
        }
        return -1;
    }

    @Override
    public boolean verify(byte[] inBuff, short inOffset, short inLength) throws CryptoException {
        if (!this.isRecovery) {
            CryptoException.throwIt((short)5);
        }
        if (this.preSig == null) {
            CryptoException.throwIt((short)5);
        }
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        this.engine.update(inBuff, (int)inOffset, (int)inLength);
        boolean b = this.engine.verifySignature(this.preSig);
        this.engine.reset();
        return b;
    }

    @Override
    public void setInitialDigest(byte[] bytes, short s, short s1, byte[] bytes1, short s2, short s3) throws CryptoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public short signPreComputedHash(byte[] hashBuff, short hashOffset, short hashLength, byte[] sigBuff, short sigOffset) throws CryptoException {
        try {
            if (this.engine instanceof RSADigestSigner || this.engine instanceof DSADigestSigner || this.engine instanceof PSSSigner) {
                Field h = this.engine.getClass().getDeclaredField(this.engine instanceof PSSSigner ? "contentDigest1" : "digest");
                h.setAccessible(true);
                Object digestObject = h.get(this.engine);
                digestObject.getClass().getMethod("setPrecomputedValue", byte[].class, Integer.TYPE, Integer.TYPE).invoke(digestObject, hashBuff, hashOffset, hashLength);
                return this.sign(null, (short)0, (short)0, sigBuff, sigOffset);
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        CryptoException.throwIt((short)5);
        return 0;
    }

    @Override
    public boolean verifyPreComputedHash(byte[] hashBuff, short hashOffset, short hashLength, byte[] sigBuff, short sigOffset, short sigLength) throws CryptoException {
        try {
            if (this.engine instanceof RSADigestSigner || this.engine instanceof DSADigestSigner || this.engine instanceof PSSSigner) {
                Field h = this.engine.getClass().getDeclaredField(this.engine instanceof PSSSigner ? "contentDigest1" : "digest");
                h.setAccessible(true);
                Object digestObject = h.get(this.engine);
                digestObject.getClass().getMethod("setPrecomputedValue", byte[].class, Integer.TYPE, Integer.TYPE).invoke(digestObject, hashBuff, hashOffset, hashLength);
                return this.verify(null, (short)0, (short)0, sigBuff, sigOffset, sigLength);
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        CryptoException.throwIt((short)5);
        return false;
    }

    @Override
    public byte getPaddingAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getCipherAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getMessageDigestAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

