/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.KeyImpl;
import java.math.BigInteger;
import java.security.SecureRandom;
import javacard.security.CryptoException;
import javacard.security.RSAPrivateKey;
import javacard.security.RSAPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class RSAKeyImpl
extends KeyImpl
implements RSAPrivateKey,
RSAPublicKey {
    protected ByteContainer exponent = new ByteContainer();
    protected ByteContainer modulus = new ByteContainer();
    protected boolean isPrivate;

    public RSAKeyImpl(boolean isPrivate, short size) {
        this.isPrivate = isPrivate;
        this.size = size;
        this.type = (byte)(isPrivate ? 5 : 4);
    }

    @Override
    public void setParameters(CipherParameters params) {
        this.modulus.setBigInteger(((RSAKeyParameters)params).getModulus());
        this.exponent.setBigInteger(((RSAKeyParameters)params).getExponent());
    }

    @Override
    public short getExponent(byte[] buffer, short offset) {
        return this.exponent.getBytes(buffer, offset);
    }

    @Override
    public short getModulus(byte[] buffer, short offset) {
        return this.modulus.getBytes(buffer, offset);
    }

    @Override
    public void setExponent(byte[] buffer, short offset, short length) throws CryptoException {
        this.exponent.setBytes(buffer, offset, length);
    }

    @Override
    public void setModulus(byte[] buffer, short offset, short length) throws CryptoException {
        this.modulus.setBytes(buffer, offset, length);
    }

    @Override
    public void clearKey() {
        this.exponent.clear();
        this.modulus.clear();
    }

    @Override
    public boolean isInitialized() {
        return this.exponent.isInitialized() && this.modulus.isInitialized();
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new RSAKeyParameters(this.isPrivate, this.modulus.getBigInteger(), this.exponent.getBigInteger());
    }

    @Override
    public KeyGenerationParameters getKeyGenerationParameters(SecureRandom rnd) {
        if (!this.isPrivate && this.exponent.isInitialized()) {
            return new RSAKeyGenerationParameters(this.exponent.getBigInteger(), rnd, (int)this.size, 80);
        }
        return RSAKeyImpl.getDefaultKeyGenerationParameters(this.size, rnd);
    }

    static KeyGenerationParameters getDefaultKeyGenerationParameters(short keySize, SecureRandom rnd) {
        return new RSAKeyGenerationParameters(new BigInteger("10001", 16), rnd, (int)keySize, 80);
    }
}

