/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.SymmetricKeyImpl;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacardx.crypto.Cipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricCipherImpl
extends Cipher {
    private static final Logger log = LoggerFactory.getLogger(SymmetricCipherImpl.class);
    byte algorithm;
    BufferedBlockCipher engine;
    boolean isInitialized;

    public SymmetricCipherImpl(byte algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void init(Key theKey, byte theMode) throws CryptoException {
        this.selectCipherEngine(theKey);
        this.engine.init(theMode == 2, ((SymmetricKeyImpl)theKey).getParameters());
        this.isInitialized = true;
    }

    @Override
    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        switch (this.algorithm) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                CryptoException.throwIt((short)1);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (bLen == 8) break;
                CryptoException.throwIt((short)1);
                break;
            }
            default: {
                log.trace("No init for cipher algo: " + this.algorithm);
            }
        }
        this.selectCipherEngine(theKey);
        byte[] iv = JCSystem.makeTransientByteArray(bLen, (byte)1);
        Util.arrayCopyNonAtomic(bArray, bOff, iv, (short)0, bLen);
        this.engine.init(theMode == 2, (CipherParameters)new ParametersWithIV(((SymmetricKeyImpl)theKey).getParameters(), iv));
        this.isInitialized = true;
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        short processedBytes = (short)this.engine.processBytes(inBuff, (int)inOffset, (int)inLength, outBuff, (int)outOffset);
        try {
            return (short)(this.engine.doFinal(outBuff, outOffset + processedBytes) + processedBytes);
        }
        catch (Exception ex) {
            CryptoException.throwIt((short)5);
            return -1;
        }
    }

    @Override
    public short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        return (short)this.engine.processBytes(inBuff, (int)inOffset, (int)inLength, outBuff, (int)outOffset);
    }

    private void selectCipherEngine(Key theKey) {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof SymmetricKeyImpl)) {
            CryptoException.throwIt((short)1);
        }
        if (!this.checkKeyCompatibility(theKey)) {
            CryptoException.throwIt((short)1);
        }
        SymmetricKeyImpl key = (SymmetricKeyImpl)theKey;
        switch (this.algorithm) {
            case 1: 
            case 13: 
            case 17: {
                this.engine = new BufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)key.getCipher()));
                break;
            }
            case 2: {
                this.engine = new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)key.getCipher()), (BlockCipherPadding)new ZeroBytePadding());
                break;
            }
            case 3: {
                this.engine = new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)key.getCipher()), (BlockCipherPadding)new ISO7816d4Padding());
                break;
            }
            case 4: {
                this.engine = new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)key.getCipher()), (BlockCipherPadding)new PKCS7Padding());
                break;
            }
            case 5: 
            case 14: 
            case 16: {
                this.engine = new BufferedBlockCipher(key.getCipher());
                break;
            }
            case 6: {
                this.engine = new PaddedBufferedBlockCipher(key.getCipher(), (BlockCipherPadding)new ZeroBytePadding());
                break;
            }
            case 7: {
                this.engine = new PaddedBufferedBlockCipher(key.getCipher(), (BlockCipherPadding)new ISO7816d4Padding());
                break;
            }
            case 8: {
                this.engine = new PaddedBufferedBlockCipher(key.getCipher(), (BlockCipherPadding)new PKCS7Padding());
                break;
            }
            case 23: {
                this.engine = new PaddedBufferedBlockCipher((BlockCipher)CBCBlockCipher.newInstance((BlockCipher)key.getCipher()), (BlockCipherPadding)new ISO7816d4Padding());
                break;
            }
            case -16: {
                this.engine = new BufferedBlockCipher((BlockCipher)new SICBlockCipher(key.getCipher()));
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }

    private boolean checkKeyCompatibility(Key theKey) {
        switch (theKey.getType()) {
            case 1: 
            case 2: 
            case 3: {
                if (this.algorithm != 1 && this.algorithm != 2 && this.algorithm != 3 && this.algorithm != 4 && this.algorithm != 5 && this.algorithm != 6 && this.algorithm != 7 && this.algorithm != 8) break;
                return true;
            }
            case 13: 
            case 14: 
            case 15: {
                if (this.algorithm != -16 && this.algorithm != 13 && this.algorithm != 14 && this.algorithm != 22 && this.algorithm != 23 && this.algorithm != 24 && this.algorithm != 25 && this.algorithm != 26 && this.algorithm != 27) break;
                return true;
            }
            case 16: 
            case 17: 
            case 18: {
                if (this.algorithm != 17 && this.algorithm != 16) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public byte getPaddingAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getCipherAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

