/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import org.bouncycastle.util.encoders.Hex;

public final class ByteUtil {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static byte[] byteArray(String hexString) {
        if (hexString == null) {
            throw new NullPointerException("hexArray");
        }
        return Hex.decode((String)hexString);
    }

    public static String hexString(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return ByteUtil.hexString(bytes, 0, bytes.length);
    }

    public static String hexString(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        char[] hexChars = new char[length * 2];
        int j = offset;
        int i = 0;
        while (j < offset + length) {
            int v = bytes[j] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
            ++j;
            ++i;
        }
        return new String(hexChars);
    }

    public static short getSW(byte[] apduBuffer) {
        if (apduBuffer == null) {
            throw new NullPointerException("bytes");
        }
        if (apduBuffer.length < 2) {
            throw new IllegalArgumentException("bytes.length must be at least 2");
        }
        return ByteUtil.getShort(apduBuffer, apduBuffer.length - 2);
    }

    public static void requireSW(byte[] apduBuffer, int expected) {
        int sw = ByteUtil.getSW(apduBuffer) & 0xFFFF;
        if (sw != expected) {
            throw new AssertionError((Object)String.format("Expected status word %x but got %x", expected, sw));
        }
    }

    public static short getShort(byte[] bArray, int offset) {
        return (short)(((short)bArray[offset] << 8) + ((short)bArray[offset + 1] & 0xFF));
    }

    private ByteUtil() {
    }
}

