/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.licel.jcardsim.crypto.RandomDataImpl;
import javacard.security.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RandomData {
    public static final byte ALG_PSEUDO_RANDOM = 1;
    public static final byte ALG_SECURE_RANDOM = 2;
    public static final byte ALG_TRNG = 3;
    public static final byte ALG_PRESEEDED_DRBG = 4;
    public static final byte ALG_FAST = 5;
    public static final byte ALG_KEYGENERATION = 6;

    protected RandomData() {
    }

    public abstract void generateData(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract short nextBytes(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract void setSeed(byte[] var1, short var2, short var3);

    public abstract byte getAlgorithm();

    public static RandomData getInstance(byte algorithm) throws CryptoException {
        RandomDataImpl instance = null;
        switch (algorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                instance = new RandomDataImpl(algorithm);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final class OneShot
    extends RandomData {
        private static final Logger log = LoggerFactory.getLogger(OneShot.class);
        private RandomData rnd;

        private OneShot() {
            log.debug("RandomData.OneShot");
        }

        public static OneShot open(byte algorithm) {
            OneShot one = new OneShot();
            one.rnd = RandomData.getInstance(algorithm);
            return one;
        }

        @Override
        public short nextBytes(byte[] buffer, short offset, short length) {
            return this.rnd.nextBytes(buffer, offset, length);
        }

        @Override
        public void setSeed(byte[] buffer, short offset, short length) {
            this.rnd.setSeed(buffer, offset, length);
        }

        @Override
        public byte getAlgorithm() {
            return this.rnd.getAlgorithm();
        }

        @Override
        public void generateData(byte[] buffer, short offset, short length) {
            this.rnd.generateData(buffer, offset, length);
        }

        public void close() {
            this.rnd = null;
        }
    }
}

