/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.adapters;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Supplier;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.EngineSession;
import pro.javacard.engine.adapters.AbstractTCPAdapter;
import pro.javacard.engine.adapters.RemoteMessage;

public final class JCSDKServer
extends AbstractTCPAdapter {
    private static final Logger log = LoggerFactory.getLogger(JCSDKServer.class);
    public static final int DEFAULT_JCSDK_PORT = 9025;
    public static final String DEFAULT_JCSDK_HOST = "0.0.0.0";
    ServerSocketChannel server;

    static ByteBuffer format(byte code, byte[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(4 + data.length);
        buffer.putInt(data.length);
        buffer.put(0, code);
        buffer.position(4);
        buffer.put(data);
        buffer.rewind();
        log.info(Hex.toHexString((byte[])buffer.array()));
        return buffer;
    }

    public JCSDKServer(Supplier<EngineSession> sim) {
        super(sim);
        this.host = DEFAULT_JCSDK_HOST;
        this.port = 9025;
    }

    @Override
    protected void start() throws IOException {
        this.server = JCSDKServer.start(this.host, this.port);
    }

    @Override
    protected RemoteMessage recv(SocketChannel channel) throws IOException {
        log.trace("Trying to read header ...");
        ByteBuffer hdr = ByteBuffer.allocate(4);
        int len = channel.read(hdr);
        if (len < 0) {
            log.info("Peer closed connection");
            throw new EOFException("Peer closed connection");
        }
        byte b1 = hdr.get(0);
        log.info("Received {}", (Object)Hex.toHexString((byte[])hdr.array()));
        switch (b1) {
            case -16: {
                return new RemoteMessage(RemoteMessage.Type.ATR);
            }
            case -2: {
                return new RemoteMessage(RemoteMessage.Type.POWERDOWN);
            }
            case 0: {
                int cmdlen = hdr.getInt(0);
                ByteBuffer cmd = ByteBuffer.allocate(cmdlen);
                channel.read(cmd);
                return new RemoteMessage(RemoteMessage.Type.APDU, cmd.array());
            }
        }
        throw new IOException("Unknown command header: %s" + Hex.toHexString((byte[])hdr.array()));
    }

    @Override
    protected void send(SocketChannel channel, RemoteMessage message) throws IOException {
        log.info("Sending " + String.valueOf((Object)message.getType()));
        switch (message.getType()) {
            case APDU: {
                channel.write(JCSDKServer.format((byte)0, message.getPayload()));
                break;
            }
            case ATR: {
                channel.write(JCSDKServer.format((byte)-16, this.atr));
                break;
            }
            case POWERDOWN: {
                channel.close();
                break;
            }
            default: {
                log.warn("Unknown message for protocol: " + String.valueOf((Object)message.getType()));
            }
        }
    }

    @Override
    protected SocketChannel getSocket() throws IOException {
        return this.server.accept();
    }
}

