/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.adapters;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.function.Supplier;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.EngineSession;
import pro.javacard.engine.adapters.AbstractTCPAdapter;
import pro.javacard.engine.adapters.RemoteMessage;

public final class VSmartCardClient
extends AbstractTCPAdapter {
    private static final Logger log = LoggerFactory.getLogger(VSmartCardClient.class);
    public static final int DEFAULT_VSMARTCARD_PORT = 35963;
    public static final String DEFAULT_VSMARTCARD_HOST = "127.0.0.1";

    public VSmartCardClient(Supplier<EngineSession> sim) {
        super(sim);
        this.port = 35963;
        this.host = DEFAULT_VSMARTCARD_HOST;
    }

    static ByteBuffer _send(byte[] data) throws IOException {
        if (data.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Too big payload");
        }
        ByteBuffer payload = ByteBuffer.allocate(2 + data.length);
        payload.putShort((short)data.length);
        payload.put(data);
        payload.rewind();
        return payload;
    }

    @Override
    protected void send(SocketChannel channel, RemoteMessage message) throws IOException {
        ByteBuffer msg;
        if (message.getType() != RemoteMessage.Type.ATR) {
            log.trace("Sending {}", (Object)message.getType());
        }
        switch (message.getType()) {
            case ATR: {
                msg = VSmartCardClient._send(this.atr);
                break;
            }
            case APDU: {
                msg = VSmartCardClient._send(message.getPayload());
                break;
            }
            default: {
                log.trace("Trying to send ignored message: " + String.valueOf((Object)message.getType()));
                return;
            }
        }
        if (message.getType() != RemoteMessage.Type.ATR) {
            log.trace("Sending {}", (Object)Hex.toHexString((byte[])msg.array()));
        }
        channel.write(msg);
    }

    @Override
    protected SocketChannel getSocket() throws IOException {
        return AbstractTCPAdapter.connect(this.host, this.port);
    }

    ByteBuffer _read(SocketChannel channel, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(len);
        int read = channel.read(buf);
        if (read == -1) {
            throw new EOFException("Peer is gone");
        }
        if (read != len) {
            throw new IOException("Could not read buffer: " + read);
        }
        buf.rewind();
        return buf;
    }

    @Override
    protected RemoteMessage recv(SocketChannel channel) throws IOException {
        ByteBuffer hdr = this._read(channel, 2);
        short len = hdr.getShort(0);
        if (len < 0) {
            throw new IOException("Received unexpected length: " + len);
        }
        if (len == 1) {
            ByteBuffer cmd = this._read(channel, 1);
            switch (cmd.get(0)) {
                case 0: {
                    return new RemoteMessage(RemoteMessage.Type.POWERDOWN);
                }
                case 1: {
                    return new RemoteMessage(RemoteMessage.Type.POWERUP);
                }
                case 2: {
                    return new RemoteMessage(RemoteMessage.Type.RESET);
                }
                case 4: {
                    return new RemoteMessage(RemoteMessage.Type.ATR);
                }
            }
            throw new IOException("Received unknown command: " + String.valueOf(cmd));
        }
        ByteBuffer apdu = this._read(channel, len);
        return new RemoteMessage(RemoteMessage.Type.APDU, apdu.array());
    }
}

