/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.NewByteArrayInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatingClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(IsolatingClassLoader.class);
    private final List<String> mocks = new ArrayList<String>();

    public void isolate(String ... packages) {
        for (String s : packages) {
            log.trace("Isolating {}", (Object)s);
            this.mocks.add(s);
        }
    }

    public IsolatingClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        String classpath = System.getProperty("java.class.path");
        for (String path : classpath.split(System.getProperty("path.separator"))) {
            try {
                log.trace("Adding {}", (Object)path);
                this.addURL(Paths.get(path, new String[0]).toUri().toURL());
            }
            catch (Exception e) {
                log.warn("Could not load {}: {}", new Object[]{path, e.getMessage(), e});
            }
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.isolate(name)) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                log.trace("{} isolating {}", (Object)System.identityHashCode(this), (Object)name);
                clazz = this.findClass(name);
            } else {
                log.trace("{} re-using  {}", (Object)System.identityHashCode(this), (Object)name);
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(name, resolve);
    }

    private byte[] getClassBytes(String name) throws IOException {
        String path = name.replace('.', '/') + ".class";
        try (InputStream is = this.getResourceAsStream(path);){
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.isolate(name)) {
            try {
                byte[] classBytes = this.getClassBytes(name);
                if (classBytes == null) {
                    log.error("Could not load {}", (Object)name);
                    throw new ClassNotFoundException(name);
                }
                byte[] transformedBytes = NewByteArrayInterceptor.transform(classBytes, this);
                return this.defineClass(name, transformedBytes, 0, transformedBytes.length, IsolatingClassLoader.class.getProtectionDomain());
            }
            catch (Exception e) {
                throw new ClassNotFoundException("Failed to load and transform class: " + name, e);
            }
        }
        return super.findClass(name);
    }

    private boolean isolate(String className) {
        return this.mocks.stream().anyMatch(className::startsWith);
    }
}

