/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import com.licel.jcardsim.crypto.AsymmetricSignatureImpl;
import com.licel.jcardsim.crypto.SymmetricSignatureImpl;
import java.lang.invoke.StringConcatFactory;
import javacard.security.CryptoException;
import javacard.security.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Signature {
    public static final byte ALG_DES_MAC4_NOPAD = 1;
    public static final byte ALG_DES_MAC8_NOPAD = 2;
    public static final byte ALG_DES_MAC4_ISO9797_M1 = 3;
    public static final byte ALG_DES_MAC8_ISO9797_M1 = 4;
    public static final byte ALG_DES_MAC4_ISO9797_M2 = 5;
    public static final byte ALG_DES_MAC8_ISO9797_M2 = 6;
    public static final byte ALG_DES_MAC4_PKCS5 = 7;
    public static final byte ALG_DES_MAC8_PKCS5 = 8;
    public static final byte ALG_RSA_SHA_ISO9796 = 9;
    public static final byte ALG_RSA_SHA_PKCS1 = 10;
    public static final byte ALG_RSA_MD5_PKCS1 = 11;
    public static final byte ALG_RSA_RIPEMD160_ISO9796 = 12;
    public static final byte ALG_RSA_RIPEMD160_PKCS1 = 13;
    public static final byte ALG_DSA_SHA = 14;
    public static final byte ALG_RSA_SHA_RFC2409 = 15;
    public static final byte ALG_RSA_MD5_RFC2409 = 16;
    public static final byte ALG_ECDSA_SHA = 17;
    public static final byte ALG_AES_MAC_128_NOPAD = 18;
    public static final byte ALG_AES_CMAC_128 = 49;
    public static final byte ALG_DES_MAC4_ISO9797_1_M2_ALG3 = 19;
    public static final byte ALG_DES_MAC8_ISO9797_1_M2_ALG3 = 20;
    public static final byte ALG_RSA_SHA_PKCS1_PSS = 21;
    public static final byte ALG_RSA_MD5_PKCS1_PSS = 22;
    public static final byte ALG_RSA_RIPEMD160_PKCS1_PSS = 23;
    public static final byte ALG_HMAC_SHA1 = 24;
    public static final byte ALG_HMAC_SHA_256 = 25;
    public static final byte ALG_HMAC_SHA_384 = 26;
    public static final byte ALG_HMAC_SHA_512 = 27;
    public static final byte ALG_HMAC_MD5 = 28;
    public static final byte ALG_HMAC_RIPEMD160 = 29;
    public static final byte ALG_RSA_SHA_ISO9796_MR = 30;
    public static final byte ALG_RSA_RIPEMD160_ISO9796_MR = 31;
    public static final byte ALG_KOREAN_SEED_MAC_NOPAD = 32;
    public static final byte ALG_ECDSA_SHA_256 = 33;
    public static final byte ALG_ECDSA_SHA_384 = 34;
    public static final byte ALG_AES_MAC_192_NOPAD = 35;
    public static final byte ALG_AES_MAC_256_NOPAD = 36;
    public static final byte ALG_ECDSA_SHA_224 = 37;
    public static final byte ALG_ECDSA_SHA_512 = 38;
    public static final byte ALG_RSA_SHA_224_PKCS1 = 39;
    public static final byte ALG_RSA_SHA_256_PKCS1 = 40;
    public static final byte ALG_RSA_SHA_384_PKCS1 = 41;
    public static final byte ALG_RSA_SHA_512_PKCS1 = 42;
    public static final byte ALG_RSA_SHA_224_PKCS1_PSS = 43;
    public static final byte ALG_RSA_SHA_256_PKCS1_PSS = 44;
    public static final byte ALG_RSA_SHA_384_PKCS1_PSS = 45;
    public static final byte ALG_RSA_SHA_512_PKCS1_PSS = 46;
    public static final byte ALG_DES_MAC4_ISO9797_1_M1_ALG3 = 47;
    public static final byte ALG_DES_MAC8_ISO9797_1_M1_ALG3 = 48;
    public static final byte SIG_CIPHER_DES_MAC4 = 1;
    public static final byte SIG_CIPHER_DES_MAC8 = 2;
    public static final byte SIG_CIPHER_RSA = 3;
    public static final byte SIG_CIPHER_DSA = 4;
    public static final byte SIG_CIPHER_ECDSA = 5;
    public static final byte SIG_CIPHER_ECDSA_PLAIN = 9;
    public static final byte SIG_CIPHER_AES_MAC128 = 6;
    public static final byte SIG_CIPHER_AES_CMAC128 = 10;
    public static final byte SIG_CIPHER_HMAC = 7;
    public static final byte SIG_CIPHER_KOREAN_SEED_MAC = 8;
    public static final byte MODE_SIGN = 1;
    public static final byte MODE_VERIFY = 2;
    private static final Logger log = LoggerFactory.getLogger(Signature.class);

    protected Signature() {
    }

    public abstract void init(Key var1, byte var2) throws CryptoException;

    public abstract void init(Key var1, byte var2, byte[] var3, short var4, short var5) throws CryptoException;

    public abstract void setInitialDigest(byte[] var1, short var2, short var3, byte[] var4, short var5, short var6) throws CryptoException;

    public abstract byte getAlgorithm();

    public abstract byte getMessageDigestAlgorithm();

    public abstract byte getCipherAlgorithm();

    public abstract byte getPaddingAlgorithm();

    public abstract short getLength() throws CryptoException;

    public abstract void update(byte[] var1, short var2, short var3) throws CryptoException;

    public abstract short sign(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract short signPreComputedHash(byte[] var1, short var2, short var3, byte[] var4, short var5) throws CryptoException;

    public abstract boolean verify(byte[] var1, short var2, short var3, byte[] var4, short var5, short var6) throws CryptoException;

    public abstract boolean verifyPreComputedHash(byte[] var1, short var2, short var3, byte[] var4, short var5, short var6) throws CryptoException;

    public static final Signature getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        Signature instance = null;
        switch (algorithm) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                try {
                    instance = new AsymmetricSignatureImpl(algorithm);
                }
                catch (Exception e) {
                    log.error((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"getInstance of asymmetric algo: \u0001 is NOT OK! : {}"}, (byte)algorithm)), (Object)e.getClass().getSimpleName());
                    CryptoException.throwIt((short)4);
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 49: {
                instance = new SymmetricSignatureImpl(algorithm);
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        return instance;
    }

    public static final Signature getInstance(byte messageDigestAlgorithm, byte cipherAlgorithm, byte paddingAlgorithm, boolean externalAccess) throws CryptoException {
        switch (cipherAlgorithm) {
            case 10: {
                if (messageDigestAlgorithm != 0) {
                    CryptoException.throwIt((short)3);
                }
                if (paddingAlgorithm != 3) {
                    CryptoException.throwIt((short)3);
                }
                return new SymmetricSignatureImpl(49);
            }
            case 5: {
                switch (messageDigestAlgorithm) {
                    case 4: {
                        return new AsymmetricSignatureImpl(33);
                    }
                    case 5: {
                        return new AsymmetricSignatureImpl(34);
                    }
                    case 6: {
                        return new AsymmetricSignatureImpl(38);
                    }
                }
                CryptoException.throwIt((short)3);
            }
        }
        CryptoException.throwIt((short)3);
        log.error("Not reachable.");
        return null;
    }

    public static final class OneShot
    extends Signature {
        private static final Logger log = LoggerFactory.getLogger(OneShot.class);
        private Signature signature;

        private OneShot() {
            log.debug("Signature.OneShot");
        }

        public static OneShot open(byte messageDigestAlgorithm, byte cipherAlgorithm, byte paddingAlgorithm) {
            OneShot one = new OneShot();
            one.signature = Signature.getInstance(messageDigestAlgorithm, cipherAlgorithm, paddingAlgorithm, false);
            return one;
        }

        @Override
        public void init(Key key, byte b) throws CryptoException {
            this.signature.init(key, b);
        }

        @Override
        public void init(Key key, byte b, byte[] bytes, short i, short i1) throws CryptoException {
            this.signature.init(key, b, bytes, i, i1);
        }

        @Override
        public void setInitialDigest(byte[] bytes, short i, short i1, byte[] bytes1, short i2, short i3) throws CryptoException {
            this.signature.setInitialDigest(bytes, i, i1, bytes1, i2, i3);
        }

        @Override
        public byte getAlgorithm() {
            return this.signature.getAlgorithm();
        }

        @Override
        public byte getMessageDigestAlgorithm() {
            return this.signature.getMessageDigestAlgorithm();
        }

        @Override
        public byte getCipherAlgorithm() {
            return this.signature.getCipherAlgorithm();
        }

        @Override
        public byte getPaddingAlgorithm() {
            return this.signature.getPaddingAlgorithm();
        }

        @Override
        public short getLength() throws CryptoException {
            return this.signature.getLength();
        }

        @Override
        public void update(byte[] bytes, short i, short i1) throws CryptoException {
            CryptoException.throwIt((short)5);
        }

        @Override
        public short sign(byte[] bytes, short i, short i1, byte[] bytes1, short i2) throws CryptoException {
            return this.signature.sign(bytes, i, i1, bytes1, i2);
        }

        @Override
        public short signPreComputedHash(byte[] bytes, short i, short i1, byte[] bytes1, short i2) throws CryptoException {
            return this.signature.signPreComputedHash(bytes, i, i1, bytes1, i2);
        }

        @Override
        public boolean verify(byte[] bytes, short i, short i1, byte[] bytes1, short i2, short i3) throws CryptoException {
            return this.signature.verify(bytes, i, i1, bytes1, i2, i3);
        }

        @Override
        public boolean verifyPreComputedHash(byte[] bytes, short i, short i1, byte[] bytes1, short i2, short i3) throws CryptoException {
            return this.signature.verifyPreComputedHash(bytes, i, i1, bytes1, i2, i3);
        }

        public void close() {
            this.signature = null;
        }
    }
}

