/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.SymmetricKeyImpl;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacardx.crypto.AEADCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedSymmetricCipherImpl
extends AEADCipher {
    private static final Logger log = LoggerFactory.getLogger(AuthenticatedSymmetricCipherImpl.class);
    byte algorithm;
    AEADBlockCipher engine;
    AEADParameters parameters;
    CipherState state;
    byte initMode;
    short initMsgLen;
    short totalMsgLen;
    short initAADLen;

    public AuthenticatedSymmetricCipherImpl(byte algorithm) {
        this.algorithm = algorithm;
        this.state = CipherState.Uninitialized;
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte getCipherAlgorithm() {
        switch (this.algorithm) {
            case -12: {
                return -14;
            }
            case -13: {
                return -15;
            }
        }
        return 0;
    }

    @Override
    public byte getPaddingAlgorithm() {
        return 0;
    }

    @Override
    public void init(Key theKey, byte theMode) throws CryptoException {
        if (this.algorithm != -13) {
            CryptoException.throwIt((short)4);
        }
        if (theMode != 1 && theMode != 2) {
            CryptoException.throwIt((short)1);
        }
        byte[] iv = new byte[12];
        Arrays.fill((byte[])iv, (byte)0);
        this.selectCipherEngine(theKey);
        ParametersWithIV parametersWithIV = new ParametersWithIV(((SymmetricKeyImpl)theKey).getParameters(), iv);
        try {
            this.engine.init(theMode == 2, (CipherParameters)parametersWithIV);
        }
        catch (Exception ex) {
            log.trace(ex.getMessage(), (Throwable)ex);
            CryptoException.throwIt((short)1);
        }
        this.initMode = theMode;
        this.state = CipherState.Initialized;
    }

    @Override
    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        if (this.algorithm != -13) {
            CryptoException.throwIt((short)4);
        }
        if (theMode != 1 && theMode != 2) {
            CryptoException.throwIt((short)1);
        }
        if (bLen != 12) {
            CryptoException.throwIt((short)1);
        }
        this.selectCipherEngine(theKey);
        byte[] iv = JCSystem.makeTransientByteArray(bLen, (byte)1);
        Util.arrayCopyNonAtomic(bArray, bOff, iv, (short)0, bLen);
        ParametersWithIV parametersWithIV = new ParametersWithIV(((SymmetricKeyImpl)theKey).getParameters(), iv);
        try {
            this.engine.init(theMode == 2, (CipherParameters)parametersWithIV);
        }
        catch (Exception ex) {
            log.trace(ex.getMessage(), (Throwable)ex);
            CryptoException.throwIt((short)1);
        }
        this.initMode = theMode;
        this.state = CipherState.Initialized;
    }

    @Override
    public void init(Key theKey, byte theMode, byte[] nonceBuf, short nonceOff, short nonceLen, short adataLen, short messageLen, short tagSize) throws CryptoException {
        if (theMode != 1 && theMode != 2) {
            CryptoException.throwIt((short)1);
        }
        if (messageLen == 0 || tagSize == 0) {
            CryptoException.throwIt((short)4);
        }
        if (nonceLen != 12) {
            CryptoException.throwIt((short)1);
        }
        this.selectCipherEngine(theKey);
        byte[] iv_nonce = JCSystem.makeTransientByteArray(nonceLen, (byte)1);
        Util.arrayCopyNonAtomic(nonceBuf, nonceOff, iv_nonce, (short)0, nonceLen);
        this.parameters = new AEADParameters((KeyParameter)((SymmetricKeyImpl)theKey).getParameters(), tagSize * 8, iv_nonce);
        try {
            this.engine.init(theMode == 2, (CipherParameters)this.parameters);
        }
        catch (Exception ex) {
            log.trace(ex.getMessage(), (Throwable)ex);
            CryptoException.throwIt((short)1);
        }
        this.initMode = theMode;
        this.initMsgLen = messageLen;
        this.initAADLen = adataLen;
        this.totalMsgLen = 0;
        this.state = CipherState.Initialized;
    }

    @Override
    public void updateAAD(byte[] aadBuf, short aadOff, short aadLen) throws CryptoException {
        if (this.state == CipherState.Uninitialized) {
            CryptoException.throwIt((short)5);
        }
        if (this.algorithm == -12 && aadLen != this.initAADLen) {
            CryptoException.throwIt((short)1);
        }
        this.engine.processAADBytes(aadBuf, (int)aadOff, (int)aadLen);
    }

    @Override
    public short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (this.state == CipherState.Uninitialized) {
            CryptoException.throwIt((short)4);
        }
        int processBuffSize = this.engine.getUpdateOutputSize((int)inLength);
        byte[] processBuff = new byte[processBuffSize];
        short processedBytes = (short)this.engine.processBytes(inBuff, (int)inOffset, (int)inLength, processBuff, 0);
        Util.arrayCopyNonAtomic(processBuff, (short)0, outBuff, outOffset, processedBytes);
        this.totalMsgLen = (short)(this.totalMsgLen + inLength);
        return processedBytes;
    }

    @Override
    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (this.state == CipherState.Uninitialized) {
            CryptoException.throwIt((short)4);
        }
        if (this.algorithm == -12) {
            if (this.engine.getMac().length == 0) {
                CryptoException.throwIt((short)5);
            }
            this.totalMsgLen = (short)(this.totalMsgLen + inLength);
            if (this.totalMsgLen != this.initMsgLen) {
                CryptoException.throwIt((short)5);
            }
        }
        int processBuffSize = this.engine.getOutputSize((int)inLength);
        byte[] processBuff = new byte[processBuffSize];
        try {
            short processedBytes = (short)this.engine.processBytes(inBuff, (int)inOffset, (int)inLength, processBuff, 0);
            processedBytes = (short)(processedBytes + this.engine.doFinal(processBuff, (int)processedBytes));
            Util.arrayCopyNonAtomic(processBuff, (short)0, outBuff, outOffset, processedBytes);
            this.state = CipherState.Finalized;
            return processedBytes;
        }
        catch (Exception ex) {
            log.trace(ex.getMessage(), (Throwable)ex);
            CryptoException.throwIt((short)5);
            return -1;
        }
    }

    @Override
    public short retrieveTag(byte[] tagBuf, short tagOff, short tagLen) throws CryptoException {
        if (this.state != CipherState.Finalized) {
            CryptoException.throwIt((short)5);
        }
        if (this.initMode != 2) {
            CryptoException.throwIt((short)5);
        }
        if (!this.checkSupportTagLength(tagLen)) {
            CryptoException.throwIt((short)1);
        }
        byte[] mac = this.engine.getMac();
        Util.arrayCopyNonAtomic(mac, (short)0, tagBuf, tagOff, tagLen);
        return tagLen;
    }

    @Override
    public boolean verifyTag(byte[] receivedTagBuf, short receivedTagOff, short receivedTagLen, short requiredTagLen) throws CryptoException {
        if (this.state != CipherState.Finalized) {
            CryptoException.throwIt((short)5);
        }
        if (this.initMode != 1) {
            CryptoException.throwIt((short)5);
        }
        if (!this.checkSupportTagLength(requiredTagLen)) {
            CryptoException.throwIt((short)1);
        }
        byte[] mac = this.engine.getMac();
        return Arrays.areEqual((byte[])mac, (int)0, (int)requiredTagLen, (byte[])receivedTagBuf, (int)receivedTagOff, (int)(receivedTagOff + receivedTagLen));
    }

    private void selectCipherEngine(Key theKey) {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof SymmetricKeyImpl)) {
            CryptoException.throwIt((short)1);
        }
        SymmetricKeyImpl key = (SymmetricKeyImpl)theKey;
        switch (this.algorithm) {
            case -12: {
                try {
                    this.engine = CCMBlockCipher.newInstance((BlockCipher)key.getCipher());
                }
                catch (Exception ex) {
                    log.trace(ex.getMessage(), (Throwable)ex);
                    CryptoException.throwIt((short)1);
                }
                break;
            }
            case -13: {
                try {
                    this.engine = GCMBlockCipher.newInstance((BlockCipher)key.getCipher());
                }
                catch (Exception ex) {
                    log.trace(ex.getMessage(), (Throwable)ex);
                    CryptoException.throwIt((short)1);
                }
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }

    private boolean checkSupportTagLength(short tagLen) {
        short tagLenInBits = (short)(tagLen * 8);
        switch (tagLenInBits) {
            case 32: 
            case 64: 
            case 96: 
            case 104: 
            case 112: 
            case 120: 
            case 128: {
                return true;
            }
        }
        return false;
    }

    static enum CipherState {
        Uninitialized,
        Initialized,
        Finalized;

    }
}

