/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.DHKeyImpl;
import javacard.security.CryptoException;
import javacard.security.DHPrivateKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DHKeyParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;

public final class DHPrivateKeyImpl
extends DHKeyImpl
implements DHPrivateKey {
    protected ByteContainer x = new ByteContainer();

    public DHPrivateKeyImpl(short size) {
        this.size = size;
        this.type = (byte)35;
    }

    public DHPrivateKeyImpl(DHKeyParameters params) {
        this.setParameters((CipherParameters)params);
    }

    @Override
    public void setParameters(CipherParameters params) {
        super.setParameters((CipherParameters)((DHPrivateKeyParameters)params).getParameters());
        this.x.setBigInteger(((DHPrivateKeyParameters)params).getX());
    }

    @Override
    public void setX(byte[] bytes, short offset, short length) throws CryptoException {
        this.x.setBytes(bytes, offset, length);
    }

    @Override
    public short getX(byte[] bytes, short offset) {
        return this.x.getBytes(bytes, offset);
    }

    @Override
    public void clearKey() {
        super.clearKey();
        this.x.clear();
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized() && this.x.isInitialized();
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        return new DHPrivateKeyParameters(this.x.getBigInteger(), (DHParameters)super.getParameters());
    }
}

