/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.DHKeyImpl;
import com.licel.jcardsim.crypto.DSAKeyImpl;
import com.licel.jcardsim.crypto.ECKeyImpl;
import com.licel.jcardsim.crypto.KeyImpl;
import com.licel.jcardsim.crypto.KeyWithParameters;
import com.licel.jcardsim.crypto.RSAKeyImpl;
import com.licel.jcardsim.crypto.SecureRandomNullProvider;
import java.security.SecureRandom;
import javacard.security.CryptoException;
import javacard.security.KeyBuilder;
import javacard.security.PrivateKey;
import javacard.security.PublicKey;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;

public final class KeyPairImpl {
    byte algorithm;
    short keyLength;
    AsymmetricCipherKeyPairGenerator engine;
    PrivateKey privateKey;
    PublicKey publicKey;
    SecureRandom rnd = new SecureRandomNullProvider();
    KeyGenerationParameters keyGenerationParameters;

    public void genKeyPair() throws CryptoException {
        this.initEngine();
        this.createKeys();
        AsymmetricCipherKeyPair kp = this.engine.generateKeyPair();
        ((KeyWithParameters)((Object)this.publicKey)).setParameters((CipherParameters)kp.getPublic());
        ((KeyWithParameters)((Object)this.privateKey)).setParameters((CipherParameters)kp.getPrivate());
    }

    public KeyPairImpl(byte algorithm, short keyLength) throws CryptoException {
        this.algorithm = algorithm;
        this.keyLength = keyLength;
        this.createKeys();
    }

    public KeyPairImpl(PublicKey publicKey, PrivateKey privateKey) throws CryptoException {
        if (publicKey == null && privateKey == null) {
            CryptoException.throwIt((short)1);
        }
        if (publicKey != null && !(publicKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        this.publicKey = publicKey;
        if (this.publicKey != null) {
            this.selectAlgorithmByType(this.publicKey.getType());
        }
        if (privateKey != null && !(privateKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        this.privateKey = privateKey;
        if (this.privateKey != null) {
            this.selectAlgorithmByType(this.privateKey.getType());
        }
    }

    public PublicKey getPublic() {
        return this.publicKey;
    }

    public PrivateKey getPrivate() {
        return this.privateKey;
    }

    private void selectAlgorithmByType(byte keyType) {
        switch (keyType) {
            case 4: 
            case 5: {
                this.algorithm = 1;
                break;
            }
            case 6: {
                this.algorithm = (byte)2;
                break;
            }
            case 9: 
            case 10: {
                this.algorithm = (byte)4;
                break;
            }
            case 11: 
            case 12: {
                this.algorithm = (byte)5;
                break;
            }
            case 7: 
            case 8: {
                this.algorithm = (byte)3;
                break;
            }
            case 32: 
            case 35: {
                this.algorithm = (byte)6;
                break;
            }
            default: {
                CryptoException.throwIt((short)1);
            }
        }
    }

    private void initEngine() {
        if (this.publicKey != null) {
            this.keyGenerationParameters = ((KeyImpl)((Object)this.publicKey)).getKeyGenerationParameters(this.rnd);
        }
        switch (this.algorithm) {
            case 1: 
            case 2: {
                if (this.keyGenerationParameters == null) {
                    this.keyGenerationParameters = RSAKeyImpl.getDefaultKeyGenerationParameters(this.keyLength, this.rnd);
                }
                this.engine = new RSAKeyPairGenerator();
                break;
            }
            case 3: {
                if (this.keyLength < 512 || this.keyLength > 1024 || this.keyLength % 64 != 0) {
                    CryptoException.throwIt((short)1);
                }
                if (this.keyGenerationParameters == null) {
                    this.keyGenerationParameters = DSAKeyImpl.getDefaultKeyGenerationParameters(this.keyLength, this.rnd);
                }
                this.engine = new DSAKeyPairGenerator();
                break;
            }
            case 4: 
            case 5: {
                if (this.keyGenerationParameters == null) {
                    this.keyGenerationParameters = ECKeyImpl.getDefaultKeyGenerationParameters(this.algorithm, this.keyLength, this.rnd);
                }
                this.engine = new ECKeyPairGenerator();
                break;
            }
            case 6: {
                if (this.keyGenerationParameters == null) {
                    this.keyGenerationParameters = DHKeyImpl.getDefaultKeyGenerationParameters(this.keyLength, this.rnd);
                }
                this.engine = new DHKeyPairGenerator();
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        this.engine.init(this.keyGenerationParameters);
    }

    private void createKeys() {
        byte privateKeyType = 0;
        byte publicKeyType = 0;
        switch (this.algorithm) {
            case 1: {
                publicKeyType = 4;
                privateKeyType = 5;
                break;
            }
            case 2: {
                publicKeyType = 4;
                privateKeyType = 6;
                break;
            }
            case 5: {
                publicKeyType = 11;
                privateKeyType = 12;
                break;
            }
            case 4: {
                publicKeyType = 9;
                privateKeyType = 10;
                break;
            }
            case 3: {
                publicKeyType = 7;
                privateKeyType = 8;
                break;
            }
            case 6: {
                publicKeyType = 32;
                privateKeyType = 35;
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
        if (this.publicKey != null && this.keyLength == 0) {
            this.keyLength = this.publicKey.getSize();
        }
        if (this.publicKey == null) {
            this.publicKey = (PublicKey)KeyBuilder.buildKey(publicKeyType, this.keyLength, false);
        }
        if (this.privateKey == null) {
            this.privateKey = (PrivateKey)KeyBuilder.buildKey(privateKeyType, this.keyLength, false);
        }
    }
}

