/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.smartcardio;

import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.smartcardio.CardTerminalSimulator;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import pro.javacard.engine.EngineSession;

public class CardSimulator
extends Simulator {
    private final CardImpl card = new CardImpl();
    private final AtomicReference<CardTerminal> owningCardTerminalReference = new AtomicReference();
    private final AtomicReference<Thread> threadReference = new AtomicReference();

    public ResponseAPDU transmitCommand(CommandAPDU commandApdu) {
        try (EngineSession session = this.connect();){
            ResponseAPDU responseAPDU = new ResponseAPDU(session.transmitCommand(commandApdu.getBytes()));
            return responseAPDU;
        }
    }

    public synchronized void assignToTerminal(CardTerminal terminal) {
        CardTerminal oldCardTerminal = this.owningCardTerminalReference.getAndSet(terminal);
        if (terminal == oldCardTerminal) {
            return;
        }
        if (oldCardTerminal != null) {
            ((CardTerminalSimulator.CardTerminalImpl)oldCardTerminal).assignSimulator(null);
        }
        if (terminal != null) {
            this.card.disconnect();
            ((CardTerminalSimulator.CardTerminalImpl)terminal).assignSimulator(this);
        }
    }

    public CardTerminal getAssignedCardTerminal() {
        return this.owningCardTerminalReference.get();
    }

    final Card internalConnect(String protocol) {
        this.card.connect(protocol);
        return this.card;
    }

    final void internalEject(CardTerminal oldTerminal) {
        if (this.owningCardTerminalReference.compareAndSet(oldTerminal, null)) {
            this.card.eject();
        }
    }

    private final class CardImpl
    extends Card {
        private final CardChannel basicChannel;
        private volatile String protocol = "T=0";
        private volatile CardState state = CardState.Connected;
        private EngineSession session = null;

        CardImpl() {
            this.basicChannel = new CardChannelImpl(this, 0);
        }

        void ensureConnected() {
            CardState cardState = this.state;
            if (cardState == CardState.Disconnected) {
                throw new IllegalStateException("Card was disconnected");
            }
            if (cardState == CardState.Ejected) {
                throw new IllegalStateException("Card was removed");
            }
        }

        @Override
        public ATR getATR() {
            return new ATR(CardSimulator.this.getATR());
        }

        @Override
        public String getProtocol() {
            return this.protocol;
        }

        @Override
        public CardChannel getBasicChannel() {
            return this.basicChannel;
        }

        @Override
        public CardChannel openLogicalChannel() throws CardException {
            throw new CardException("Logical channel not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beginExclusive() throws CardException {
            CardSimulator cardSimulator = CardSimulator.this;
            synchronized (cardSimulator) {
                if (!CardSimulator.this.threadReference.compareAndSet(null, Thread.currentThread())) {
                    throw new CardException("Card is held exclusively by Thread " + String.valueOf(CardSimulator.this.threadReference.get()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endExclusive() throws CardException {
            CardSimulator cardSimulator = CardSimulator.this;
            synchronized (cardSimulator) {
                if (!CardSimulator.this.threadReference.compareAndSet(Thread.currentThread(), null)) {
                    throw new CardException("Card is held exclusively by Thread " + String.valueOf(CardSimulator.this.threadReference.get()));
                }
            }
        }

        @Override
        public byte[] transmitControlCommand(int i, byte[] bytes) throws CardException {
            throw new CardException("Control commands not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect(boolean reset) throws CardException {
            CardSimulator cardSimulator = CardSimulator.this;
            synchronized (cardSimulator) {
                this.session.close(reset);
                this.state = CardState.Disconnected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void connect(String protocol) {
            CardSimulator cardSimulator = CardSimulator.this;
            synchronized (cardSimulator) {
                this.session = CardSimulator.this.connect(protocol);
                this.protocol = protocol;
                this.state = CardState.Connected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void eject() {
            CardSimulator cardSimulator = CardSimulator.this;
            synchronized (cardSimulator) {
                CardSimulator.this.reset();
                this.state = CardState.Ejected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnect() {
            CardSimulator cardSimulator = CardSimulator.this;
            synchronized (cardSimulator) {
                CardSimulator.this.reset();
                this.state = CardState.Disconnected;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] transmitCommand(byte[] capdu) throws CardException {
            CardSimulator cardSimulator = CardSimulator.this;
            synchronized (cardSimulator) {
                this.ensureConnected();
                Thread thread = CardSimulator.this.threadReference.get();
                if (thread != null && thread != Thread.currentThread()) {
                    throw new CardException("Card is held exclusively by Thread " + thread.getName());
                }
                return this.session.transmitCommand(capdu);
            }
        }
    }

    private static final class CardChannelImpl
    extends CardChannel {
        private final CardImpl card;
        private final int channelNr;

        public CardChannelImpl(CardImpl card, int channelNr) {
            this.card = card;
            this.channelNr = channelNr;
        }

        @Override
        public Card getCard() {
            return this.card;
        }

        @Override
        public int getChannelNumber() {
            this.card.ensureConnected();
            return this.channelNr;
        }

        @Override
        public ResponseAPDU transmit(CommandAPDU commandAPDU) throws CardException {
            return new ResponseAPDU(this.card.transmitCommand(commandAPDU.getBytes()));
        }

        @Override
        public int transmit(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws CardException {
            byte[] result = this.card.transmitCommand(new CommandAPDU(byteBuffer).getBytes());
            byteBuffer2.put(result);
            return result.length;
        }

        @Override
        public void close() throws CardException {
            throw new CardException("Can not close basic channel");
        }
    }

    private static enum CardState {
        Connected,
        Disconnected,
        Ejected;

    }
}

