/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javacard.framework.AID;
import org.bouncycastle.util.encoders.Hex;

public final class AIDUtil {
    private static final Comparator<AID> aidComparator = (aid1, aid2) -> {
        String s1 = aid1 != null ? AIDUtil.toString(aid1) : "";
        String s2 = aid1 != null ? AIDUtil.toString(aid2) : "";
        return s1.compareTo(s2);
    };

    public static byte[] select(AID aid) {
        Objects.requireNonNull(aid);
        byte[] bytes = AIDUtil.bytes(aid);
        byte[] selectCmd = new byte[bytes.length + 5 + 1];
        selectCmd[0] = 0;
        selectCmd[1] = -92;
        selectCmd[2] = 4;
        selectCmd[3] = 0;
        selectCmd[4] = (byte)bytes.length;
        System.arraycopy(bytes, 0, selectCmd, 5, bytes.length);
        selectCmd[selectCmd.length - 1] = 0;
        return selectCmd;
    }

    public static AID create(byte[] aidBytes) {
        Objects.requireNonNull(aidBytes);
        if (aidBytes.length < 5 || aidBytes.length > 16) {
            throw new IllegalArgumentException("AID size must be between 5 and 16 but was " + aidBytes.length);
        }
        return new AID(aidBytes, 0, (byte)aidBytes.length);
    }

    public static AID create(String aidString) {
        Objects.requireNonNull(aidString);
        return AIDUtil.create(Hex.decode((String)aidString));
    }

    public static String toString(AID aid) {
        Objects.requireNonNull(aid);
        return Hex.toHexString((byte[])AIDUtil.bytes(aid));
    }

    public static byte[] bytes(AID aid) {
        byte[] buffer = new byte[16];
        short len = aid.getBytes(buffer, (short)0);
        return Arrays.copyOf(buffer, (int)len);
    }

    public static Comparator<AID> comparator() {
        return aidComparator;
    }

    private AIDUtil() {
    }
}

