/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.globalplatform;

import com.licel.jcardsim.base.Simulator;
import com.licel.jcardsim.utils.AIDUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.ISOException;
import javacard.framework.Util;
import org.bouncycastle.util.encoders.Hex;
import org.globalplatform.GPSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPlatformApplet
extends Applet {
    private static final Logger log = LoggerFactory.getLogger(GlobalPlatformApplet.class);
    byte[] FCI = Hex.decode((String)"6F108408A000000151000000A5049F6501FF");
    public static AID OPEN_AID = AIDUtil.create("A000000151000000");

    public static void install(byte[] bArray, short bOffset, byte bLength) throws ISOException {
        short offset = bOffset;
        offset = (short)(offset + (short)(bArray[offset] + 1));
        offset = (short)(offset + (short)(bArray[offset] + 1));
        GlobalPlatformApplet applet = new GlobalPlatformApplet(bArray, (short)(offset + 1), bArray[offset]);
        applet.register(bArray, (short)(bOffset + 1), bArray[bOffset]);
    }

    private GlobalPlatformApplet(byte[] parameters, short parametersOffset, byte parametersLength) {
    }

    @Override
    public void process(APDU apdu) throws ISOException {
        byte[] buffer = apdu.getBuffer();
        if (this.selectingApplet()) {
            Util.arrayCopyNonAtomic(this.FCI, (short)0, buffer, (short)0, (short)this.FCI.length);
            apdu.setOutgoingAndSend((short)0, (short)this.FCI.length);
            return;
        }
        if (buffer[1] == 80 || buffer[1] == -126) {
            short len = GPSystem.getSecureChannel().processSecurity(apdu);
            apdu.setOutgoingAndSend((short)5, len);
            return;
        }
        if ((GPSystem.getSecureChannel().getSecurityLevel() & 0xFFFFFF80) == -128) {
            short len = apdu.setIncomingAndReceive();
            GPSystem.getSecureChannel().unwrap(buffer, (short)0, (short)(5 + len));
            byte[] payload = Arrays.copyOfRange(buffer, 5, 5 + buffer[4]);
            System.err.println("payload: " + Hex.toHexString((byte[])payload));
            if (buffer[1] == -26) {
                List<byte[]> cmd = GlobalPlatformApplet.parse_lv(payload);
                GlobalPlatformApplet.dump_lv(cmd);
                AID pkg = AIDUtil.create(cmd.get(0));
                AID app = AIDUtil.create(cmd.get(1));
                AID instanceaid = AIDUtil.create(cmd.get(2));
                byte[] parameters = cmd.get(4);
                Class<? extends Applet> appletClass = Simulator.current().getGlobalPlatform().locateApplet(pkg, app);
                if (appletClass == null) {
                    log.warn("Applet not found");
                    ISOException.throwIt((short)27264);
                }
                Simulator.current().internalInstallApplet(instanceaid, appletClass, parameters, true);
                buffer[0] = 0;
                apdu.setOutgoingAndSend((short)0, (short)1);
                return;
            }
            if (buffer[1] == -28) {
                AID aid = AIDUtil.create(Arrays.copyOfRange(payload, 2, payload.length));
                try {
                    Simulator.current().internalDeleteApplet(aid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buffer[0] = 0;
                apdu.setOutgoingAndSend((short)0, (short)1);
                return;
            }
        }
        ISOException.throwIt((short)27904);
    }

    static List<byte[]> parse_lv(byte[] data) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        ByteBuffer bb = ByteBuffer.wrap(data);
        while (bb.position() < bb.limit()) {
            int len = bb.get() & 0xFF;
            byte[] value = new byte[len];
            bb.get(value);
            result.add(value);
        }
        return result;
    }

    static void dump_lv(List<byte[]> lv) {
        for (byte[] f : lv) {
            log.info("[0x%02X] %s".formatted(f.length, Hex.toHexString((byte[])f)));
        }
    }
}

