/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import com.licel.jcardsim.base.APDUHelper;
import com.licel.jcardsim.base.ApplicationInstance;
import com.licel.jcardsim.base.CardInterface;
import com.licel.jcardsim.base.CurrentAPDU;
import com.licel.jcardsim.base.Helpers;
import com.licel.jcardsim.base.IsolatingClassLoader;
import com.licel.jcardsim.base.JavaCardRuntime;
import com.licel.jcardsim.base.SimulatorSession;
import com.licel.jcardsim.base.TransientMemory;
import com.licel.jcardsim.utils.AIDUtil;
import com.licel.jcardsim.utils.ByteUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import javacard.framework.AID;
import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.AppletEvent;
import javacard.framework.ISOException;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.Util;
import javacardx.apdu.ExtendedLength;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.EngineSession;
import pro.javacard.engine.JavaCardEngine;
import pro.javacard.engine.JavaCardEngineException;
import pro.javacard.engine.globalplatform.GlobalPlatform;
import pro.javacard.engine.globalplatform.GlobalPlatformApplet;

public class Simulator
implements CardInterface,
JavaCardEngine,
JavaCardRuntime {
    private static final Logger log;
    public static final String DEFAULT_ATR = "3B80800101";
    public static final boolean OBJECT_DELETION_SUPPORTED = true;
    private static final ThreadLocal<Simulator> currentSimulator;
    private IsolatingClassLoader classLoader = new IsolatingClassLoader(this.getClass().getClassLoader());
    private static final ThreadLocal<RegisterCallbackOptions> options;
    final Semaphore lock = new Semaphore(1, true);
    final Thread creator = Thread.currentThread();
    private boolean exposed = false;
    protected final SortedMap<AID, ApplicationInstance> applets = new TreeMap<AID, ApplicationInstance>(AIDUtil.comparator());
    protected final byte[] responseBuffer = new byte[32769];
    protected short responseBufferSize = 0;
    protected final TransientMemory transientMemory = new TransientMemory();
    private final GlobalPlatform globalPlatform = new GlobalPlatform();
    private final CurrentAPDU currentAPDU = new CurrentAPDU();
    protected AID currentAID;
    protected AID previousAID;
    protected boolean selecting = false;
    protected byte transactionDepth = 0;
    int bytesAllocated;

    public void _makeCurrent() {
        currentSimulator.set(this);
    }

    public void _releaseCurrent() {
        currentSimulator.remove();
    }

    @Override
    public CurrentAPDU getCurrentAPDU() {
        return this.currentAPDU;
    }

    public static JavaCardRuntime current() {
        Simulator currentInstance = currentSimulator.get();
        if (currentInstance == null) {
            throw new IllegalStateException("No current Engine instance");
        }
        return currentInstance;
    }

    @Override
    public AID installApplet(AID aid, Class<? extends Applet> appletClass, byte[] parameters) throws SystemException {
        if (this.creator != Thread.currentThread()) {
            log.error("Do not call from a different thread.");
        }
        return this.installApplet(aid, appletClass, parameters, this.exposed);
    }

    @Override
    public AID installExposedApplet(AID aid, Class<? extends Applet> appletClass, byte[] params) {
        return this.installApplet(aid, appletClass, params, true);
    }

    public boolean selectApplet(AID aid) throws SystemException {
        byte[] resp = this.selectAppletWithResult(aid);
        return ByteUtil.getSW(resp) == -28672;
    }

    public byte[] selectAppletWithResult(AID aid) throws SystemException {
        return this._transmitCommand((byte)0, AIDUtil.select(aid));
    }

    public byte[] getATR() {
        return Hex.decode((String)DEFAULT_ATR);
    }

    @Override
    public AID getAID() {
        return this.currentAID;
    }

    @Override
    public AID lookupAID(byte[] buffer, short offset, byte length) {
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(buffer, offset, length)) continue;
            return aid;
        }
        return null;
    }

    public ApplicationInstance lookupApplet(AID lookupAid) {
        log.trace("Searching registry for {}", (Object)(lookupAid == null ? null : AIDUtil.toString(lookupAid)));
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(lookupAid)) continue;
            return (ApplicationInstance)this.applets.get(aid);
        }
        log.warn("Application with AID {} not found", (Object)AIDUtil.toString(lookupAid));
        return null;
    }

    @Override
    public AID getPreviousContextAID() {
        return this.previousAID;
    }

    @Override
    public Applet getApplet(AID aid) {
        Objects.requireNonNull(aid);
        ApplicationInstance a = this.lookupApplet(aid);
        if (a == null) {
            return null;
        }
        return a.getApplet();
    }

    @Override
    public void internalDeleteApplet(AID aid) {
        log.info("Deleting applet {}", (Object)AIDUtil.toString(aid));
        ApplicationInstance app = this.lookupApplet(aid);
        if (app == null) {
            throw new IllegalArgumentException("Applet with AID " + AIDUtil.toString(aid) + " not found");
        }
        Applet applet = app.getApplet();
        if (applet instanceof AppletEvent) {
            try {
                ((AppletEvent)((Object)applet)).uninstall();
            }
            catch (Exception e) {
                this.applets.remove(aid);
                throw new JavaCardEngineException("uninstall() failed", e);
            }
        }
        this.applets.remove(aid);
    }

    @Override
    public void deleteApplet(AID aid) {
        if (this.creator != Thread.currentThread()) {
            log.error("Do not call from a different thread.");
        }
        this._makeCurrent();
        try {
            if (this.currentAID != null) {
                this.deselect(this.lookupApplet(this.currentAID));
            }
            this.internalDeleteApplet(aid);
            this.currentAID = null;
        }
        finally {
            this._releaseCurrent();
        }
    }

    @Override
    public boolean isAppletSelecting(Object aThis) {
        return this.selecting;
    }

    @Override
    public byte[] transmitCommand(byte[] command) throws SystemException {
        if (this.creator != Thread.currentThread()) {
            log.error("Do not call from a different thread.");
        }
        try (EngineSession session = this.connect();){
            byte[] byArray = session.transmitCommand(command);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] _transmitCommand(byte protocol, byte[] command) throws SystemException {
        this._makeCurrent();
        try {
            byte[] response;
            Applet applet;
            AID newAid;
            log.trace("APDU: {}", (Object)Hex.toHexString((byte[])command));
            int apduCase = APDUHelper.getAPDUCase(command);
            byte[] theSW = new byte[2];
            this.selecting = false;
            if (!APDUHelper.isExtendedAPDU(apduCase) && Simulator.isAppletSelectionApdu(command)) {
                log.trace("Current AID {}, looking up applet ...", this.currentAID == null ? null : AIDUtil.toString(this.currentAID));
                newAid = this.findAppletForSelectApdu(command, apduCase);
                log.trace("Found {}", (Object)(newAid == null ? null : AIDUtil.toString(newAid)));
                if (this.currentAID == null) {
                    if (newAid == null) {
                        Util.setShort(theSW, (short)0, (short)27266);
                        byte[] byArray = theSW;
                        return byArray;
                    }
                    this.selecting = true;
                    applet = this.lookupApplet(newAid).getApplet();
                } else if (newAid == null) {
                    applet = this.lookupApplet(this.currentAID).getApplet();
                } else {
                    this.deselect(this.lookupApplet(this.currentAID));
                    this.selecting = true;
                    applet = this.lookupApplet(newAid).getApplet();
                }
            } else {
                if (this.currentAID == null) {
                    Util.setShort(theSW, (short)0, (short)27014);
                    byte[] byArray = theSW;
                    return byArray;
                }
                applet = this.lookupApplet(this.currentAID).getApplet();
                newAid = null;
            }
            if (APDUHelper.isExtendedAPDU(apduCase) && !(applet instanceof ExtendedLength)) {
                Util.setShort(theSW, (short)0, (short)26368);
                byte[] byArray = theSW;
                return byArray;
            }
            this.responseBufferSize = 0;
            APDU apdu = this.currentAPDU.getAPDU();
            try {
                if (this.selecting) {
                    boolean success;
                    this.currentAID = newAid;
                    log.trace("Calling Applet.select() of {}", (Object)AIDUtil.toString(this.currentAID));
                    try {
                        success = applet.select();
                    }
                    catch (Exception e) {
                        Simulator.log_exception(e, "Exception in Applet.select()");
                        success = false;
                    }
                    if (!success) {
                        log.warn("{} denied selection in Applet.select()", (Object)AIDUtil.toString(this.currentAID));
                        this.currentAID = null;
                        throw new ISOException(27033);
                    }
                }
                this.currentAPDU.reset(protocol, command);
                applet.process(apdu);
                Util.setShort(theSW, (short)0, (short)-28672);
            }
            catch (Throwable e) {
                Util.setShort(theSW, (short)0, (short)28416);
                if (e instanceof ISOException) {
                    Util.setShort(theSW, (short)0, ((ISOException)e).getReason());
                } else {
                    Simulator.log_exception(e, "Exception in process()");
                }
            }
            finally {
                this.selecting = false;
                this.currentAPDU.disable();
            }
            if (theSW[0] == 97 || theSW[0] == 98 || theSW[0] == 99 || theSW[0] >= -112 && theSW[0] <= -97 || this.isNotAbortingCase(theSW)) {
                response = new byte[this.responseBufferSize + 2];
                Util.arrayCopyNonAtomic(this.responseBuffer, (short)0, response, (short)0, this.responseBufferSize);
                Util.arrayCopyNonAtomic(theSW, (short)0, response, this.responseBufferSize, (short)2);
            } else {
                response = theSW;
            }
            byte[] byArray = response;
            return byArray;
        }
        finally {
            this._releaseCurrent();
        }
    }

    static void log_exception(Throwable e, String message) {
        if (e.getClass().getName().startsWith("javacard.") || e.getClass().getName().startsWith("javacardx.")) {
            if (log.isTraceEnabled()) {
                log.error("{}: {}", new Object[]{message, e.getClass().getName(), e});
            } else {
                log.error("{}: {}", (Object)message, (Object)e.getClass().getName());
            }
        } else {
            log.error("{}: {}", new Object[]{message, e.getClass().getSimpleName(), e});
        }
    }

    static boolean isAppletSelectionApdu(byte[] apdu) {
        int channelMask = -4;
        int p2Mask = -29;
        byte cla = (byte)(apdu[0] & 0xFFFFFFFC);
        byte ins = apdu[1];
        byte p1 = apdu[2];
        byte p2 = (byte)(apdu[3] & 0xFFFFFFE3);
        return cla == 0 && ins == -92 && p1 == 4 && p2 == 0;
    }

    protected boolean isNotAbortingCase(byte[] SW) {
        return false;
    }

    protected AID findAppletForSelectApdu(byte[] selectApdu, int apduCase) {
        if (apduCase == 1 || apduCase == 2) {
            if (this.applets.containsKey(GlobalPlatformApplet.OPEN_AID)) {
                log.info("Selecting OPEN");
                return GlobalPlatformApplet.OPEN_AID;
            }
            return null;
        }
        for (AID aid : this.applets.keySet()) {
            if (!aid.equals(selectApdu, (short)5, selectApdu[4])) continue;
            log.trace("Selecting {} based on full AID match", (Object)AIDUtil.toString(aid));
            return aid;
        }
        for (AID aid : this.applets.keySet()) {
            if (!aid.partialEquals(selectApdu, (short)5, selectApdu[4])) continue;
            log.trace("Selecting {} based on partial AID match", (Object)AIDUtil.toString(aid));
            return aid;
        }
        return null;
    }

    private void deselect(ApplicationInstance app) {
        log.trace("Applet.deselect(): {}", (Object)AIDUtil.toString(app.getAID()));
        try {
            Applet applet = app.getApplet();
            applet.deselect();
        }
        catch (Exception e) {
            Simulator.log_exception(e, "Exception in Applet.deselect()");
        }
        this.currentAID = null;
        if (this.getTransactionDepth() != 0) {
            this.abortTransaction();
        }
        this.transientMemory.clearOnDeselect();
    }

    @Override
    public void sendAPDU(byte[] buffer, short bOff, short len) {
        this.responseBufferSize = Util.arrayCopyNonAtomic(buffer, bOff, this.responseBuffer, this.responseBufferSize, len);
    }

    @Override
    public void reset() {
        Arrays.fill(this.responseBuffer, (byte)0);
        this.transactionDepth = 0;
        this.responseBufferSize = 0;
        this.currentAID = null;
        this.previousAID = null;
        this.transientMemory.clearOnReset();
        this.globalPlatform.reset();
    }

    @Override
    public TransientMemory getTransientMemory() {
        return this.transientMemory;
    }

    @Override
    public GlobalPlatform getGlobalPlatform() {
        return this.globalPlatform;
    }

    @Override
    public byte getAssignedChannel() {
        return 0;
    }

    @Override
    public void beginTransaction() {
        if (this.transactionDepth != 0) {
            TransactionException.throwIt((short)1);
        }
        this.transactionDepth = 1;
    }

    @Override
    public void abortTransaction() {
        if (this.transactionDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        this.transactionDepth = 0;
    }

    @Override
    public void commitTransaction() {
        if (this.transactionDepth == 0) {
            TransactionException.throwIt((short)2);
        }
        this.transactionDepth = 0;
    }

    @Override
    public byte getTransactionDepth() {
        return this.transactionDepth;
    }

    @Override
    public short getUnusedCommitCapacity() {
        return Short.MAX_VALUE;
    }

    @Override
    public short getMaxCommitCapacity() {
        return Short.MAX_VALUE;
    }

    @Override
    public short getAvailablePersistentMemory() {
        return Short.MAX_VALUE;
    }

    @Override
    public Shareable getSharedObject(AID serverAID, byte parameter) {
        log.info("Getting Shareable from {} in {}", (Object)AIDUtil.toString(serverAID), (Object)System.identityHashCode(this));
        Applet serverApplet = this.getApplet(serverAID);
        if (serverApplet != null) {
            return serverApplet.getShareableInterfaceObject(this.getAID(), parameter);
        }
        log.warn("Did not find server AID {} in {}", (Object)AIDUtil.toString(serverAID), (Object)System.identityHashCode(this));
        return null;
    }

    @Override
    public boolean isObjectDeletionSupported() {
        return true;
    }

    @Override
    public void requestObjectDeletion() {
        if (!this.isObjectDeletionSupported()) {
            throw new SystemException(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadApplet(AID packageAid, AID appletAid, Class<? extends Applet> appletClass) {
        this._makeCurrent();
        try {
            Simulator.current().getGlobalPlatform().loadClass(packageAid, appletAid, appletClass);
        }
        finally {
            this._releaseCurrent();
        }
    }

    @Override
    public AID internalInstallApplet(AID appletAID, Class<? extends Applet> appletClass, byte[] privileges, byte[] parameters, boolean exposed) {
        Method installMethod;
        Class<Applet> klass;
        if (exposed) {
            klass = appletClass;
        } else {
            this.classLoader.isolate(new String[]{appletClass.getPackageName()});
            try {
                klass = this.classLoader.loadClass(appletClass.getName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not (re-)load " + appletClass.getName());
            }
        }
        try {
            installMethod = klass.getMethod("install", byte[].class, Short.TYPE, Byte.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class does not provide install method");
        }
        try {
            Field magic = klass.getField("jcardengine");
            magic.setBoolean(null, true);
        }
        catch (NoSuchFieldException magic) {
        }
        catch (IllegalAccessException e) {
            log.warn("Could not set magic field: {}", (Object)e.getMessage());
        }
        byte[] install_parameters = Helpers.install_parameters(AIDUtil.bytes(appletAID), privileges, parameters);
        options.set(new RegisterCallbackOptions(appletAID, exposed));
        try {
            installMethod.invoke(null, install_parameters, (short)0, (byte)install_parameters.length);
        }
        catch (InvocationTargetException e) {
            log.error("Exception in {} install() ", (Object)AIDUtil.toString(appletAID), (Object)e);
            if (e.getCause() instanceof ISOException) {
                ISOException isoex = (ISOException)e.getCause();
                log.error(String.format("ISOException: 0x%04X", isoex.getReason()), (Throwable)isoex);
            }
            throw new JavaCardEngineException("Exception in install()", e);
        }
        catch (Exception e) {
            log.error("Error installing applet " + AIDUtil.toString(appletAID), (Throwable)e);
            throw new SystemException(4);
        }
        if (options.get() != null) {
            log.error("install() did not call register()");
            throw new JavaCardEngineException("install() did not call register()");
        }
        return appletAID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AID installApplet(AID appletAID, Class<? extends Applet> appletClass, byte[] parameters, boolean exposed) {
        this._makeCurrent();
        try {
            if (this.currentAID != null) {
                this.deselect(this.lookupApplet(this.currentAID));
            }
            AID aID = this.internalInstallApplet(appletAID, appletClass, null, parameters, exposed);
            return aID;
        }
        finally {
            this.memstat();
            this._releaseCurrent();
        }
    }

    @Override
    public void register(Object instance) {
        try {
            if (options.get() == null || this.applets.containsKey(Simulator.options.get().aid)) {
                log.warn("{} already registered or not called from install()", (Object)instance.getClass().getName());
                SystemException.throwIt((short)4);
            }
            AID instanceAID = Simulator.options.get().aid;
            log.info("Registering {} as {} in {}", new Object[]{instance.getClass().getName(), AIDUtil.toString(instanceAID), System.identityHashCode(this)});
            this.applets.put(instanceAID, new ApplicationInstance(instanceAID, instance, Simulator.options.get().exposed));
        }
        finally {
            options.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object instance, byte[] buffer, short offset, byte len) {
        try {
            AID actual = new AID(buffer, offset, len);
            if (options.get() == null || this.applets.containsKey(actual)) {
                SystemException.throwIt((short)4);
            }
            log.info("Registering {} as {} in {}", new Object[]{instance.getClass().getName(), AIDUtil.toString(actual), System.identityHashCode(this)});
            this.applets.put(actual, new ApplicationInstance(actual, instance, Simulator.options.get().exposed));
        }
        finally {
            options.remove();
        }
    }

    public static byte[] allocate(int size) {
        Simulator current = (Simulator)Simulator.current();
        current.bytesAllocated += size;
        log.trace("Allocating {} bytes in {}; total is {}", new Object[]{size, System.identityHashCode(current), current.bytesAllocated});
        return new byte[size];
    }

    public Simulator isolate(String ... packageNames) {
        this.classLoader.isolate(packageNames);
        return this;
    }

    public void memstat() {
        log.info("Persistent         {}", (Object)this.bytesAllocated);
        log.info("CLEAR_ON_RESET:    {}", (Object)this.transientMemory.getSumCOR());
        log.info("CLEAR_ON_DESELECT: {}", (Object)this.transientMemory.getSumCOD());
    }

    @Override
    public EngineSession connectFor(Duration timeout, String protocol) {
        log.info("Connecting for {} with {}", (Object)timeout, (Object)protocol);
        return new SimulatorSession(this, protocol, timeout);
    }

    @Override
    public JavaCardEngine exposed(boolean flag) {
        this.exposed = flag;
        return this;
    }

    @Override
    public JavaCardEngine withClassLoader(ClassLoader loader) {
        this.classLoader = new IsolatingClassLoader(loader);
        return this;
    }

    static {
        System.setProperty("org.bouncycastle.rsa.no_lenstra_check", "true");
        log = LoggerFactory.getLogger(Simulator.class);
        currentSimulator = new ThreadLocal();
        options = new ThreadLocal();
    }

    private static class RegisterCallbackOptions {
        public final AID aid;
        public final boolean exposed;

        public RegisterCallbackOptions(AID aid, boolean exposed) {
            this.aid = aid;
            this.exposed = exposed;
        }
    }
}

