/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javacard.framework.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientMemory {
    private static final Logger log = LoggerFactory.getLogger(TransientMemory.class);
    protected final ArrayList<Object> clearOnDeselect = new ArrayList();
    protected final ArrayList<Object> clearOnReset = new ArrayList();
    private int sumCOD;
    private int sumCOR;

    private void add(Object obj, byte event) {
        int toAdd = 0;
        if (obj instanceof byte[]) {
            toAdd += ((byte[])obj).length;
        } else if (obj instanceof short[]) {
            toAdd += ((short[])obj).length * 2;
        } else if (obj instanceof Object[]) {
            toAdd += ((Object[])obj).length * 2;
        } else if (obj instanceof boolean[]) {
            toAdd += ((boolean[])obj).length;
        } else {
            log.warn("Unsupported object: {}", (Object)obj.getClass());
        }
        if (event == 1) {
            this.sumCOR += toAdd;
        } else if (event == 2) {
            this.sumCOD += toAdd;
        } else {
            log.warn("Unsupported event {}", (Object)event);
        }
    }

    public boolean[] makeBooleanArray(short length, byte event) {
        boolean[] array = new boolean[length];
        this.storeArray(array, event);
        return array;
    }

    public byte[] makeByteArray(int length, byte event) {
        byte[] array = new byte[length];
        this.storeArray(array, event);
        return array;
    }

    public short[] makeShortArray(short length, byte event) {
        short[] array = new short[length];
        this.storeArray(array, event);
        return array;
    }

    public Object[] makeObjectArray(short length, byte event) {
        Object[] array = new Object[length];
        this.storeArray(array, event);
        return array;
    }

    public Object makeGlobalArray(byte type, short length) {
        Object[] array = null;
        switch (type) {
            case 1: {
                array = this.makeBooleanArray(length, (byte)1);
                break;
            }
            case 2: {
                array = this.makeByteArray(length, (byte)1);
                break;
            }
            case 3: {
                array = this.makeShortArray(length, (byte)1);
                break;
            }
            case 5: {
                array = this.makeObjectArray(length, (byte)1);
                break;
            }
            case 4: {
                SystemException.throwIt((short)1);
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
        return array;
    }

    public byte isTransient(Object theObj) {
        if (this.clearOnDeselect.contains(theObj)) {
            return 2;
        }
        if (this.clearOnReset.contains(theObj)) {
            return 1;
        }
        return 0;
    }

    protected void storeArray(Object arrayRef, byte event) {
        this.add(arrayRef, event);
        switch (event) {
            case 2: {
                this.clearOnDeselect.add(arrayRef);
                break;
            }
            case 1: {
                this.clearOnReset.add(arrayRef);
                break;
            }
            default: {
                SystemException.throwIt((short)1);
            }
        }
    }

    protected void clearOnDeselect() {
        this.zero(this.clearOnDeselect);
    }

    protected void clearOnReset() {
        this.zero(this.clearOnDeselect);
        this.zero(this.clearOnReset);
    }

    protected void forgetBuffers() {
        this.clearOnReset();
        this.clearOnDeselect.clear();
        this.clearOnReset.clear();
        this.sumCOD = 0;
        this.sumCOR = 0;
    }

    protected void zero(List<Object> list) {
        for (Object obj : list) {
            if (obj instanceof byte[]) {
                Arrays.fill((byte[])obj, (byte)0);
                continue;
            }
            if (obj instanceof short[]) {
                Arrays.fill((short[])obj, (short)0);
                continue;
            }
            if (obj instanceof Object[]) {
                Arrays.fill((Object[])obj, null);
                continue;
            }
            if (obj instanceof boolean[]) {
                Arrays.fill((boolean[])obj, false);
                continue;
            }
            log.warn("Unsupported object: {}", (Object)obj.getClass());
        }
    }

    public int getSumCOD() {
        return this.sumCOD;
    }

    public int getSumCOR() {
        return this.sumCOR;
    }

    public short getAvailableTransientResetMemory() {
        return Short.MAX_VALUE;
    }

    public short getAvailableTransientDeselectMemory() {
        return Short.MAX_VALUE;
    }
}

