/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.adapters;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.engine.EngineSession;
import pro.javacard.engine.adapters.RemoteMessage;
import pro.javacard.engine.adapters.VSmartCardClient;

public abstract class AbstractTCPAdapter
implements Callable<Boolean> {
    private final Logger log = LoggerFactory.getLogger(AbstractTCPAdapter.class);
    public static final String DEFAULT_ATR_HEX = "3B80800101";
    static final byte[] DEFAULT_ATR = Hex.decode((String)"3B80800101");
    protected final Supplier<EngineSession> sim;
    protected byte[] atr = DEFAULT_ATR;
    protected String protocol = "*";
    protected String host;
    protected int port;
    private volatile Thread thread;
    private AdapterState currentState = AdapterState.CONNECTED;
    private final AtomicReference<AdapterState> targetState = new AtomicReference<Object>(null);
    private final Semaphore semaphore = new Semaphore(1);

    protected void start() throws IOException {
    }

    protected abstract RemoteMessage recv(SocketChannel var1) throws IOException;

    protected abstract void send(SocketChannel var1, RemoteMessage var2) throws IOException;

    protected abstract SocketChannel getSocket() throws IOException;

    protected AbstractTCPAdapter(Supplier<EngineSession> sim) {
        this.sim = sim;
    }

    public AbstractTCPAdapter withATR(byte[] atr) {
        this.atr = (byte[])atr.clone();
        return this;
    }

    public AbstractTCPAdapter withPort(int port) {
        this.port = port;
        return this;
    }

    public AbstractTCPAdapter withHost(String host) {
        this.host = host;
        return this;
    }

    public void tap() {
        this.log.info("Triggering tap");
        if (!this.targetState.compareAndSet(null, AdapterState.RESET)) {
            throw new IllegalStateException("Can't trigger reset!");
        }
        this.thread.interrupt();
        this.semaphore.acquireUninterruptibly();
    }

    public void connected(boolean flag) {
        if (!this.targetState.compareAndSet(null, flag ? AdapterState.CONNECTED : AdapterState.DISCONNECTED)) {
            throw new IllegalStateException("Can't toggle state!");
        }
        this.thread.interrupt();
        this.semaphore.acquireUninterruptibly();
    }

    public void shutdown() {
        this.log.trace("Shutting down adapter...");
        this.targetState.set(AdapterState.SHUTDOWN);
        this.thread.interrupt();
    }

    @Override
    public Boolean call() {
        this.thread = Thread.currentThread();
        this.thread.setName(this.getClass().getSimpleName());
        EngineSession session = null;
        try {
            this.start();
        }
        catch (Exception e) {
            this.log.error("Could not start: " + e.getMessage(), (Throwable)e);
            this.currentState = AdapterState.SHUTDOWN;
        }
        block24: while (!Thread.currentThread().isInterrupted()) {
            block4 : switch (this.currentState) {
                case DISCONNECTED: {
                    AdapterState target;
                    if (session != null) {
                        session.close(true);
                        session = null;
                    }
                    try {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                    catch (InterruptedException e) {
                        this.log.debug("State changed, checking new state");
                        target = this.targetState.getAndSet(null);
                        this.currentState = target == null ? AdapterState.SHUTDOWN : target;
                        this.semaphore.release();
                    }
                    continue block24;
                }
                case SHUTDOWN: {
                    this.log.info("Shutting down. Bye!");
                    return true;
                }
                case RESET: {
                    if (session != null) {
                        session.close(true);
                        session = null;
                    }
                    this.currentState = AdapterState.CONNECTED;
                    continue block24;
                }
                case CONNECTED: {
                    AdapterState target;
                    try {
                        SocketChannel channel = this.getSocket();
                        this.log.info("Serving peer {}", (Object)channel.getRemoteAddress());
                        block25: while (!Thread.currentThread().isInterrupted() && this.currentState == AdapterState.CONNECTED) {
                            try {
                                RemoteMessage msg = this.recv(channel);
                                if (this.getClass() != VSmartCardClient.class || msg.getType() != RemoteMessage.Type.ATR) {
                                    this.log.trace("Processing {}", (Object)msg.getType());
                                }
                                switch (msg.getType()) {
                                    case ATR: {
                                        this.send(channel, new RemoteMessage(RemoteMessage.Type.ATR, this.atr));
                                        continue block25;
                                    }
                                    case RESET: {
                                        if (session != null) {
                                            session.close(true);
                                        }
                                        session = this.sim.get();
                                        this.send(channel, new RemoteMessage(RemoteMessage.Type.RESET));
                                        continue block25;
                                    }
                                    case POWERUP: {
                                        if (session != null) {
                                            this.log.warn("Session is not null");
                                        }
                                        session = this.sim.get();
                                        this.send(channel, new RemoteMessage(RemoteMessage.Type.POWERUP));
                                        continue block25;
                                    }
                                    case POWERDOWN: {
                                        if (session != null) {
                                            session.close(true);
                                        }
                                        session = null;
                                        this.send(channel, new RemoteMessage(RemoteMessage.Type.POWERDOWN));
                                        continue block25;
                                    }
                                    case APDU: {
                                        byte[] cmd;
                                        if (session == null || session.isClosed()) {
                                            this.log.warn("No session opened before APDU-s!");
                                            session = this.sim.get();
                                        }
                                        if (Arrays.equals(cmd = msg.getPayload(), Hex.decode((String)"FFCA000000")) && this.protocol.equals("T=CL")) {
                                            this.log.info("Intercepting GET UID");
                                            this.send(channel, new RemoteMessage(RemoteMessage.Type.APDU, Hex.decode((String)"040102039000")));
                                            continue block25;
                                        }
                                        this.log.info(">> {}", (Object)Hex.toHexString((byte[])cmd));
                                        byte[] response = session.transmitCommand(cmd);
                                        this.log.info("<< {}", (Object)Hex.toHexString((byte[])response));
                                        this.send(channel, new RemoteMessage(RemoteMessage.Type.APDU, response));
                                        continue block25;
                                    }
                                }
                                this.log.warn("Unhandled message type: " + String.valueOf((Object)msg.getType()));
                            }
                            catch (EOFException e) {
                                this.log.info("Peer disconnected");
                                break block4;
                            }
                        }
                        break;
                    }
                    catch (ClosedByInterruptException e) {
                        if (!Thread.interrupted()) break;
                        target = this.targetState.getAndSet(null);
                        this.log.trace("interrupted with {}", (Object)target);
                        this.currentState = target == null ? AdapterState.SHUTDOWN : target;
                        this.semaphore.release();
                        break;
                    }
                    catch (SocketException | SocketTimeoutException e) {
                        this.log.error("Connection error: {}", (Object)e.getClass().getSimpleName());
                        this.log.trace("Exception", (Throwable)e);
                        return false;
                    }
                    catch (IOException e) {
                        this.log.error("I/O error: {}", (Object)e.getClass().getSimpleName());
                        this.log.trace("Exception", (Throwable)e);
                        break;
                    }
                    catch (Exception e) {
                        this.log.error("Unhandled exception in adapter process", (Throwable)e);
                    }
                }
            }
            this.log.trace("Adapter loop done");
        }
        this.log.info("Adapter thread done");
        return true;
    }

    public static SocketChannel connect(String host, Integer port) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(host, (int)port);
        SocketChannel sc = SocketChannel.open();
        sc.socket().connect(addr, 3000);
        if (!sc.isConnected()) {
            throw new IOException("Could not connect to " + String.valueOf(addr));
        }
        return sc;
    }

    public static ServerSocketChannel start(String host, Integer port) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(host, (int)port);
        ServerSocketChannel server = ServerSocketChannel.open();
        return server.bind(addr);
    }

    public String toString() {
        return String.format("%s{host=%s port=%d atr=%s protocol=%s}", this.getClass().getSimpleName(), this.host, this.port, Hex.toHexString((byte[])this.atr), this.protocol);
    }

    public static enum AdapterState {
        CONNECTED,
        DISCONNECTED,
        RESET,
        SHUTDOWN;

    }
}

