/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.licel.jcardsim.base.Simulator;
import javacard.framework.AID;
import javacard.framework.Shareable;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;

public final class JCSystem {
    public static final byte MEMORY_TYPE_PERSISTENT = 0;
    public static final byte MEMORY_TYPE_TRANSIENT_RESET = 1;
    public static final byte MEMORY_TYPE_TRANSIENT_DESELECT = 2;
    public static final byte ARRAY_TYPE_BOOLEAN = 1;
    public static final byte ARRAY_TYPE_BYTE = 2;
    public static final byte ARRAY_TYPE_SHORT = 3;
    public static final byte ARRAY_TYPE_INT = 4;
    public static final byte ARRAY_TYPE_OBJECT = 5;
    public static final byte NOT_A_TRANSIENT_OBJECT = 0;
    public static final byte CLEAR_ON_RESET = 1;
    public static final byte CLEAR_ON_DESELECT = 2;

    public static byte isTransient(Object theObj) {
        return Simulator.current().getTransientMemory().isTransient(theObj);
    }

    public static boolean[] makeTransientBooleanArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return Simulator.current().getTransientMemory().makeBooleanArray(length, event);
    }

    public static byte[] makeTransientByteArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return Simulator.current().getTransientMemory().makeByteArray(length, event);
    }

    public static short[] makeTransientShortArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return Simulator.current().getTransientMemory().makeShortArray(length, event);
    }

    public static Object[] makeTransientObjectArray(short length, byte event) throws NegativeArraySizeException, SystemException {
        return Simulator.current().getTransientMemory().makeObjectArray(length, event);
    }

    public static Object makeGlobalArray(byte type, short length) {
        return Simulator.current().getTransientMemory().makeGlobalArray(type, length);
    }

    public static short getVersion() {
        return 768;
    }

    public static AID getAID() {
        return Simulator.current().getAID();
    }

    public static AID lookupAID(byte[] buffer, short offset, byte length) {
        return Simulator.current().lookupAID(buffer, offset, length);
    }

    public static void beginTransaction() throws TransactionException {
        Simulator.current().beginTransaction();
    }

    public static void abortTransaction() throws TransactionException {
        Simulator.current().abortTransaction();
    }

    public static void commitTransaction() throws TransactionException {
        Simulator.current().commitTransaction();
    }

    public static byte getTransactionDepth() {
        return Simulator.current().getTransactionDepth();
    }

    public static short getUnusedCommitCapacity() {
        return Simulator.current().getUnusedCommitCapacity();
    }

    public static short getMaxCommitCapacity() {
        return Simulator.current().getMaxCommitCapacity();
    }

    public static AID getPreviousContextAID() {
        return Simulator.current().getPreviousContextAID();
    }

    public static short getAvailableMemory(byte memoryType) throws SystemException {
        switch (memoryType) {
            case 0: {
                return Simulator.current().getAvailablePersistentMemory();
            }
            case 1: {
                return Simulator.current().getTransientMemory().getAvailableTransientResetMemory();
            }
            case 2: {
                return Simulator.current().getTransientMemory().getAvailableTransientDeselectMemory();
            }
        }
        SystemException.throwIt((short)1);
        return 0;
    }

    public static void getAvailableMemory(short[] buffer, short offset, byte memoryType) {
        buffer[offset] = 0;
        buffer[offset + 1] = JCSystem.getAvailableMemory(memoryType);
    }

    public static Shareable getAppletShareableInterfaceObject(AID serverAID, byte parameter) {
        return Simulator.current().getSharedObject(serverAID, parameter);
    }

    public static boolean isObjectDeletionSupported() {
        return Simulator.current().isObjectDeletionSupported();
    }

    public static void requestObjectDeletion() throws SystemException {
        Simulator.current().requestObjectDeletion();
    }

    public static byte getAssignedChannel() {
        return Simulator.current().getAssignedChannel();
    }

    public static boolean isAppletActive(AID theApplet) {
        return theApplet == Simulator.current().getAID();
    }
}

