/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.engine.globalplatform;

import java.util.Arrays;
import org.globalplatform.CVM;

public class GlobalPINImpl
implements CVM {
    private static final byte INACTIVE = 0;
    private static final byte ACTIVE = 1;
    private static final byte INVALID_SUBMISSION = 2;
    private static final byte VALIDATED = 3;
    private static final byte BLOCKED = 4;
    byte state = 0;
    byte format;
    byte[] value = null;
    byte try_counter = 0;
    byte try_limit = (byte)-1;

    @Override
    public boolean isActive() {
        return this.state > 0;
    }

    @Override
    public boolean isSubmitted() {
        return this.state == 2 || this.state == 3;
    }

    @Override
    public boolean isVerified() {
        return this.state == 3;
    }

    @Override
    public boolean isBlocked() {
        return this.state == 4;
    }

    @Override
    public byte getTriesRemaining() {
        return this.try_counter;
    }

    @Override
    public boolean update(byte[] bytes, short i, byte b, byte b1) {
        if (b1 != 3) {
            return false;
        }
        this.value = Arrays.copyOfRange(bytes, (int)i, (int)b);
        this.format = b1;
        if (this.try_limit > 0) {
            this.try_counter = this.try_limit;
            this.state = 1;
        }
        return true;
    }

    @Override
    public boolean resetState() {
        if (this.state > 0 && this.state < 4) {
            this.state = 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean blockState() {
        if (this.state > 0) {
            this.state = (byte)4;
            return true;
        }
        return false;
    }

    @Override
    public boolean resetAndUnblockState() {
        if (this.state > 0) {
            this.state = 1;
        }
        return false;
    }

    @Override
    public boolean setTryLimit(byte b) {
        if (b > 0) {
            this.try_limit = b;
            if (this.value != null) {
                this.state = 1;
            }
            return true;
        }
        return false;
    }

    @Override
    public short verify(byte[] bytes, short i, byte b, byte b1) {
        if (this.isBlocked() || !this.isActive()) {
            return -1;
        }
        if (b1 == this.format && Arrays.equals(this.value, Arrays.copyOfRange(bytes, (int)i, (int)b))) {
            this.try_counter = this.try_limit;
            this.state = (byte)3;
            return 0;
        }
        this.state = (byte)2;
        this.try_counter = (byte)(this.try_counter - 1);
        if (this.try_counter == 0) {
            this.state = (byte)4;
        }
        return -1;
    }
}

