/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.KeyWithParameters;
import javacard.framework.JCSystem;
import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacardx.crypto.Cipher;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;

public class AsymmetricCipherImpl
extends Cipher {
    byte algorithm;
    AsymmetricBlockCipher engine;
    boolean isInitialized;
    byte[] buffer;
    short bufferPos;
    byte initMode;

    public AsymmetricCipherImpl(byte algorithm) {
        this.algorithm = algorithm;
        switch (algorithm) {
            case 12: {
                this.engine = new RSAEngine();
                break;
            }
            case 10: {
                this.engine = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
                break;
            }
            case 15: {
                this.engine = new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine());
                break;
            }
            default: {
                CryptoException.throwIt((short)3);
            }
        }
    }

    @Override
    public void init(Key theKey, byte theMode) throws CryptoException {
        if (theKey == null) {
            CryptoException.throwIt((short)2);
        }
        if (!theKey.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        if (!(theKey instanceof KeyWithParameters)) {
            CryptoException.throwIt((short)1);
        }
        KeyWithParameters key = (KeyWithParameters)((Object)theKey);
        this.initMode = theMode;
        this.engine.init(theMode == 2, key.getParameters());
        this.buffer = JCSystem.makeTransientByteArray((short)(this.engine.getInputBlockSize() + (theMode == 2 ? 1 : 0)), (byte)2);
        this.bufferPos = 0;
        this.isInitialized = true;
    }

    @Override
    public void init(Key theKey, byte theMode, byte[] bArray, short bOff, short bLen) throws CryptoException {
        CryptoException.throwIt((short)1);
    }

    @Override
    public byte getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public short doFinal(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if (this.initMode == 2) {
            if (outBuff.length - outOffset < this.engine.getOutputBlockSize()) {
                CryptoException.throwIt((short)5);
            }
            if (inLength - inOffset > this.engine.getInputBlockSize() + (this.algorithm == 12 ? 1 : 0)) {
                CryptoException.throwIt((short)5);
            }
        }
        this.update(inBuff, inOffset, inLength, outBuff, outOffset);
        if (this.algorithm == 12 && this.bufferPos < this.engine.getInputBlockSize()) {
            CryptoException.throwIt((short)5);
        }
        try {
            byte[] data = this.engine.processBlock(this.buffer, 0, (int)this.bufferPos);
            Util.arrayCopyNonAtomic(data, (short)0, outBuff, outOffset, (short)data.length);
            this.bufferPos = 0;
            return (short)data.length;
        }
        catch (DataLengthException | InvalidCipherTextException ex) {
            CryptoException.throwIt((short)5);
            return -1;
        }
    }

    @Override
    public short update(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        if (!this.isInitialized) {
            CryptoException.throwIt((short)4);
        }
        if (inLength > this.buffer.length - this.bufferPos) {
            CryptoException.throwIt((short)5);
        }
        this.bufferPos = (short)(this.bufferPos + Util.arrayCopyNonAtomic(inBuff, inOffset, this.buffer, this.bufferPos, inLength));
        return this.bufferPos;
    }

    @Override
    public byte getPaddingAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getCipherAlgorithm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

