/*
 * Decompiled with CFR 0.152.
 */
package com.licel.jcardsim.crypto;

import com.licel.jcardsim.crypto.ByteContainer;
import com.licel.jcardsim.crypto.RSAKeyImpl;
import java.math.BigInteger;
import javacard.security.CryptoException;
import javacard.security.RSAPrivateCrtKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAPrivateCrtKeyImpl
extends RSAKeyImpl
implements RSAPrivateCrtKey {
    private static final Logger log = LoggerFactory.getLogger(RSAPrivateCrtKeyImpl.class);
    protected ByteContainer p = new ByteContainer();
    protected ByteContainer q = new ByteContainer();
    protected ByteContainer dp1 = new ByteContainer();
    protected ByteContainer dq1 = new ByteContainer();
    protected ByteContainer pq = new ByteContainer();

    public RSAPrivateCrtKeyImpl(short keySize) {
        super(true, keySize);
        this.type = (byte)6;
    }

    @Override
    public void setParameters(CipherParameters params) {
        this.p.setBigInteger(((RSAPrivateCrtKeyParameters)params).getP());
        this.q.setBigInteger(((RSAPrivateCrtKeyParameters)params).getQ());
        this.dp1.setBigInteger(((RSAPrivateCrtKeyParameters)params).getDP());
        this.dq1.setBigInteger(((RSAPrivateCrtKeyParameters)params).getDQ());
        this.pq.setBigInteger(((RSAPrivateCrtKeyParameters)params).getQInv());
    }

    @Override
    public void setP(byte[] buffer, short offset, short length) throws CryptoException {
        this.p.setBytes(buffer, offset, length);
    }

    @Override
    public void setQ(byte[] buffer, short offset, short length) throws CryptoException {
        this.q.setBytes(buffer, offset, length);
    }

    @Override
    public void setDP1(byte[] buffer, short offset, short length) throws CryptoException {
        this.dp1.setBytes(buffer, offset, length);
    }

    @Override
    public void setDQ1(byte[] buffer, short offset, short length) throws CryptoException {
        this.dq1.setBytes(buffer, offset, length);
    }

    @Override
    public void setPQ(byte[] buffer, short offset, short length) throws CryptoException {
        this.pq.setBytes(buffer, offset, length);
    }

    @Override
    public short getP(byte[] buffer, short offset) {
        return this.p.getBytes(buffer, offset);
    }

    @Override
    public short getQ(byte[] buffer, short offset) {
        return this.q.getBytes(buffer, offset);
    }

    @Override
    public short getDP1(byte[] buffer, short offset) {
        return this.dp1.getBytes(buffer, offset);
    }

    @Override
    public short getDQ1(byte[] buffer, short offset) {
        return this.dq1.getBytes(buffer, offset);
    }

    @Override
    public short getPQ(byte[] buffer, short offset) {
        return this.pq.getBytes(buffer, offset);
    }

    @Override
    public void clearKey() {
        super.clearKey();
        this.p.clear();
        this.q.clear();
        this.dp1.clear();
        this.dq1.clear();
        this.pq.clear();
    }

    @Override
    public boolean isInitialized() {
        return this.p.isInitialized() && this.q.isInitialized() && this.dp1.isInitialized() && this.dq1.isInitialized() && this.pq.isInitialized();
    }

    @Override
    public CipherParameters getParameters() {
        if (!this.isInitialized()) {
            CryptoException.throwIt((short)2);
        }
        BigInteger exp = this.exponent.isInitialized() ? this.exponent.getBigInteger() : this.reconstructPublicExponent(this.p.getBigInteger(), this.q.getBigInteger(), this.dp1.getBigInteger(), this.dq1.getBigInteger(), this.pq.getBigInteger());
        return new RSAPrivateCrtKeyParameters(this.p.getBigInteger().multiply(this.q.getBigInteger()), exp, null, this.p.getBigInteger(), this.q.getBigInteger(), this.dp1.getBigInteger(), this.dq1.getBigInteger(), this.pq.getBigInteger());
    }

    public BigInteger reconstructPublicExponent(BigInteger p, BigInteger q, BigInteger dp1, BigInteger dq1, BigInteger pq) {
        BigInteger[] commonExponents;
        BigInteger p1 = p.subtract(BigInteger.ONE);
        BigInteger q1 = q.subtract(BigInteger.ONE);
        BigInteger phi = p1.multiply(q1);
        for (BigInteger candidateE : commonExponents = new BigInteger[]{BigInteger.valueOf(65537L), BigInteger.valueOf(17L), BigInteger.valueOf(3L), BigInteger.valueOf(5L), BigInteger.valueOf(257L), BigInteger.valueOf(65539L)}) {
            BigInteger candidateD;
            if (!candidateE.gcd(phi).equals(BigInteger.ONE) || !(candidateD = candidateE.modInverse(phi)).mod(p1).equals(dp1) || !candidateD.mod(q1).equals(dq1)) continue;
            return candidateE;
        }
        BigInteger d = this.robustCRT(dp1, p1, dq1, q1);
        if (!d.gcd(phi).equals(BigInteger.ONE)) {
            throw new ArithmeticException("Reconstructed d is not invertible modulo phi(n). Check CRT inputs.");
        }
        return d.modInverse(phi);
    }

    private BigInteger robustCRT(BigInteger a1, BigInteger m1, BigInteger a2, BigInteger m2) {
        BigInteger gcd = m1.gcd(m2);
        if (!a1.subtract(a2).mod(gcd).equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("Incompatible CRT inputs");
        }
        BigInteger lcm = m1.divide(gcd).multiply(m2);
        BigInteger[] euclid = this.extendedGCD(m1.divide(gcd), m2.divide(gcd));
        BigInteger m1Inv = euclid[1];
        BigInteger diff = a2.subtract(a1).divide(gcd);
        BigInteger result = a1.add(m1.multiply(m1Inv).multiply(diff));
        return result.mod(lcm);
    }

    private BigInteger[] extendedGCD(BigInteger a, BigInteger b) {
        BigInteger old_r = a;
        BigInteger r = b;
        BigInteger old_s = BigInteger.ONE;
        BigInteger s = BigInteger.ZERO;
        BigInteger old_t = BigInteger.ZERO;
        BigInteger t = BigInteger.ONE;
        while (!r.equals(BigInteger.ZERO)) {
            BigInteger quotient = old_r.divide(r);
            BigInteger temp = r;
            r = old_r.subtract(quotient.multiply(r));
            old_r = temp;
            temp = s;
            s = old_s.subtract(quotient.multiply(s));
            old_s = temp;
            temp = t;
            t = old_t.subtract(quotient.multiply(t));
            old_t = temp;
        }
        return new BigInteger[]{old_r, old_s, old_t};
    }
}

